/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.ClassFileResourceProvider;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.AbortException;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

@Keep
public abstract class BaseCommand {
    private final boolean printHelp;
    private final boolean printVersion;
    private final AndroidApp app;

    BaseCommand(boolean printHelp, boolean printVersion) {
        this.printHelp = printHelp;
        this.printVersion = printVersion;
        this.app = null;
    }

    BaseCommand(AndroidApp app) {
        assert (app != null);
        this.app = app;
        this.printHelp = false;
        this.printVersion = false;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    AndroidApp getInputApp() {
        return this.app;
    }

    abstract InternalOptions getInternalOptions();

    @Keep
    public static abstract class Builder<C extends BaseCommand, B extends Builder<C, B>> {
        private final Reporter reporter;
        private boolean printHelp = false;
        private boolean printVersion = false;
        private final AndroidApp.Builder app;
        List<Path> programFiles = new ArrayList<Path>();

        Builder() {
            this(AndroidApp.builder());
        }

        Builder(DiagnosticsHandler handler) {
            this(AndroidApp.builder(new Reporter(handler)));
        }

        Builder(AndroidApp.Builder builder) {
            this.app = builder;
            this.reporter = builder.getReporter();
        }

        abstract B self();

        public final C build() throws CompilationFailedException {
            try {
                this.validate();
                C c = this.makeCommand();
                this.reporter.failIfPendingErrors();
                return c;
            }
            catch (AbortException e) {
                throw new CompilationFailedException(e);
            }
        }

        abstract C makeCommand();

        AndroidApp.Builder getAppBuilder() {
            return this.app;
        }

        public B addProgramFiles(Path ... files) {
            this.addProgramFiles(Arrays.asList(files));
            return this.self();
        }

        Reporter getReporter() {
            return this.reporter;
        }

        public B addProgramFiles(Collection<Path> files) {
            this.guard(() -> {
                for (Path path : files) {
                    try {
                        this.app.addProgramFile(path);
                        this.programFiles.add(path);
                    }
                    catch (CompilationError e) {
                        this.error(new ProgramInputOrigin(path), e);
                    }
                }
            });
            return this.self();
        }

        public B addProgramResourceProvider(ProgramResourceProvider programProvider) {
            this.app.addProgramResourceProvider(programProvider);
            return this.self();
        }

        public B addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.guard(() -> this.getAppBuilder().addLibraryResourceProvider(provider));
            return this.self();
        }

        public B addLibraryFiles(Path ... files) {
            this.addLibraryFiles(Arrays.asList(files));
            return this.self();
        }

        public B addLibraryFiles(Collection<Path> files) {
            this.guard(() -> {
                for (Path path : files) {
                    try {
                        this.app.addLibraryFile(path);
                    }
                    catch (CompilationError e) {
                        this.error(new LibraryInputOrigin(path), e);
                    }
                }
            });
            return this.self();
        }

        public B addClasspathFiles(Path ... files) {
            this.guard(() -> Arrays.stream(files).forEach(this::addClasspathFile));
            return this.self();
        }

        public B addClasspathFiles(Collection<Path> files) {
            this.guard(() -> files.forEach(this::addClasspathFile));
            return this.self();
        }

        private void addClasspathFile(Path file) {
            this.guard(() -> this.getAppBuilder().addClasspathFile(file));
        }

        public B addClasspathResourceProvider(ClassFileResourceProvider provider) {
            this.guard(() -> this.getAppBuilder().addClasspathResourceProvider(provider));
            return this.self();
        }

        public B addClassProgramData(byte[] data2, Origin origin) {
            this.guard(() -> this.app.addClassProgramData(data2, origin));
            return this.self();
        }

        B addDexProgramData(byte[] data2, Origin origin) {
            this.guard(() -> this.app.addDexProgramData(data2, origin));
            return this.self();
        }

        public B addMainDexListFiles(Path ... files) {
            this.guard(() -> {
                try {
                    this.app.addMainDexListFiles(files);
                }
                catch (NoSuchFileException e) {
                    this.reporter.error(new StringDiagnostic("Main-dex-list file does not exist", new PathOrigin(Paths.get(e.getFile(), new String[0]))));
                }
            });
            return this.self();
        }

        public B addMainDexListFiles(Collection<Path> files) {
            this.guard(() -> {
                try {
                    this.app.addMainDexListFiles(files);
                }
                catch (NoSuchFileException e) {
                    this.reporter.error(new StringDiagnostic("Main-dex-ist file does not exist", new PathOrigin(Paths.get(e.getFile(), new String[0]))));
                }
            });
            return this.self();
        }

        public B addMainDexClasses(String ... classes) {
            this.guard(() -> this.app.addMainDexClasses(classes));
            return this.self();
        }

        public B addMainDexClasses(Collection<String> classes) {
            this.guard(() -> this.app.addMainDexClasses(classes));
            return this.self();
        }

        public boolean isPrintHelp() {
            return this.printHelp;
        }

        public B setPrintHelp(boolean printHelp) {
            this.printHelp = printHelp;
            return this.self();
        }

        public boolean isPrintVersion() {
            return this.printVersion;
        }

        public B setPrintVersion(boolean printVersion) {
            this.printVersion = printVersion;
            return this.self();
        }

        public void error(Diagnostic diagnostic) {
            this.reporter.error(diagnostic);
        }

        public RuntimeException fatalError(Diagnostic diagnostic) {
            return this.reporter.fatalError(diagnostic);
        }

        void setIgnoreDexInArchive(boolean value) {
            this.guard(() -> this.app.setIgnoreDexInArchive(value));
        }

        void validate() {
        }

        void error(Origin origin, Throwable throwable) {
            this.reporter.error(new ExceptionDiagnostic(throwable, origin));
        }

        void guard(Runnable action) {
            try {
                action.run();
            }
            catch (CompilationError e) {
                this.reporter.error(e.toStringDiagnostic());
            }
            catch (AbortException abortException) {
                // empty catch block
            }
        }
    }

    private static class LibraryInputOrigin
    extends InputFileOrigin {
        public LibraryInputOrigin(Path file) {
            super("library input", file);
        }
    }

    private static class ProgramInputOrigin
    extends InputFileOrigin {
        public ProgramInputOrigin(Path file) {
            super("program input", file);
        }
    }

    static abstract class InputFileOrigin
    extends PathOrigin {
        private final String inputType;

        public InputFileOrigin(String inputType, Path file) {
            super(file);
            this.inputType = inputType;
        }

        @Override
        public String part() {
            return this.inputType + " '" + super.part() + "'";
        }
    }
}

