/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.AssertionsConfiguration;
import shadow.bundletool.com.android.tools.r8.BaseCommand;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.DexFilePerClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.InternalProgramOutputPathConsumer;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.OutputMode;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.StringConsumer;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryConfiguration;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryConfigurationParser;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;

@Keep
public abstract class BaseCompilerCommand
extends BaseCommand {
    private final CompilationMode mode;
    private final ProgramConsumer programConsumer;
    private final StringConsumer mainDexListConsumer;
    private final int minApiLevel;
    private final Reporter reporter;
    private final boolean enableDesugaring;
    private final boolean includeClassesChecksum;
    private final boolean optimizeMultidexForLinearAlloc;
    private final BiPredicate<String, Long> dexClassChecksumFilter;
    private final List<AssertionsConfiguration> assertionsConfiguration;

    BaseCompilerCommand(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.programConsumer = null;
        this.mainDexListConsumer = null;
        this.mode = null;
        this.minApiLevel = 0;
        this.reporter = new Reporter();
        this.enableDesugaring = true;
        this.includeClassesChecksum = false;
        this.optimizeMultidexForLinearAlloc = false;
        this.dexClassChecksumFilter = (name, checksum) -> true;
        this.assertionsConfiguration = new ArrayList<AssertionsConfiguration>();
    }

    BaseCompilerCommand(AndroidApp app, CompilationMode mode, ProgramConsumer programConsumer, StringConsumer mainDexListConsumer, int minApiLevel, Reporter reporter, boolean enableDesugaring, boolean optimizeMultidexForLinearAlloc, boolean includeClassesChecksum, BiPredicate<String, Long> dexClassChecksumFilter, List<AssertionsConfiguration> assertionsConfiguration) {
        super(app);
        assert (minApiLevel > 0);
        assert (mode != null);
        this.mode = mode;
        this.programConsumer = programConsumer;
        this.mainDexListConsumer = mainDexListConsumer;
        this.minApiLevel = minApiLevel;
        this.reporter = reporter;
        this.enableDesugaring = enableDesugaring;
        this.optimizeMultidexForLinearAlloc = optimizeMultidexForLinearAlloc;
        this.includeClassesChecksum = includeClassesChecksum;
        this.dexClassChecksumFilter = dexClassChecksumFilter;
        this.assertionsConfiguration = assertionsConfiguration;
    }

    public CompilationMode getMode() {
        return this.mode;
    }

    public int getMinApiLevel() {
        return this.minApiLevel;
    }

    public ProgramConsumer getProgramConsumer() {
        return this.programConsumer;
    }

    public StringConsumer getMainDexListConsumer() {
        return this.mainDexListConsumer;
    }

    public boolean getEnableDesugaring() {
        return this.enableDesugaring;
    }

    public boolean getIncludeClassesChecksum() {
        return this.includeClassesChecksum;
    }

    public BiPredicate<String, Long> getDexClassChecksumFilter() {
        return this.dexClassChecksumFilter;
    }

    public boolean isOptimizeMultidexForLinearAlloc() {
        return this.optimizeMultidexForLinearAlloc;
    }

    public List<AssertionsConfiguration> getAssertionsConfiguration() {
        return this.assertionsConfiguration;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    @Keep
    public static abstract class Builder<C extends BaseCompilerCommand, B extends Builder<C, B>>
    extends BaseCommand.Builder<C, B> {
        private ProgramConsumer programConsumer = null;
        private StringConsumer mainDexListConsumer = null;
        private Path outputPath = null;
        private OutputMode outputMode = OutputMode.DexIndexed;
        private CompilationMode mode;
        private int minApiLevel = 0;
        private boolean disableDesugaring = false;
        private List<StringResource> desugaredLibraryConfigurationResources = new ArrayList<StringResource>();
        private boolean includeClassesChecksum = false;
        private boolean lookupLibraryBeforeProgram = true;
        private boolean optimizeMultidexForLinearAlloc = false;
        private BiPredicate<String, Long> dexClassChecksumFilter = (name, checksum) -> true;
        private List<AssertionsConfiguration> assertionsConfiguration = new ArrayList<AssertionsConfiguration>();

        abstract CompilationMode defaultCompilationMode();

        Builder() {
            this.mode = this.defaultCompilationMode();
        }

        Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
            this.mode = this.defaultCompilationMode();
        }

        Builder(AndroidApp app) {
            super(AndroidApp.builder(app));
            this.mode = this.defaultCompilationMode();
        }

        Builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
            super(AndroidApp.builder(app, new Reporter(diagnosticsHandler)));
            this.mode = this.defaultCompilationMode();
        }

        public CompilationMode getMode() {
            return this.mode;
        }

        public B setMode(CompilationMode mode) {
            assert (mode != null);
            this.mode = mode;
            return (B)((Builder)this.self());
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public OutputMode getOutputMode() {
            return this.outputMode;
        }

        public ProgramConsumer getProgramConsumer() {
            return this.programConsumer;
        }

        public StringConsumer getMainDexListConsumer() {
            return this.mainDexListConsumer;
        }

        public BiPredicate<String, Long> getDexClassChecksumFilter() {
            return this.dexClassChecksumFilter;
        }

        public B setOptimizeMultidexForLinearAlloc(boolean optimizeMultidexForLinearAlloc) {
            this.optimizeMultidexForLinearAlloc = optimizeMultidexForLinearAlloc;
            return (B)((Builder)this.self());
        }

        protected boolean isOptimizeMultidexForLinearAlloc() {
            return this.optimizeMultidexForLinearAlloc;
        }

        public B setProgramConsumer(ProgramConsumer programConsumer) {
            this.outputPath = null;
            this.outputMode = null;
            this.programConsumer = programConsumer;
            return (B)((Builder)this.self());
        }

        public B setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListConsumer = new StringConsumer.FileConsumer(mainDexListOutputPath);
            return (B)((Builder)this.self());
        }

        public B setMainDexListConsumer(StringConsumer mainDexListConsumer) {
            this.mainDexListConsumer = mainDexListConsumer;
            return (B)((Builder)this.self());
        }

        public B setOutput(Path outputPath, OutputMode outputMode) {
            return this.setOutput(outputPath, outputMode, false);
        }

        protected B setOutput(Path outputPath, OutputMode outputMode, boolean includeDataResources) {
            assert (outputPath != null);
            assert (outputMode != null);
            this.outputPath = outputPath;
            this.outputMode = outputMode;
            this.programConsumer = this.createProgramOutputConsumer(outputPath, outputMode, includeDataResources);
            return (B)((Builder)this.self());
        }

        public B setDexClassChecksumFilter(BiPredicate<String, Long> filter) {
            assert (filter != null);
            this.dexClassChecksumFilter = filter;
            return (B)((Builder)this.self());
        }

        protected InternalProgramOutputPathConsumer createProgramOutputConsumer(Path path, OutputMode mode, boolean consumeDataResources) {
            if (mode == OutputMode.DexIndexed) {
                return FileUtils.isArchive(path) ? new DexIndexedConsumer.ArchiveConsumer(path, consumeDataResources) : new DexIndexedConsumer.DirectoryConsumer(path, consumeDataResources);
            }
            if (mode == OutputMode.DexFilePerClass) {
                if (FileUtils.isArchive(path)) {
                    return new DexFilePerClassFileConsumer.ArchiveConsumer(path, consumeDataResources){

                        @Override
                        public boolean combineSyntheticClassesWithPrimaryClass() {
                            return false;
                        }
                    };
                }
                return new DexFilePerClassFileConsumer.DirectoryConsumer(path, consumeDataResources){

                    @Override
                    public boolean combineSyntheticClassesWithPrimaryClass() {
                        return false;
                    }
                };
            }
            if (mode == OutputMode.DexFilePerClassFile) {
                return FileUtils.isArchive(path) ? new DexFilePerClassFileConsumer.ArchiveConsumer(path, consumeDataResources) : new DexFilePerClassFileConsumer.DirectoryConsumer(path, consumeDataResources);
            }
            if (mode == OutputMode.ClassFile) {
                return FileUtils.isArchive(path) ? new ClassFileConsumer.ArchiveConsumer(path, consumeDataResources) : new ClassFileConsumer.DirectoryConsumer(path, consumeDataResources);
            }
            throw new Unreachable("Unexpected output mode: " + (Object)((Object)mode));
        }

        public int getMinApiLevel() {
            return this.isMinApiLevelSet() ? this.minApiLevel : AndroidApiLevel.getDefault().getLevel();
        }

        boolean isMinApiLevelSet() {
            return this.minApiLevel != 0;
        }

        public B setMinApiLevel(int minApiLevel) {
            if (minApiLevel <= 0) {
                this.getReporter().error("Invalid minApiLevel: " + minApiLevel);
            } else {
                this.minApiLevel = minApiLevel;
            }
            return (B)((Builder)this.self());
        }

        @Deprecated
        public B setEnableDesugaring(boolean enableDesugaring) {
            this.disableDesugaring = !enableDesugaring;
            return (B)((Builder)this.self());
        }

        public B setDisableDesugaring(boolean disableDesugaring) {
            this.disableDesugaring = disableDesugaring;
            return (B)((Builder)this.self());
        }

        public boolean getDisableDesugaring() {
            return this.disableDesugaring;
        }

        @Deprecated
        public B addSpecialLibraryConfiguration(String configuration) {
            return this.addDesugaredLibraryConfiguration(configuration);
        }

        public B addDesugaredLibraryConfiguration(String configuration) {
            this.desugaredLibraryConfigurationResources.add(StringResource.fromString(configuration, Origin.unknown()));
            return (B)((Builder)this.self());
        }

        public B addDesugaredLibraryConfiguration(StringResource configuration) {
            this.desugaredLibraryConfigurationResources.add(configuration);
            return (B)((Builder)this.self());
        }

        DesugaredLibraryConfiguration getDesugaredLibraryConfiguration(DexItemFactory factory, boolean libraryCompilation) {
            if (this.desugaredLibraryConfigurationResources.isEmpty()) {
                return DesugaredLibraryConfiguration.empty();
            }
            if (this.desugaredLibraryConfigurationResources.size() > 1) {
                throw new CompilationError("Only one desugared library configuration is supported.");
            }
            StringResource desugaredLibraryConfigurationResource = this.desugaredLibraryConfigurationResources.get(0);
            DesugaredLibraryConfigurationParser libraryParser = new DesugaredLibraryConfigurationParser(factory, this.getReporter(), libraryCompilation, this.getMinApiLevel());
            return libraryParser.parse(desugaredLibraryConfigurationResource);
        }

        boolean hasDesugaredLibraryConfiguration() {
            return !this.desugaredLibraryConfigurationResources.isEmpty();
        }

        public B setIncludeClassesChecksum(boolean enabled) {
            this.includeClassesChecksum = enabled;
            return (B)((Builder)this.self());
        }

        public boolean getIncludeClassesChecksum() {
            return this.includeClassesChecksum;
        }

        List<AssertionsConfiguration> getAssertionsConfiguration() {
            return this.assertionsConfiguration;
        }

        public B addAssertionsConfiguration(Function<AssertionsConfiguration.Builder, AssertionsConfiguration> assertionsConfigurationGenerator) {
            this.assertionsConfiguration.add(assertionsConfigurationGenerator.apply(AssertionsConfiguration.builder(this.getReporter())));
            return (B)((Builder)this.self());
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (this.mode == null) {
                reporter.error("Expected valid compilation mode, was null");
            }
            FileUtils.validateOutputFile(this.outputPath, reporter);
            if (this.getProgramConsumer() == null) {
                reporter.error("A ProgramConsumer or Output is required for compilation");
            }
            ArrayList<Class<ClassFileConsumer>> programConsumerClasses = new ArrayList<Class<ClassFileConsumer>>(3);
            if (this.programConsumer instanceof DexIndexedConsumer) {
                programConsumerClasses.add(DexIndexedConsumer.class);
            }
            if (this.programConsumer instanceof DexFilePerClassFileConsumer) {
                programConsumerClasses.add(DexFilePerClassFileConsumer.class);
            }
            if (this.programConsumer instanceof ClassFileConsumer) {
                programConsumerClasses.add(ClassFileConsumer.class);
            }
            if (programConsumerClasses.size() > 1) {
                StringBuilder builder = new StringBuilder().append("Invalid program consumer.").append(" A program consumer can implement at most one consumer type but ").append(this.programConsumer.getClass().getName()).append(" implements types:");
                for (Class clazz : programConsumerClasses) {
                    builder.append(" ").append(clazz.getName());
                }
                reporter.error(builder.toString());
            }
            super.validate();
        }
    }
}

