/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.KeepForSubclassing;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionDiagnostic;

@KeepForSubclassing
public interface StringConsumer {
    public void accept(String var1, DiagnosticsHandler var2);

    default public void finished(DiagnosticsHandler handler) {
    }

    public static EmptyConsumer emptyConsumer() {
        return EmptyConsumer.EMPTY_CONSUMER;
    }

    public static class WriterConsumer
    extends ForwardingConsumer {
        private final Origin origin;
        private Writer writer;

        public WriterConsumer(Origin origin, Writer writer) {
            this(origin, writer, null);
        }

        public WriterConsumer(Origin origin, Writer writer, StringConsumer consumer) {
            super(consumer);
            this.origin = origin;
            this.writer = writer;
        }

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
            super.accept(string, handler);
            try {
                this.writer.write(string);
                this.writer.flush();
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, this.origin));
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            try {
                this.writer.close();
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, this.origin));
            }
        }
    }

    @Keep
    public static class FileConsumer
    extends ForwardingConsumer {
        private final Path outputPath;
        private Charset encoding = StandardCharsets.UTF_8;
        private WriterConsumer delegate = null;
        private boolean failedToCreateDelegate = false;

        public FileConsumer(Path outputPath) {
            this(outputPath, null);
        }

        public FileConsumer(Path outputPath, StringConsumer consumer) {
            super(consumer);
            this.outputPath = outputPath;
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public void setEncoding(Charset encoding) {
            assert (encoding != null);
            if (this.delegate != null) {
                throw new IllegalStateException("Invalid call to set encoding after file stream is opened");
            }
            this.encoding = encoding;
        }

        public Charset getEncoding() {
            return this.encoding;
        }

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
            super.accept(string, handler);
            if (this.failedToCreateDelegate) {
                return;
            }
            this.ensureDelegate(handler);
            if (this.delegate != null) {
                this.delegate.accept(string, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            if (this.failedToCreateDelegate) {
                return;
            }
            if (this.delegate != null) {
                this.delegate.finished(handler);
                this.delegate = null;
            }
        }

        private void ensureDelegate(DiagnosticsHandler handler) {
            if (this.delegate != null) {
                return;
            }
            PathOrigin origin = new PathOrigin(this.outputPath);
            try {
                Path parent = this.outputPath.getParent();
                if (parent != null && !parent.toFile().exists()) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                this.delegate = new WriterConsumer(origin, Files.newBufferedWriter(this.outputPath, this.encoding, new OpenOption[0]));
            }
            catch (IOException e) {
                this.failedToCreateDelegate = true;
                handler.error(new ExceptionDiagnostic(e, origin));
            }
        }
    }

    public static class ForwardingConsumer
    implements StringConsumer {
        private final StringConsumer consumer;

        public ForwardingConsumer(StringConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(string, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }

    public static class EmptyConsumer
    implements StringConsumer {
        private static final EmptyConsumer EMPTY_CONSUMER = new EmptyConsumer();

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
        }
    }
}

