/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.bisect;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import shadow.bundletool.com.android.tools.r8.OutputMode;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.StringConsumer;
import shadow.bundletool.com.android.tools.r8.bisect.BisectOptions;
import shadow.bundletool.com.android.tools.r8.bisect.BisectState;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.CharStreams;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationWriter;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.AndroidAppConsumers;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class Bisect {
    private final BisectOptions options;
    private final Timing timing = new Timing("bisect");

    public Bisect(BisectOptions options) {
        this.options = options;
    }

    public static DexProgramClass run(BisectState state, Command command, Path output, ExecutorService executor) throws Exception {
        while (true) {
            DexApplication app = state.bisect();
            state.write();
            if (app == null) {
                return state.getFinalClass();
            }
            if (command == null) {
                Bisect.writeApp(app, output, executor);
                System.out.println("Bisecting completed with build in " + output + "/");
                System.out.println("Continue bisection by passing either --result-good or --result-bad");
                return null;
            }
            state.setPreviousResult(command.apply(app));
            app.options.itemFactory.resetSortedIndices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexProgramClass run() throws Exception {
        Path output = this.options.output != null ? this.options.output : Files.createTempDirectory("bisect", new FileAttribute[0]);
        ExecutorService executor = Executors.newWorkStealingPool();
        try {
            InternalOptions internal = new InternalOptions();
            DexApplication goodApp = this.readApp(this.options.goodBuild, internal, executor);
            DexApplication badApp = this.readApp(this.options.badBuild, internal, executor);
            Path stateFile = this.options.stateFile != null ? this.options.stateFile : output.resolve("bisect.state");
            BisectState state = new BisectState(goodApp, badApp, stateFile);
            if (this.options.stateFile != null) {
                state.read();
            }
            if (this.options.result != BisectOptions.Result.UNKNOWN) {
                state.setPreviousResult(this.options.result);
            }
            Command command = null;
            if (this.options.command != null) {
                command = application -> {
                    Bisect.writeApp(application, output, executor);
                    return Bisect.runCommand(this.options.command, this.options.goodBuild, this.options.badBuild, output);
                };
            }
            DexProgramClass dexProgramClass = Bisect.run(state, command, output, executor);
            return dexProgramClass;
        }
        finally {
            executor.shutdown();
        }
    }

    private static BisectOptions.Result runCommand(Path command, Path good, Path bad, Path output) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("/bin/bash");
        args.add(command.toString());
        args.addAll(ImmutableList.of(good.toString(), bad.toString(), output.toString()));
        System.out.println("Running cmd: " + String.join((CharSequence)" ", args));
        ProcessBuilder builder = new ProcessBuilder(args);
        Process process = builder.start();
        StreamReader stdoutReader = new StreamReader(process.getInputStream());
        StreamReader stderrReader = new StreamReader(process.getErrorStream());
        Thread stdoutThread = new Thread(stdoutReader);
        Thread stderrThread = new Thread(stderrReader);
        stdoutThread.start();
        stderrThread.start();
        try {
            process.waitFor();
            stdoutThread.join();
            stderrThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Execution interrupted", e);
        }
        System.out.print("OUT:\n" + stdoutReader.getResult());
        System.out.print("ERR:\n" + stderrReader.getResult());
        int result = process.exitValue();
        if (result == 0) {
            return BisectOptions.Result.GOOD;
        }
        if (result == 1) {
            return BisectOptions.Result.BAD;
        }
        System.out.println("Failed to run command " + args);
        System.out.println("Exit code: " + result + " (expected 0 for good, 1 for bad)");
        throw new CompilationError("Failed to run command " + args);
    }

    private DexApplication readApp(Path apk, InternalOptions options, ExecutorService executor) throws IOException, ExecutionException {
        AndroidApp app = AndroidApp.builder().addProgramFiles(apk).build();
        return new ApplicationReader(app, options, this.timing).read(executor);
    }

    private static void writeApp(DexApplication app, Path output, ExecutorService executor) throws IOException, ExecutionException {
        InternalOptions options = app.options;
        ProgramConsumer programConsumer = options.programConsumer;
        StringConsumer proguardMapConsumer = options.proguardMapConsumer;
        AndroidAppConsumers compatSink = new AndroidAppConsumers(options);
        ApplicationWriter writer = new ApplicationWriter(app, null, options, null, null, NamingLens.getIdentityLens(), null);
        writer.write(executor);
        options.signalFinishedToConsumers();
        compatSink.build().writeToDirectory(output, OutputMode.DexIndexed);
        options.programConsumer = programConsumer;
        options.proguardMapConsumer = proguardMapConsumer;
    }

    public static DexProgramClass run(BisectOptions options) throws Exception {
        return new Bisect(options).run();
    }

    public static void main(String[] args) throws Exception {
        BisectOptions options;
        try {
            options = BisectOptions.parse(args);
        }
        catch (CompilationError e) {
            System.err.println(e.getMessage());
            BisectOptions.printHelp(System.err);
            return;
        }
        if (options == null) {
            return;
        }
        DexProgramClass clazz = Bisect.run(options);
        if (clazz != null) {
            System.out.println("Bisection found final bad class " + clazz);
        }
    }

    private static class StreamReader
    implements Runnable {
        private final InputStream stream;
        private String result;

        public StreamReader(InputStream stream) {
            this.stream = stream;
        }

        public String getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                this.result = CharStreams.toString(new InputStreamReader(this.stream, StandardCharsets.UTF_8));
                this.stream.close();
            }
            catch (IOException e) {
                this.result = "Failed reading result for stream " + this.stream;
            }
        }
    }

    public static interface Command {
        public BisectOptions.Result apply(DexApplication var1) throws Exception;
    }
}

