/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.cf.FixedLocalValue;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Argument;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.StackValue;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class TypeVerificationHelper {
    private final TypeInfo INT;
    private final TypeInfo FLOAT;
    private final TypeInfo LONG;
    private final TypeInfo DOUBLE;
    private final AppView<?> appView;
    private final IRCode code;
    private Map<Value, TypeInfo> types;
    private Map<NewInstance, NewInstanceInfo> newInstanceInfos = new IdentityHashMap<NewInstance, NewInstanceInfo>();
    private boolean computingVerificationTypes = false;

    public TypeVerificationHelper(AppView<?> appView, IRCode code) {
        this.appView = appView;
        this.code = code;
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        this.INT = new InitializedTypeInfo(dexItemFactory.intType);
        this.FLOAT = new InitializedTypeInfo(dexItemFactory.floatType);
        this.LONG = new InitializedTypeInfo(dexItemFactory.longType);
        this.DOUBLE = new InitializedTypeInfo(dexItemFactory.doubleType);
    }

    public TypeInfo createInitializedType(DexType type) {
        if (!type.isPrimitiveType()) {
            return new InitializedTypeInfo(type);
        }
        if (type.isLongType()) {
            return this.LONG;
        }
        if (type.isDoubleType()) {
            return this.DOUBLE;
        }
        if (type.isFloatType()) {
            return this.FLOAT;
        }
        assert (type.isBooleanType() || type.isByteType() || type.isCharType() || type.isShortType() || type.isIntType());
        return this.INT;
    }

    public DexType getDexType(Value value) {
        assert (this.computingVerificationTypes);
        assert (value.outType().isObject());
        TypeInfo typeInfo = this.types.get(value);
        return typeInfo == null ? null : typeInfo.getDexType();
    }

    public TypeInfo getTypeInfo(Value value) {
        if (value instanceof FixedLocalValue) {
            value = ((FixedLocalValue)value).getPhi();
        }
        if (value instanceof StackValue) {
            return ((StackValue)value).getTypeInfo();
        }
        switch (value.outType()) {
            case OBJECT: {
                return this.types.get(value);
            }
            case INT: {
                return this.INT;
            }
            case FLOAT: {
                return this.FLOAT;
            }
            case LONG: {
                return this.LONG;
            }
            case DOUBLE: {
                return this.DOUBLE;
            }
        }
        throw new Unreachable("Unexpected type: " + (Object)((Object)value.outType()) + " for value: " + value);
    }

    public DexType join(Set<DexType> types) {
        assert (!types.isEmpty());
        if (types.size() == 1) {
            return types.iterator().next();
        }
        Iterator<DexType> iterator2 = types.iterator();
        TypeLatticeElement result = this.getLatticeElement(iterator2.next());
        while (iterator2.hasNext()) {
            result = result.join(this.getLatticeElement(iterator2.next()), this.appView);
        }
        if (result.isClassType()) {
            return result.asClassTypeLatticeElement().getClassType();
        }
        if (result.isArrayType()) {
            return result.asArrayTypeLatticeElement().getArrayType(this.appView.dexItemFactory());
        }
        throw new CompilationError("Unexpected join " + result + " of types: " + String.join((CharSequence)", ", types.stream().map(DexType::toSourceString).collect(Collectors.toList())));
    }

    public TypeInfo join(TypeInfo info1, TypeInfo info2) {
        if (info1 == info2) {
            return info1;
        }
        DexType type1 = info1.getDexType();
        DexType type2 = info2.getDexType();
        if (info1 instanceof InitializedTypeInfo && info2 instanceof InitializedTypeInfo && type1 == type2) {
            return info1;
        }
        assert (!type1.isPrimitiveType() && !type2.isPrimitiveType());
        return this.createInitializedType(this.join(ImmutableSet.of(type1, type2)));
    }

    private TypeLatticeElement getLatticeElement(DexType type) {
        return TypeLatticeElement.fromDexType(type, Nullability.maybeNull(), this.appView);
    }

    /*
     * WARNING - void declaration
     */
    public Map<Value, TypeInfo> computeVerificationTypes() {
        void var4_7;
        Instruction instruction;
        int argumentIndex;
        this.computingVerificationTypes = true;
        this.types = new HashMap<Value, TypeInfo>();
        ArrayList<ConstNumber> nullsUsedInPhis = new ArrayList<ConstNumber>();
        Set<Value> worklist = Sets.newIdentityHashSet();
        InstructionIterator it = this.code.instructionIterator();
        Object var4_4 = null;
        int n = argumentIndex = this.code.method.accessFlags.isStatic() ? 0 : -1;
        while (it.hasNext() && (instruction = (Instruction)it.next()).isArgument()) {
            TypeInfo argumentType = argumentIndex < 0 ? (this.code.method.isInstanceInitializer() ? new ThisInstanceInfo(instruction.asArgument(), this.code.method.method.holder) : this.createInitializedType(this.code.method.method.holder)) : this.createInitializedType(this.code.method.method.proto.parameters.values[argumentIndex]);
            Value outValue = instruction.outValue();
            if (outValue.outType().isObject()) {
                this.types.put(outValue, argumentType);
                TypeVerificationHelper.addUsers(outValue, worklist);
            }
            ++argumentIndex;
        }
        while (var4_7 != null) {
            assert (!var4_7.isArgument());
            if (var4_7.outValue() != null) {
                if (var4_7.isNewInstance()) {
                    NewInstanceInfo newInstanceInfo = this.newInstanceInfos.computeIfAbsent(var4_7.asNewInstance(), NewInstanceInfo::new);
                    this.types.put(var4_7.outValue(), newInstanceInfo);
                    TypeVerificationHelper.addUsers(var4_7.outValue(), worklist);
                } else if (var4_7.outType().isObject()) {
                    Value outValue = var4_7.outValue();
                    if (var4_7.hasInvariantOutType()) {
                        if (var4_7.isConstNumber()) {
                            assert (var4_7.asConstNumber().isZero());
                            if (outValue.numberOfAllUsers() == outValue.numberOfPhiUsers()) {
                                nullsUsedInPhis.add(var4_7.asConstNumber());
                            }
                        }
                        DexType type = var4_7.computeVerificationType(this.appView, this);
                        this.types.put(outValue, this.createInitializedType(type));
                        TypeVerificationHelper.addUsers(outValue, worklist);
                    }
                }
            }
            Instruction instruction2 = it.hasNext() ? (Instruction)it.next() : null;
        }
        while (!worklist.isEmpty()) {
            DexType refinedType;
            Value item = (Value)worklist.iterator().next();
            worklist.remove(item);
            assert (item.outType().isObject());
            TypeInfo typeInfo = this.types.get(item);
            DexType previousType = typeInfo == null ? null : typeInfo.getDexType();
            if (previousType == (refinedType = this.computeVerificationType(item))) continue;
            this.types.put(item, this.createInitializedType(refinedType));
            TypeVerificationHelper.addUsers(item, worklist);
        }
        this.computingVerificationTypes = false;
        for (ConstNumber constNumber : nullsUsedInPhis) {
            TypeInfo refinedType = null;
            for (Phi phi : constNumber.outValue().uniquePhiUsers()) {
                if (refinedType == null) {
                    refinedType = this.types.get(phi);
                    continue;
                }
                if (refinedType.getDexType() == this.types.get(phi).getDexType()) continue;
                refinedType = null;
                break;
            }
            if (refinedType == null) continue;
            this.types.put(constNumber.outValue(), refinedType);
        }
        return this.types;
    }

    private DexType computeVerificationType(Value value) {
        return value.isPhi() ? value.asPhi().computeVerificationType(this) : value.definition.computeVerificationType(this.appView, this);
    }

    private static void addUsers(Value value, Set<Value> worklist) {
        worklist.addAll(value.uniquePhiUsers());
        for (Instruction instruction : value.uniqueUsers()) {
            if (instruction.outValue() == null || !instruction.outType().isObject() || instruction.hasInvariantOutType()) continue;
            worklist.add(instruction.outValue());
        }
    }

    public static class ThisInstanceInfo
    implements TypeInfo {
        final DexType type;
        public final Argument thisArgument;

        public ThisInstanceInfo(Argument thisArgument, DexType type) {
            assert (thisArgument != null);
            assert (type != null);
            this.thisArgument = thisArgument;
            this.type = type;
        }

        @Override
        public DexType getDexType() {
            return this.type;
        }

        public String toString() {
            return "this:" + this.getDexType();
        }
    }

    public static class NewInstanceInfo
    implements TypeInfo {
        public final NewInstance newInstance;

        public NewInstanceInfo(NewInstance newInstance) {
            assert (newInstance != null);
            this.newInstance = newInstance;
        }

        @Override
        public DexType getDexType() {
            return this.newInstance.clazz;
        }

        public String toString() {
            return "new:" + this.getDexType();
        }
    }

    public static class InitializedTypeInfo
    implements TypeInfo {
        final DexType type;

        private InitializedTypeInfo(DexType type) {
            assert (type != null);
            this.type = type;
        }

        @Override
        public DexType getDexType() {
            return this.type;
        }

        public String toString() {
            return this.type.toString();
        }
    }

    public static interface TypeInfo {
        public DexType getDexType();
    }
}

