/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.util.Optional;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.dex.BinaryReader;
import shadow.bundletool.com.android.tools.r8.dex.CompatByteBuffer;
import shadow.bundletool.com.android.tools.r8.dex.Constants;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.DexVersion;

public class DexReader
extends BinaryReader {
    private final DexVersion version;

    public DexReader(ProgramResource resource) throws ResourceException, IOException {
        super(resource);
        this.version = this.parseMagic(this.buffer);
    }

    DexReader(Origin origin, byte[] bytes) {
        super(origin, bytes);
        this.version = this.parseMagic(this.buffer);
    }

    private DexVersion parseMagic(CompatByteBuffer buffer) {
        char versionByte2;
        char versionByte1;
        Optional<DexVersion> maybeVersion;
        try {
            buffer.get();
            buffer.rewind();
        }
        catch (BufferUnderflowException e) {
            throw new CompilationError("Dex file is empty", this.origin);
        }
        int index = 0;
        for (byte prefixByte : Constants.DEX_FILE_MAGIC_PREFIX) {
            if (buffer.get(index++) == prefixByte) continue;
            throw new CompilationError("Dex file has invalid header", this.origin);
        }
        char versionByte0 = (char)buffer.get(index++);
        if (!(maybeVersion = DexVersion.getDexVersion(versionByte0, versionByte1 = (char)buffer.get(index++), versionByte2 = (char)buffer.get(index++))).isPresent()) {
            throw new CompilationError("Unsupported DEX file version: " + versionByte0 + versionByte1 + versionByte2, this.origin);
        }
        if (buffer.get(index++) != 0) {
            throw new CompilationError("Dex file has invalid header", this.origin);
        }
        return maybeVersion.get();
    }

    @Override
    void setByteOrder() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int endian = this.buffer.getInt(40);
        if (endian == 2018915346) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        } else if (endian != 305419896) {
            throw new CompilationError("Unable to determine endianess for reading dex file.");
        }
    }

    DexVersion getDexVersion() {
        return this.version;
    }
}

