/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.errors;

import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.Position;

@Keep
public class DexFileOverflowDiagnostic
implements Diagnostic {
    private final boolean hasMainDexSpecification;
    private final long numOfMethods;
    private final long numOfFields;

    public DexFileOverflowDiagnostic(boolean hasMainDexSpecification, long numOfMethods, long numOfFields) {
        this.hasMainDexSpecification = hasMainDexSpecification;
        this.numOfMethods = numOfMethods;
        this.numOfFields = numOfFields;
    }

    public long getNumberOfFields() {
        return this.numOfFields;
    }

    public long getNumberOfMethods() {
        return this.numOfMethods;
    }

    public long getMaximumNumberOfFields() {
        return 65536L;
    }

    public long getMaximumNumberOfMethods() {
        return 65536L;
    }

    public boolean hasMainDexSpecification() {
        return this.hasMainDexSpecification;
    }

    @Override
    public Origin getOrigin() {
        return Origin.unknown();
    }

    @Override
    public Position getPosition() {
        return null;
    }

    @Override
    public String getDiagnosticMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cannot fit requested classes in ").append(this.hasMainDexSpecification() ? "the main-" : "a single ").append("dex file").append(" (");
        if (this.getNumberOfMethods() > this.getMaximumNumberOfMethods()) {
            builder.append("# methods: ").append(this.getNumberOfMethods()).append(" > ").append(this.getMaximumNumberOfMethods());
            if (this.getNumberOfFields() > this.getMaximumNumberOfFields()) {
                builder.append(" ; ");
            }
        }
        if (this.getNumberOfFields() > this.getMaximumNumberOfFields()) {
            builder.append("# fields: ").append(this.getNumberOfFields()).append(" > ").append(this.getMaximumNumberOfFields());
        }
        return builder.append(")").toString();
    }
}

