/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.experimental.graphinfo;

public class GraphEdgeInfo {
    private static GraphEdgeInfo UNKNOWN = new GraphEdgeInfo(EdgeKind.Unknown);
    private final EdgeKind kind;

    public static GraphEdgeInfo unknown() {
        return UNKNOWN;
    }

    public GraphEdgeInfo(EdgeKind kind) {
        this.kind = kind;
    }

    public EdgeKind edgeKind() {
        return this.kind;
    }

    public String getInfoPrefix() {
        switch (this.edgeKind()) {
            case KeepRule: 
            case CompatibilityRule: 
            case ConditionalKeepRule: {
                return "referenced in keep rule";
            }
            case KeepRulePrecondition: {
                return "satisfied with precondition";
            }
            case InstantiatedIn: {
                return "instantiated in";
            }
            case InvokedViaSuper: {
                return "invoked via super from";
            }
            case TargetedBySuper: {
                return "targeted by super from";
            }
            case InvokedFrom: {
                return "invoked from";
            }
            case InvokedFromLambdaCreatedIn: {
                return "invoked from lambda created in";
            }
            case AnnotatedOn: {
                return "annotated on";
            }
            case ReferencedFrom: {
                return "referenced from";
            }
            case ReflectiveUseFrom: {
                return "reflected from";
            }
            case ReachableFromLiveType: {
                return "reachable from";
            }
            case ReferencedInAnnotation: {
                return "referenced in annotation";
            }
            case OverridingMethod: {
                return "overriding method";
            }
            case IsLibraryMethod: {
                return "defined in library method overridden by";
            }
            case MethodHandleUseFrom: {
                return "referenced by method handle";
            }
            case CompanionClass: {
                return "companion class for";
            }
            case CompanionMethod: {
                return "companion method for";
            }
            default: {
                assert (false) : "Unknown edge kind: " + (Object)((Object)this.edgeKind());
                break;
            }
            case Unknown: 
        }
        return "kept for unknown reasons";
    }

    public String toString() {
        return "{edge-type:" + this.kind.toString() + "}";
    }

    public boolean equals(Object o) {
        return this == o || o instanceof GraphEdgeInfo && ((GraphEdgeInfo)o).kind == this.kind;
    }

    public int hashCode() {
        return this.kind.hashCode();
    }

    public static enum EdgeKind {
        KeepRule,
        CompatibilityRule,
        ConditionalKeepRule,
        KeepRulePrecondition,
        InstantiatedIn,
        InvokedViaSuper,
        TargetedBySuper,
        InvokedFrom,
        InvokedFromLambdaCreatedIn,
        AnnotatedOn,
        ReferencedFrom,
        ReflectiveUseFrom,
        ReachableFromLiveType,
        ReferencedInAnnotation,
        IsLibraryMethod,
        OverridingMethod,
        MethodHandleUseFrom,
        CompanionClass,
        CompanionMethod,
        Unknown;

    }
}

