/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import shadow.bundletool.com.android.tools.r8.DataDirectoryResource;
import shadow.bundletool.com.android.tools.r8.DataEntryResource;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.ByteStreams;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class AppServices {
    public static final String SERVICE_DIRECTORY_NAME = "META-INF/services/";
    private final AppView<?> appView;
    private final Map<DexType, List<DexType>> services;

    private AppServices(AppView<?> appView, Map<DexType, List<DexType>> services) {
        this.appView = appView;
        this.services = services;
    }

    public boolean isEmpty() {
        return this.services.isEmpty();
    }

    public Set<DexType> allServiceTypes() {
        assert (this.verifyRewrittenWithLens());
        return this.services.keySet();
    }

    public List<DexType> serviceImplementationsFor(DexType serviceType) {
        assert (this.verifyRewrittenWithLens());
        assert (this.services.containsKey(serviceType));
        List<DexType> serviceImplementationTypes = this.services.get(serviceType);
        if (serviceImplementationTypes == null) {
            assert (false) : "Unexpected attempt to get service implementations for non-service type `" + serviceType.toSourceString() + "`";
            return ImmutableList.of();
        }
        return serviceImplementationTypes;
    }

    public AppServices rewrittenWithLens(GraphLense graphLens) {
        ImmutableMap.Builder<DexType, ImmutableCollection> rewrittenServices = ImmutableMap.builder();
        for (Map.Entry<DexType, List<DexType>> entry : this.services.entrySet()) {
            DexType rewrittenServiceType = graphLens.lookupType(entry.getKey());
            ImmutableList.Builder rewrittenServiceImplementationTypes = ImmutableList.builder();
            for (DexType serviceImplementationType : entry.getValue()) {
                rewrittenServiceImplementationTypes.add(graphLens.lookupType(serviceImplementationType));
            }
            rewrittenServices.put(rewrittenServiceType, rewrittenServiceImplementationTypes.build());
        }
        return new AppServices(this.appView, rewrittenServices.build());
    }

    public AppServices prunedCopy(Collection<DexType> removedClasses) {
        ImmutableMap.Builder<DexType, ImmutableCollection> rewrittenServicesBuilder = ImmutableMap.builder();
        for (Map.Entry<DexType, List<DexType>> entry : this.services.entrySet()) {
            if (removedClasses.contains(entry.getKey())) continue;
            DexType serviceType = entry.getKey();
            ImmutableList.Builder rewrittenServiceImplementationTypesBuilder = ImmutableList.builder();
            for (DexType serviceImplementationType : entry.getValue()) {
                if (removedClasses.contains(serviceImplementationType)) continue;
                rewrittenServiceImplementationTypesBuilder.add(serviceImplementationType);
            }
            ImmutableCollection rewrittenServiceImplementationTypes = rewrittenServiceImplementationTypesBuilder.build();
            if (rewrittenServiceImplementationTypes.size() <= 0) continue;
            rewrittenServicesBuilder.put(serviceType, rewrittenServiceImplementationTypesBuilder.build());
        }
        return new AppServices(this.appView, rewrittenServicesBuilder.build());
    }

    private boolean verifyRewrittenWithLens() {
        for (Map.Entry<DexType, List<DexType>> entry : this.services.entrySet()) {
            assert (entry.getKey() == this.appView.graphLense().lookupType(entry.getKey()));
            for (DexType type : entry.getValue()) {
                assert (type == this.appView.graphLense().lookupType(type));
            }
        }
        return true;
    }

    public void visit(BiConsumer<DexType, List<DexType>> consumer) {
        this.services.forEach(consumer);
    }

    public static Builder builder(AppView<?> appView) {
        return new Builder(appView);
    }

    public static class Builder {
        private final AppView<?> appView;
        private final Map<DexType, List<DexType>> services = new IdentityHashMap<DexType, List<DexType>>();

        private Builder(AppView<?> appView) {
            this.appView = appView;
        }

        public AppServices build() {
            for (DataResourceProvider provider : ((AppInfo)this.appView.appInfo()).app().dataResourceProviders) {
                this.readServices(provider);
            }
            return new AppServices(this.appView, this.services);
        }

        private void readServices(DataResourceProvider dataResourceProvider) {
            try {
                dataResourceProvider.accept(new DataResourceProviderVisitor());
            }
            catch (ResourceException e) {
                throw new CompilationError(e.getMessage(), e);
            }
        }

        private class DataResourceProviderVisitor
        implements DataResourceProvider.Visitor {
            private DataResourceProviderVisitor() {
            }

            @Override
            public void visit(DataDirectoryResource directory) {
            }

            @Override
            public void visit(DataEntryResource file) {
                try {
                    String serviceName;
                    String name = file.getName();
                    if (name.startsWith(AppServices.SERVICE_DIRECTORY_NAME) && DescriptorUtils.isValidJavaType(serviceName = name.substring(AppServices.SERVICE_DIRECTORY_NAME.length()))) {
                        String serviceDescriptor = DescriptorUtils.javaTypeToDescriptor(serviceName);
                        DexType serviceType = Builder.this.appView.dexItemFactory().createType(serviceDescriptor);
                        byte[] bytes = ByteStreams.toByteArray(file.getByteStream());
                        String contents = new String(bytes, Charset.defaultCharset());
                        List serviceImplementations = Builder.this.services.computeIfAbsent(serviceType, key -> new ArrayList());
                        this.readServiceImplementationsForService(contents, file.getOrigin(), serviceImplementations);
                    }
                }
                catch (IOException | ResourceException e) {
                    throw new CompilationError(e.getMessage(), e);
                }
            }

            private void readServiceImplementationsForService(String contents, Origin origin, List<DexType> serviceImplementations) {
                if (contents != null) {
                    Arrays.stream(contents.split(System.lineSeparator())).map(String::trim).map(this::prefixUntilCommentChar).filter(line -> !line.isEmpty()).filter(DescriptorUtils::isValidJavaType).map(DescriptorUtils::javaTypeToDescriptor).map(Builder.this.appView.dexItemFactory()::createType).filter(serviceImplementationType -> {
                        if (!serviceImplementationType.isClassType()) {
                            ((Builder)Builder.this).appView.options().reporter.warning(new StringDiagnostic("Unexpected service implementation found in META-INF/services/: `" + serviceImplementationType.toSourceString() + "`.", origin));
                            return false;
                        }
                        return !serviceImplementations.contains(serviceImplementationType);
                    }).forEach(serviceImplementations::add);
                }
            }

            private String prefixUntilCommentChar(String line) {
                int commentCharIndex = line.indexOf(35);
                return commentCharIndex > -1 ? line.substring(0, commentCharIndex) : line;
            }
        }
    }
}

