/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DirectMappedDexApplication;
import shadow.bundletool.com.android.tools.r8.graph.LazyLoadedDexApplication;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ProgramClassCollection;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public abstract class DexApplication {
    public final ImmutableList<DataResourceProvider> dataResourceProviders;
    public final ImmutableSet<DexType> mainDexList;
    private final ClassNameMapper proguardMap;
    public final Timing timing;
    public final InternalOptions options;
    public final DexItemFactory dexItemFactory;
    public final DexString highestSortingString;

    DexApplication(ClassNameMapper proguardMap, ImmutableList<DataResourceProvider> dataResourceProviders, ImmutableSet<DexType> mainDexList, InternalOptions options, DexString highestSortingString, Timing timing) {
        this.proguardMap = proguardMap;
        this.dataResourceProviders = dataResourceProviders;
        this.mainDexList = mainDexList;
        this.options = options;
        this.dexItemFactory = options.itemFactory;
        this.highestSortingString = highestSortingString;
        this.timing = timing;
    }

    public abstract Builder<?> builder();

    abstract List<DexProgramClass> programClasses();

    public List<DexProgramClass> classes() {
        ReorderBox<DexProgramClass> box = new ReorderBox<DexProgramClass>(this.programClasses());
        assert (box.reorderClasses());
        return box.getClasses();
    }

    public Iterable<DexProgramClass> classesWithDeterministicOrder() {
        ArrayList<DexProgramClass> classes = new ArrayList<DexProgramClass>(this.programClasses());
        if (this.options.testing.deterministicSortingBasedOnDexType) {
            classes.sort((a, b) -> a.type.slowCompareTo(b.type));
        }
        return classes;
    }

    public abstract DexClass definitionFor(DexType var1);

    public abstract DexProgramClass programDefinitionFor(DexType var1);

    public abstract String toString();

    public ClassNameMapper getProguardMap() {
        return this.proguardMap;
    }

    public static LazyLoadedDexApplication.Builder builder(InternalOptions options, Timing timing) {
        return DexApplication.builder(options, timing, ProgramClassCollection.defaultConflictResolver(options.reporter));
    }

    public static LazyLoadedDexApplication.Builder builder(InternalOptions options, Timing timing, ApplicationReader.ProgramClassConflictResolver resolver) {
        return new LazyLoadedDexApplication.Builder(resolver, options, timing);
    }

    public DirectMappedDexApplication asDirect() {
        throw new Unreachable("Cannot use a LazyDexApplication where a DirectDexApplication is expected.");
    }

    public abstract DirectMappedDexApplication toDirect();

    public static abstract class Builder<T extends Builder<T>> {
        final List<DexProgramClass> programClasses = new ArrayList<DexProgramClass>();
        final List<DataResourceProvider> dataResourceProviders = new ArrayList<DataResourceProvider>();
        public final InternalOptions options;
        public final DexItemFactory dexItemFactory;
        ClassNameMapper proguardMap;
        final Timing timing;
        DexString highestSortingString;
        final Set<DexType> mainDexList = Sets.newIdentityHashSet();
        private final Collection<DexProgramClass> synthesizedClasses;

        public Builder(InternalOptions options, Timing timing) {
            this.options = options;
            this.dexItemFactory = options.itemFactory;
            this.timing = timing;
            this.synthesizedClasses = new ArrayList<DexProgramClass>();
        }

        abstract T self();

        public Builder(DexApplication application) {
            this.programClasses.addAll(application.programClasses());
            this.dataResourceProviders.addAll(application.dataResourceProviders);
            this.proguardMap = application.getProguardMap();
            this.timing = application.timing;
            this.highestSortingString = application.highestSortingString;
            this.options = application.options;
            this.dexItemFactory = application.dexItemFactory;
            this.mainDexList.addAll(application.mainDexList);
            this.synthesizedClasses = new ArrayList<DexProgramClass>();
        }

        public synchronized T setProguardMap(ClassNameMapper proguardMap) {
            assert (this.proguardMap == null);
            this.proguardMap = proguardMap;
            return this.self();
        }

        public synchronized T replaceProgramClasses(List<DexProgramClass> newProgramClasses) {
            assert (newProgramClasses != null);
            this.programClasses.clear();
            this.programClasses.addAll(newProgramClasses);
            return this.self();
        }

        public synchronized T addDataResourceProvider(DataResourceProvider provider) {
            this.dataResourceProviders.add(provider);
            return this.self();
        }

        public synchronized T setHighestSortingString(DexString value) {
            this.highestSortingString = value;
            return this.self();
        }

        public synchronized T addProgramClass(DexProgramClass clazz) {
            this.programClasses.add(clazz);
            return this.self();
        }

        public synchronized T addSynthesizedClass(DexProgramClass synthesizedClass, boolean addToMainDexList) {
            assert (synthesizedClass.isProgramClass()) : "All synthesized classes must be program classes";
            this.addProgramClass(synthesizedClass);
            this.synthesizedClasses.add(synthesizedClass);
            if (addToMainDexList && !this.mainDexList.isEmpty()) {
                this.mainDexList.add(synthesizedClass.type);
            }
            return this.self();
        }

        public Collection<DexProgramClass> getProgramClasses() {
            return this.programClasses;
        }

        public Collection<DexProgramClass> getSynthesizedClasses() {
            return this.synthesizedClasses;
        }

        public Set<DexType> getMainDexList() {
            return this.mainDexList;
        }

        public Builder<T> addToMainDexList(Collection<DexType> mainDexList) {
            this.mainDexList.addAll(mainDexList);
            return this;
        }

        public abstract DexApplication build();
    }

    private static class ReorderBox<T> {
        private List<T> classes;

        ReorderBox(List<T> classes) {
            this.classes = classes;
        }

        boolean reorderClasses() {
            ArrayList<T> shuffled = new ArrayList<T>(this.classes);
            Collections.shuffle(shuffled);
            this.classes = ImmutableList.copyOf(shuffled);
            return true;
        }

        List<T> getClasses() {
            return this.classes;
        }
    }
}

