/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Predicates;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.ObjectToOffsetMapping;
import shadow.bundletool.com.android.tools.r8.graph.PresortedComparable;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.Pair;

public class DexType
extends DexReference
implements PresortedComparable<DexType> {
    public static final DexType[] EMPTY_ARRAY = new DexType[0];
    private static List<String> OLD_SYNTHESIZED_NAMES = ImmutableList.of("$r8$java8methods$utility");
    public final DexString descriptor;
    private String toStringCache = null;

    DexType(DexString descriptor) {
        assert (!descriptor.toString().contains(".")) : "Malformed descriptor: " + descriptor.toString();
        this.descriptor = descriptor;
    }

    @Override
    public int computeHashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexType) {
            return this.descriptor.equals(((DexType)other).descriptor);
        }
        return false;
    }

    public boolean classInitializationMayHaveSideEffects(AppView<?> appView) {
        return this.classInitializationMayHaveSideEffects(appView, Predicates.alwaysFalse());
    }

    public boolean classInitializationMayHaveSideEffects(AppView<?> appView, Predicate<DexType> ignore) {
        DexClass clazz = appView.definitionFor(this);
        return clazz == null || clazz.classInitializationMayHaveSideEffects(appView, ignore);
    }

    public boolean initializationOfParentTypesMayHaveSideEffects(AppView<?> appView) {
        return this.initializationOfParentTypesMayHaveSideEffects(appView, Predicates.alwaysFalse());
    }

    public boolean initializationOfParentTypesMayHaveSideEffects(AppView<?> appView, Predicate<DexType> ignore) {
        DexClass clazz = appView.definitionFor(this);
        return clazz == null || clazz.initializationOfParentTypesMayHaveSideEffects(appView, ignore);
    }

    public boolean isAlwaysNull(AppView<AppInfoWithLiveness> appView) {
        if (this.isClassType()) {
            DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(appView.definitionFor(this));
            if (clazz == null) {
                return false;
            }
            if (appView.options().enableUninstantiatedTypeOptimizationForInterfaces) {
                return !appView.appInfo().isInstantiatedDirectlyOrIndirectly(clazz);
            }
            return !clazz.isInterface() && !appView.appInfo().isInstantiatedDirectlyOrIndirectly(clazz);
        }
        return false;
    }

    public boolean isSamePackage(DexType other) {
        return this.getPackageDescriptor().equals(other.getPackageDescriptor());
    }

    public String toDescriptorString() {
        return this.descriptor.toString();
    }

    public String toBinaryName() {
        String descriptor = this.toDescriptorString();
        assert (descriptor.length() > 1 && descriptor.charAt(0) == 'L' && descriptor.charAt(descriptor.length() - 1) == ';');
        return descriptor.substring(1, descriptor.length() - 1);
    }

    @Override
    public String toSourceString() {
        if (this.toStringCache == null) {
            this.toStringCache = DexItemFactory.isInternalSentinel(this) ? this.descriptor.toString() : DescriptorUtils.descriptorToJavaType(this.toDescriptorString());
        }
        return this.toStringCache;
    }

    public char toShorty() {
        char c = (char)this.descriptor.content[0];
        return c == '[' ? (char)'L' : (char)c;
    }

    @Override
    public String toSmaliString() {
        return this.toDescriptorString();
    }

    public String toString() {
        return this.toSourceString();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection collection, DexMethod method, int instructionOffset) {
        if (collection.addType(this)) {
            collection.getRenamedDescriptor(this).collectIndexedItems(collection, method, instructionOffset);
        }
    }

    @Override
    public void flushCachedValues() {
        super.flushCachedValues();
        this.toStringCache = null;
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public boolean isDexType() {
        return true;
    }

    @Override
    public DexType asDexType() {
        return this;
    }

    @Override
    public int compareTo(DexType other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    @Override
    public int slowCompareTo(DexType other) {
        return this.descriptor.slowCompareTo(other.descriptor);
    }

    @Override
    public int slowCompareTo(DexType other, NamingLens namingLens) {
        DexString thisDescriptor = namingLens.lookupDescriptor(this);
        DexString otherDescriptor = namingLens.lookupDescriptor(other);
        return thisDescriptor.slowCompareTo(otherDescriptor);
    }

    @Override
    public int layeredCompareTo(DexType other, NamingLens namingLens) {
        DexString thisDescriptor = namingLens.lookupDescriptor(this);
        DexString otherDescriptor = namingLens.lookupDescriptor(other);
        return thisDescriptor.compareTo(otherDescriptor);
    }

    public boolean isPrimitiveType() {
        return DescriptorUtils.isPrimitiveType((char)this.descriptor.content[0]);
    }

    public boolean isVoidType() {
        return (char)this.descriptor.content[0] == 'V';
    }

    public boolean isBooleanType() {
        return this.descriptor.content[0] == 90;
    }

    public boolean isByteType() {
        return this.descriptor.content[0] == 66;
    }

    public boolean isCharType() {
        return this.descriptor.content[0] == 67;
    }

    public boolean isShortType() {
        return this.descriptor.content[0] == 83;
    }

    public boolean isIntType() {
        return this.descriptor.content[0] == 73;
    }

    public boolean isFloatType() {
        return this.descriptor.content[0] == 70;
    }

    public boolean isLongType() {
        return this.descriptor.content[0] == 74;
    }

    public boolean isDoubleType() {
        return this.descriptor.content[0] == 68;
    }

    public boolean isArrayType() {
        char firstChar = (char)this.descriptor.content[0];
        return firstChar == '[';
    }

    public boolean isClassType() {
        char firstChar = (char)this.descriptor.content[0];
        return firstChar == 'L';
    }

    public boolean isReferenceType() {
        boolean isReferenceType;
        boolean bl = isReferenceType = this.isArrayType() || this.isClassType();
        assert (isReferenceType != this.isPrimitiveType() || this.isVoidType());
        return isReferenceType;
    }

    public boolean isPrimitiveArrayType() {
        if (!this.isArrayType()) {
            return false;
        }
        return DescriptorUtils.isPrimitiveType((char)this.descriptor.content[1]);
    }

    public boolean isWideType() {
        return this.isDoubleType() || this.isLongType();
    }

    public boolean isD8R8SynthesizedLambdaClassType() {
        String name = this.toSourceString();
        return name.contains("-$$Lambda$");
    }

    public boolean isD8R8SynthesizedClassType() {
        String name = this.toSourceString();
        return name.contains("$-CC") || name.contains("$-EL") || name.contains("$-DC") || name.contains("$-WRP") || name.contains("$-V-WRP") || name.contains("-$$Lambda$") || name.contains("-$$LambdaGroup$") || name.contains("shadow.bundletool.com.android.tools.r8.GeneratedOutlineSupport") || name.contains("$r8$twr$utility") || name.contains("-$$Nest$Constructor") || name.contains("$r8$backportedMethods$utility") || name.contains("$$ServiceLoaderMethods") || this.oldSynthesizedName(name);
    }

    private boolean oldSynthesizedName(String name) {
        for (String synthesizedPrefix : OLD_SYNTHESIZED_NAMES) {
            if (!name.contains(synthesizedPrefix)) continue;
            return true;
        }
        return false;
    }

    public boolean isProgramType(DexDefinitionSupplier definitions) {
        DexClass clazz = definitions.definitionFor(this);
        return clazz != null && clazz.isProgramClass();
    }

    public boolean isResolvable(AppView<?> appView) {
        DexClass clazz = appView.definitionFor(this);
        return clazz != null && clazz.isResolvable(appView);
    }

    public int elementSizeForPrimitiveArrayType() {
        assert (this.isPrimitiveArrayType());
        switch (this.descriptor.content[1]) {
            case 66: 
            case 90: {
                return 1;
            }
            case 67: 
            case 83: {
                return 2;
            }
            case 70: 
            case 73: {
                return 4;
            }
            case 68: 
            case 74: {
                return 8;
            }
        }
        throw new Unreachable("Not array of primitives '" + this.descriptor + "'");
    }

    public int getNumberOfLeadingSquareBrackets() {
        int leadingSquareBrackets = 0;
        while (this.descriptor.content[leadingSquareBrackets] == 91) {
            ++leadingSquareBrackets;
        }
        return leadingSquareBrackets;
    }

    public DexType toBaseType(DexItemFactory dexItemFactory) {
        int leadingSquareBrackets = this.getNumberOfLeadingSquareBrackets();
        if (leadingSquareBrackets == 0) {
            return this;
        }
        DexString newDesc = dexItemFactory.createString(this.descriptor.size - leadingSquareBrackets, Arrays.copyOfRange(this.descriptor.content, leadingSquareBrackets, this.descriptor.content.length));
        return dexItemFactory.createType(newDesc);
    }

    public DexType lookupBaseType(DexItemFactory dexItemFactory) {
        int leadingSquareBrackets = this.getNumberOfLeadingSquareBrackets();
        if (leadingSquareBrackets == 0) {
            return this;
        }
        DexString newDesc = dexItemFactory.lookupString(this.descriptor.size - leadingSquareBrackets, Arrays.copyOfRange(this.descriptor.content, leadingSquareBrackets, this.descriptor.content.length));
        return dexItemFactory.lookupType(newDesc);
    }

    public DexType replaceBaseType(DexType newBase, DexItemFactory dexItemFactory) {
        assert (this.isArrayType());
        assert (!newBase.isArrayType());
        return newBase.toArrayType(this.getNumberOfLeadingSquareBrackets(), dexItemFactory);
    }

    public DexType toArrayType(int dimensions, DexItemFactory dexItemFactory) {
        byte[] content = new byte[this.descriptor.content.length + dimensions];
        Arrays.fill(content, 0, dimensions, (byte)91);
        System.arraycopy(this.descriptor.content, 0, content, dimensions, this.descriptor.content.length);
        DexString newDesc = dexItemFactory.createString(this.descriptor.size + dimensions, content);
        return dexItemFactory.createType(newDesc);
    }

    public DexType toArrayElementType(DexItemFactory dexItemFactory) {
        assert (this.isArrayType());
        DexString newDesc = dexItemFactory.createString(this.descriptor.size - 1, Arrays.copyOfRange(this.descriptor.content, 1, this.descriptor.content.length));
        return dexItemFactory.createType(newDesc);
    }

    private String getPackageOrName(boolean packagePart) {
        assert (this.isClassType());
        String descriptor = this.toDescriptorString();
        int lastSeparator = descriptor.lastIndexOf(47);
        if (lastSeparator == -1) {
            return packagePart ? "" : descriptor.substring(1, descriptor.length() - 1);
        }
        return packagePart ? descriptor.substring(1, lastSeparator) : descriptor.substring(lastSeparator + 1, descriptor.length() - 1);
    }

    public String getPackageDescriptor() {
        return this.getPackageOrName(true);
    }

    public String getName() {
        if (this.isPrimitiveType()) {
            return this.toSourceString();
        }
        return this.getPackageOrName(false);
    }

    public String getInternalName() {
        assert (this.isClassType() || this.isArrayType());
        return DescriptorUtils.descriptorToInternalName(this.toDescriptorString());
    }

    public String getPackageName() {
        return DescriptorUtils.getPackageNameFromBinaryName(this.toBinaryName());
    }

    public Pair<String, String> rewritingPrefixIn(Map<String, String> map2) {
        String javaClassName = this.toString();
        for (String rewritePrefix : map2.keySet()) {
            if (!javaClassName.startsWith(rewritePrefix)) continue;
            return new Pair<String, String>(rewritePrefix, map2.get(rewritePrefix));
        }
        return null;
    }
}

