/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.equivalence;

import java.util.List;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Predicates;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Return;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;

public class BasicBlockBehavioralSubsumption {
    private final AppView<?> appView;
    private final DexType context;

    public BasicBlockBehavioralSubsumption(AppView<?> appView, DexType context) {
        this.appView = appView;
        this.context = context;
    }

    public boolean isSubsumedBy(BasicBlock block, BasicBlock other) {
        return this.isSubsumedBy(block.iterator(), other.iterator(), null);
    }

    private boolean isSubsumedBy(InstructionIterator iterator2, InstructionIterator otherIterator, Set<BasicBlock> visited) {
        Instruction instruction = (Instruction)iterator2.nextUntil(Predicates.or(Predicates.not(this::isBlockLocalInstructionWithoutSideEffects), Instruction::isJumpInstruction));
        if (this.definesValueWithNonLocalUsages(instruction)) {
            return false;
        }
        Instruction otherInstruction = (Instruction)otherIterator.nextUntil(Predicates.or(this::instructionMayHaveSideEffects, Instruction::isJumpInstruction));
        assert (otherInstruction != null);
        if (instruction.isGoto()) {
            BasicBlock targetBlock = instruction.asGoto().getTarget();
            if (otherInstruction.isGoto()) {
                BasicBlock otherTargetBlock = otherInstruction.asGoto().getTarget();
                if (targetBlock == otherTargetBlock) {
                    return this.passesIdenticalValuesForPhis(instruction.getBlock(), otherInstruction.getBlock(), targetBlock);
                }
                if (otherTargetBlock.hasPhis()) {
                    return false;
                }
                otherIterator = otherTargetBlock.iterator();
            } else {
                if (targetBlock.hasPhis()) {
                    return false;
                }
                otherIterator.previous();
            }
            if (visited == null) {
                visited = SetUtils.newIdentityHashSet(instruction.getBlock());
            }
            if (visited.add(targetBlock)) {
                return this.isSubsumedBy(targetBlock.iterator(), otherIterator, visited);
            }
            return false;
        }
        Set<BasicBlock> otherVisited = null;
        while (otherInstruction.isGoto()) {
            BasicBlock block = otherInstruction.getBlock();
            if (otherVisited != null && !otherVisited.add(block)) {
                return false;
            }
            BasicBlock targetBlock = otherInstruction.asGoto().getTarget();
            if (targetBlock.hasPhis()) {
                return false;
            }
            otherIterator = targetBlock.iterator();
            otherInstruction = (Instruction)otherIterator.nextUntil(Predicates.or(this::instructionMayHaveSideEffects, Instruction::isJumpInstruction));
            if (!otherInstruction.isGoto() || otherVisited != null) continue;
            otherVisited = SetUtils.newIdentityHashSet(block);
        }
        if (instruction.isReturn()) {
            Return returnInstruction = instruction.asReturn();
            if (otherInstruction.isReturn()) {
                Return otherReturnInstruction = otherInstruction.asReturn();
                if (returnInstruction.isReturnVoid()) {
                    assert (otherReturnInstruction.isReturnVoid());
                    return true;
                }
                return this.valuesAreIdentical(otherReturnInstruction.returnValue(), returnInstruction.returnValue());
            }
            return false;
        }
        return false;
    }

    private boolean isBlockLocalInstructionWithoutSideEffects(Instruction instruction) {
        return this.definesBlockLocalValue(instruction) && !this.instructionMayHaveSideEffects(instruction);
    }

    private boolean definesBlockLocalValue(Instruction instruction) {
        return !this.definesValueWithNonLocalUsages(instruction);
    }

    private boolean definesValueWithNonLocalUsages(Instruction instruction) {
        if (instruction.hasOutValue()) {
            Value outValue = instruction.outValue();
            if (outValue.numberOfPhiUsers() > 0) {
                return true;
            }
            for (Instruction user : outValue.uniqueUsers()) {
                if (user.getBlock() == instruction.getBlock()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean instructionMayHaveSideEffects(Instruction instruction) {
        return instruction.instructionMayHaveSideEffects(this.appView, this.context);
    }

    private boolean valuesAreIdentical(Value value, Value other) {
        if ((value = value.getAliasedValue()) == (other = other.getAliasedValue())) {
            return true;
        }
        if (value.isPhi() || other.isPhi()) {
            return false;
        }
        return this.instructionsDefineIdenticalValues(value.definition, other.definition);
    }

    private boolean instructionsDefineIdenticalValues(Instruction instruction, Instruction other) {
        assert (instruction.hasOutValue());
        assert (other.hasOutValue());
        Value outValue = instruction.outValue();
        Value otherOutValue = other.outValue();
        if (!outValue.getTypeLattice().equals(otherOutValue.getTypeLattice())) {
            return false;
        }
        if (instruction.isConstClass()) {
            if (!other.isConstClass()) {
                return false;
            }
            ConstClass constClassInstruction = instruction.asConstClass();
            ConstClass otherConstClassInstruction = other.asConstClass();
            return constClassInstruction.getValue() == otherConstClassInstruction.getValue();
        }
        if (instruction.isConstNumber()) {
            if (!other.isConstNumber()) {
                return false;
            }
            ConstNumber constNumberInstruction = instruction.asConstNumber();
            ConstNumber otherConstNumberInstruction = other.asConstNumber();
            return constNumberInstruction.getRawValue() == otherConstNumberInstruction.getRawValue();
        }
        if (instruction.isConstString()) {
            if (!other.isConstString()) {
                return false;
            }
            ConstString constStringInstruction = instruction.asConstString();
            ConstString otherConstStringInstruction = other.asConstString();
            return constStringInstruction.getValue() == otherConstStringInstruction.getValue();
        }
        if (instruction.isDexItemBasedConstString()) {
            if (!other.isDexItemBasedConstString()) {
                return false;
            }
            DexItemBasedConstString constStringInstruction = instruction.asDexItemBasedConstString();
            DexItemBasedConstString otherConstStringInstruction = other.asDexItemBasedConstString();
            return constStringInstruction.getItem() == otherConstStringInstruction.getItem();
        }
        return false;
    }

    private boolean passesIdenticalValuesForPhis(BasicBlock block, BasicBlock other, BasicBlock blockWithPhis) {
        if (block == other) {
            return true;
        }
        int predecessorIndex = -1;
        int otherPredecessorIndex = -1;
        List<BasicBlock> predecessors = blockWithPhis.getPredecessors();
        for (int i = 0; i < predecessors.size(); ++i) {
            BasicBlock predecessor = predecessors.get(i);
            if (predecessor == block) {
                predecessorIndex = i;
                if (otherPredecessorIndex < 0) continue;
                break;
            }
            if (predecessor != other) continue;
            otherPredecessorIndex = i;
            if (predecessorIndex >= 0) break;
        }
        assert (predecessorIndex >= 0);
        assert (otherPredecessorIndex >= 0);
        for (Phi phi : blockWithPhis.getPhis()) {
            if (this.valuesAreIdentical(phi.getOperand(predecessorIndex), phi.getOperand(otherPredecessorIndex))) continue;
            return false;
        }
        return true;
    }
}

