/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis;

import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.ConcreteMutableFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.EmptyFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.KnownFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.fieldvalueanalysis.UnknownFieldSet;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.SingleEnumValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.UnknownValue;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayPut;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.DequeUtils;

public class FieldValueAnalysis {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexProgramClass clazz;
    private final IRCode code;
    private final OptimizationFeedback feedback;
    private final DexEncodedMethod method;
    private Map<BasicBlock, AbstractFieldSet> fieldsMaybeReadBeforeBlockInclusiveCache;

    private FieldValueAnalysis(AppView<AppInfoWithLiveness> appView, IRCode code, OptimizationFeedback feedback, DexProgramClass clazz, DexEncodedMethod method) {
        assert (clazz.type == method.method.holder);
        this.appView = appView;
        this.clazz = clazz;
        this.code = code;
        this.feedback = feedback;
        this.method = method;
        assert (this.clazz != null);
    }

    public static void run(AppView<?> appView, IRCode code, OptimizationFeedback feedback, DexEncodedMethod method) {
        if (!appView.enableWholeProgramOptimizations()) {
            return;
        }
        assert (((AppInfo)appView.appInfo()).hasLiveness());
        if (!method.isInitializer()) {
            return;
        }
        DexProgramClass clazz = appView.definitionFor(method.method.holder).asProgramClass();
        if (method.isInstanceInitializer()) {
            if (!appView.options().enableValuePropagationForInstanceFields) {
                return;
            }
            DexEncodedMethod otherInstanceInitializer = clazz.lookupDirectMethod(other -> other.isInstanceInitializer() && other != method);
            if (otherInstanceInitializer != null) {
                return;
            }
        }
        new FieldValueAnalysis(appView.withLiveness(), code, feedback, clazz, method).computeFieldOptimizationInfo();
    }

    private Map<BasicBlock, AbstractFieldSet> getOrCreateFieldsMaybeReadBeforeBlockInclusive() {
        if (this.fieldsMaybeReadBeforeBlockInclusiveCache == null) {
            this.fieldsMaybeReadBeforeBlockInclusiveCache = this.createFieldsMaybeReadBeforeBlockInclusive();
        }
        return this.fieldsMaybeReadBeforeBlockInclusiveCache;
    }

    private void computeFieldOptimizationInfo() {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        DominatorTree dominatorTree = null;
        DexType context = this.method.method.holder;
        boolean isStraightLineCode = true;
        IdentityHashMap<DexEncodedField, LinkedList> putsPerField = new IdentityHashMap<DexEncodedField, LinkedList>();
        for (Instruction instruction : this.code.instructions()) {
            FieldInstruction fieldPut;
            DexField field;
            DexEncodedField encodedField;
            if (instruction.isFieldPut() && (encodedField = appInfo.resolveField(field = (fieldPut = instruction.asFieldInstruction()).getField())) != null && encodedField.field.holder == context && appInfo.isFieldOnlyWrittenInMethod(encodedField, this.method)) {
                putsPerField.computeIfAbsent(encodedField, ignore -> new LinkedList()).add(fieldPut);
            }
            if (!instruction.isJumpInstruction() || instruction.isGoto() || instruction.isReturn()) continue;
            isStraightLineCode = false;
        }
        List<BasicBlock> normalExitBlocks = this.code.computeNormalExitBlocks();
        for (Map.Entry entry : putsPerField.entrySet()) {
            DexEncodedField encodedField = (DexEncodedField)entry.getKey();
            LinkedList fieldPuts = (LinkedList)entry.getValue();
            if (fieldPuts.size() > 1) continue;
            FieldInstruction fieldPut = (FieldInstruction)fieldPuts.getFirst();
            if (!isStraightLineCode) {
                if (dominatorTree == null) {
                    dominatorTree = new DominatorTree(this.code, DominatorTree.Assumption.NO_UNREACHABLE_BLOCKS);
                }
                if (!dominatorTree.dominatesAllOf(fieldPut.getBlock(), normalExitBlocks)) continue;
            }
            if (this.fieldMaybeReadBeforeInstruction(encodedField, fieldPut)) continue;
            this.updateFieldOptimizationInfo(encodedField, fieldPut.value());
        }
    }

    private boolean fieldMaybeReadBeforeInstruction(DexEncodedField encodedField, Instruction instruction) {
        Instruction current;
        BasicBlock block = instruction.getBlock();
        if (this.fieldMaybeReadBeforeBlock(encodedField, block)) {
            return true;
        }
        DexType context = this.method.method.holder;
        InstructionIterator instructionIterator = block.iterator();
        while (instructionIterator.hasNext() && (current = (Instruction)instructionIterator.next()) != instruction) {
            if (!current.readSet(this.appView, context).contains(encodedField)) continue;
            return true;
        }
        return false;
    }

    private boolean fieldMaybeReadBeforeBlock(DexEncodedField encodedField, BasicBlock block) {
        for (BasicBlock predecessor : block.getPredecessors()) {
            if (!this.fieldMaybeReadBeforeBlockInclusive(encodedField, predecessor)) continue;
            return true;
        }
        return false;
    }

    private boolean fieldMaybeReadBeforeBlockInclusive(DexEncodedField encodedField, BasicBlock block) {
        return this.getOrCreateFieldsMaybeReadBeforeBlockInclusive().get(block).contains(encodedField);
    }

    private Map<BasicBlock, AbstractFieldSet> createFieldsMaybeReadBeforeBlockInclusive() {
        DexType context = this.method.method.holder;
        IdentityHashMap<BasicBlock, AbstractFieldSet> result = new IdentityHashMap<BasicBlock, AbstractFieldSet>();
        Deque<BasicBlock> worklist = DequeUtils.newArrayDeque(this.code.entryBlock());
        while (!worklist.isEmpty()) {
            BasicBlock block = worklist.removeFirst();
            boolean seenBefore = result.containsKey(block);
            AbstractFieldSet readSet = result.computeIfAbsent(block, ignore -> EmptyFieldSet.getInstance());
            if (readSet.isTop()) continue;
            assert (readSet.isKnownFieldSet());
            KnownFieldSet knownReadSet = readSet.asKnownFieldSet();
            int oldSize = seenBefore ? knownReadSet.size() : -1;
            boolean blockOrPredecessorMaybeReadAnyField = false;
            for (BasicBlock predecessor : block.getPredecessors()) {
                AbstractFieldSet predecessorReadSet = result.getOrDefault(predecessor, EmptyFieldSet.getInstance());
                if (predecessorReadSet.isBottom()) continue;
                if (predecessorReadSet.isTop()) {
                    blockOrPredecessorMaybeReadAnyField = true;
                    break;
                }
                assert (predecessorReadSet.isConcreteFieldSet());
                if (!knownReadSet.isConcreteFieldSet()) {
                    knownReadSet = new ConcreteMutableFieldSet();
                }
                knownReadSet.asConcreteFieldSet().addAll(predecessorReadSet.asConcreteFieldSet());
            }
            if (!blockOrPredecessorMaybeReadAnyField) {
                for (Instruction instruction : block.getInstructions()) {
                    AbstractFieldSet instructionReadSet = instruction.readSet(this.appView, context);
                    if (instructionReadSet.isBottom()) continue;
                    if (instructionReadSet.isTop()) {
                        blockOrPredecessorMaybeReadAnyField = true;
                        break;
                    }
                    if (!knownReadSet.isConcreteFieldSet()) {
                        knownReadSet = new ConcreteMutableFieldSet();
                    }
                    knownReadSet.asConcreteFieldSet().addAll(instructionReadSet.asConcreteFieldSet());
                }
            }
            boolean changed = false;
            if (blockOrPredecessorMaybeReadAnyField) {
                result.put(block, UnknownFieldSet.getInstance());
                changed = true;
            } else if (knownReadSet.size() != oldSize) {
                assert (knownReadSet.size() > oldSize);
                changed = true;
            }
            if (!changed) continue;
            worklist.addAll(block.getSuccessors());
        }
        return result;
    }

    private void updateFieldOptimizationInfo(DexEncodedField field, Value value) {
        ClassTypeLatticeElement dynamicLowerBoundType;
        Value root = value.getAliasedValue();
        AbstractValue abstractValue = this.computeAbstractValue(root);
        if (!abstractValue.isUnknown()) {
            this.feedback.recordFieldHasAbstractValue(field, this.appView, abstractValue);
        }
        TypeLatticeElement fieldType = TypeLatticeElement.fromDexType(field.field.type, Nullability.maybeNull(), this.appView);
        TypeLatticeElement dynamicUpperBoundType = value.getDynamicUpperBoundType(this.appView);
        if (dynamicUpperBoundType.strictlyLessThan(fieldType, this.appView)) {
            this.feedback.markFieldHasDynamicUpperBoundType(field, dynamicUpperBoundType);
        }
        if ((dynamicLowerBoundType = value.getDynamicLowerBoundType(this.appView)) != null) {
            assert (dynamicLowerBoundType.lessThanOrEqual(dynamicUpperBoundType, this.appView));
            this.feedback.markFieldHasDynamicLowerBoundType(field, dynamicLowerBoundType);
        }
    }

    private AbstractValue computeAbstractValue(Value value) {
        SingleEnumValue singleEnumValue;
        assert (!value.hasAliasedValue());
        if (this.clazz.isEnum() && (singleEnumValue = this.getSingleEnumValue(value)) != null) {
            return singleEnumValue;
        }
        if (!value.isPhi()) {
            return value.definition.getAbstractValue(this.appView, this.clazz.type);
        }
        return UnknownValue.getInstance();
    }

    private SingleEnumValue getSingleEnumValue(Value value) {
        assert (this.clazz.isEnum());
        assert (!value.hasAliasedValue());
        if (value.isPhi() || !value.definition.isNewInstance()) {
            return null;
        }
        NewInstance newInstance = value.definition.asNewInstance();
        if (newInstance.clazz != this.clazz.type) {
            return null;
        }
        if (value.hasDebugUsers() || value.hasPhiUsers()) {
            return null;
        }
        DexEncodedField enumField = null;
        block5: for (Instruction user : value.uniqueUsers()) {
            switch (user.opcode()) {
                case 8: {
                    ArrayPut arrayPut = user.asArrayPut();
                    if (arrayPut.value().getAliasedValue() == value && this.isEnumValuesArray(arrayPut.array())) continue block5;
                    return null;
                }
                case 32: {
                    InvokeDirect invoke = user.asInvokeDirect();
                    if (this.appView.dexItemFactory().isConstructor(invoke.getInvokedMethod()) && invoke.getReceiver() == value) continue block5;
                    return null;
                }
                case 58: {
                    DexEncodedField field = this.clazz.lookupStaticField(user.asStaticPut().getField());
                    if (field == null || !field.accessFlags.isEnum()) continue block5;
                    if (enumField != null) {
                        return null;
                    }
                    enumField = field;
                    continue block5;
                }
            }
            return null;
        }
        if (enumField == null) {
            return null;
        }
        return this.appView.abstractValueFactory().createSingleEnumValue(enumField.field);
    }

    private boolean isEnumValuesArray(Value value) {
        assert (this.clazz.isEnum());
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        DexField valuesField = dexItemFactory.createField(this.clazz.type, this.clazz.type.toArrayType(1, dexItemFactory), dexItemFactory.enumValuesFieldName);
        Value root = value.getAliasedValue();
        if (root.isPhi()) {
            return false;
        }
        Instruction definition = root.definition;
        if (definition.isNewArrayEmpty()) {
            for (Instruction user : root.aliasedUsers()) {
                if (!user.isStaticPut() || user.asStaticPut().getField() != valuesField) continue;
                return true;
            }
        } else if (definition.isStaticGet()) {
            return definition.asStaticGet().getField() == valuesField;
        }
        return false;
    }
}

