/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.proto;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallGraph;

public class GeneratedMessageLiteBuilderShrinker {
    private final ProtoReferences references;

    GeneratedMessageLiteBuilderShrinker(ProtoReferences references) {
        this.references = references;
    }

    public boolean deferDeadProtoBuilders(DexProgramClass clazz, DexEncodedMethod context, BooleanSupplier register) {
        if (this.references.isDynamicMethod(context) && this.references.isGeneratedMessageLiteBuilder(clazz)) {
            return register.getAsBoolean();
        }
        return false;
    }

    public static void addInliningHeuristicsForBuilderInlining(AppView<? extends AppInfoWithSubtyping> appView, Set<DexMethod> alwaysInline, Set<DexMethod> neverInline, Set<DexMethod> bypassClinitforInlining) {
        new RootSetExtension(appView, alwaysInline, neverInline, bypassClinitforInlining).extend();
    }

    public void preprocessCallGraphBeforeCycleElimination(Map<DexMethod, CallGraph.Node> nodes) {
        CallGraph.Node node = nodes.get(this.references.generatedMessageLiteBuilderMethods.constructorMethod);
        if (node != null) {
            ArrayList<CallGraph.Node> calleesToBeRemoved = new ArrayList<CallGraph.Node>();
            for (CallGraph.Node callee : node.getCalleesWithDeterministicOrder()) {
                if (!this.references.isDynamicMethodBridge(callee.method)) continue;
                calleesToBeRemoved.add(callee);
            }
            for (CallGraph.Node callee : calleesToBeRemoved) {
                callee.removeCaller(node);
            }
        }
    }

    private static class RootSetExtension {
        private final AppView<? extends AppInfoWithSubtyping> appView;
        private final ProtoReferences references;
        private final Set<DexMethod> alwaysInline;
        private final Set<DexMethod> neverInline;
        private final Set<DexMethod> bypassClinitforInlining;

        RootSetExtension(AppView<? extends AppInfoWithSubtyping> appView, Set<DexMethod> alwaysInline, Set<DexMethod> neverInline, Set<DexMethod> bypassClinitforInlining) {
            this.appView = appView;
            this.references = appView.protoShrinker().references;
            this.alwaysInline = alwaysInline;
            this.neverInline = neverInline;
            this.bypassClinitforInlining = bypassClinitforInlining;
        }

        void extend() {
            this.alwaysInlineCreateBuilderFromGeneratedMessageLite();
            this.neverInlineIsInitializedFromGeneratedMessageLite();
            this.bypassClinitforInliningNewBuilderMethods();
            this.alwaysInlineDynamicMethodFromGeneratedMessageLiteImplementations();
            this.alwaysInlineBuildPartialFromGeneratedMessageLiteBuilder();
        }

        private void bypassClinitforInliningNewBuilderMethods() {
            for (DexType type : this.appView.appInfo().subtypes(this.references.generatedMessageLiteType)) {
                DexEncodedMethod newBuilderMethod;
                DexProgramClass clazz = this.appView.definitionFor(type).asProgramClass();
                if (clazz == null || (newBuilderMethod = clazz.lookupDirectMethod(method -> method.method.name == this.references.newBuilderMethodName)) == null) continue;
                this.bypassClinitforInlining.add(newBuilderMethod.method);
            }
        }

        private void alwaysInlineBuildPartialFromGeneratedMessageLiteBuilder() {
            this.alwaysInline.add(this.references.generatedMessageLiteBuilderMethods.buildPartialMethod);
        }

        private void alwaysInlineCreateBuilderFromGeneratedMessageLite() {
            this.alwaysInline.add(this.references.generatedMessageLiteMethods.createBuilderMethod);
        }

        private void alwaysInlineDynamicMethodFromGeneratedMessageLiteImplementations() {
            DexItemFactory dexItemFactory = this.appView.dexItemFactory();
            for (DexType type : this.appView.appInfo().subtypes(this.references.generatedMessageLiteType)) {
                this.alwaysInline.add(dexItemFactory.createMethod(type, dexItemFactory.createProto(dexItemFactory.objectType, this.references.methodToInvokeType, dexItemFactory.objectType, dexItemFactory.objectType), "dynamicMethod"));
            }
        }

        private void neverInlineIsInitializedFromGeneratedMessageLite() {
            this.neverInline.add(this.references.generatedMessageLiteMethods.isInitializedMethod);
        }
    }
}

