/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.proto;

import java.util.List;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoUtils;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.RawMessageInfoDecoder;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.RawMessageInfoEncoder;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoMessageInfo;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoObject;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayPut;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCodeUtils;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayEmpty;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class GeneratedMessageLiteShrinker {
    private final AppView<AppInfoWithLiveness> appView;
    private final RawMessageInfoDecoder decoder;
    private final RawMessageInfoEncoder encoder;
    private final ProtoReferences references;
    private final BasicBlock.ThrowingInfo throwingInfo;
    private final TypeLatticeElement objectArrayType;
    private final TypeLatticeElement stringType;

    public GeneratedMessageLiteShrinker(AppView<AppInfoWithLiveness> appView, RawMessageInfoDecoder decoder2, ProtoReferences references) {
        this.appView = appView;
        this.decoder = decoder2;
        this.encoder = new RawMessageInfoEncoder(appView.dexItemFactory());
        this.references = references;
        this.throwingInfo = BasicBlock.ThrowingInfo.defaultForConstString(appView.options());
        this.objectArrayType = TypeLatticeElement.fromDexType(appView.dexItemFactory().objectArrayType, Nullability.definitelyNotNull(), appView);
        this.stringType = TypeLatticeElement.stringClassType(appView, Nullability.definitelyNotNull());
    }

    public void run(DexEncodedMethod method, IRCode code) {
        if (this.references.isDynamicMethod(method.method)) {
            this.rewriteDynamicMethod(method, code);
        }
    }

    public void postOptimizeDynamicMethods(IRConverter converter) {
        this.forEachDynamicMethod(method -> converter.processMethod((DexEncodedMethod)method, OptimizationFeedbackIgnore.getInstance(), OneTimeMethodProcessor.getInstance()));
    }

    private void forEachDynamicMethod(Consumer<DexEncodedMethod> consumer) {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            DexEncodedMethod dynamicMethod = clazz.lookupVirtualMethod(this.references::isDynamicMethod);
            if (dynamicMethod == null) continue;
            consumer.accept(dynamicMethod);
        }
    }

    private void rewriteDynamicMethod(DexEncodedMethod method, IRCode code) {
        DexClass context = this.appView.definitionFor(method.method.holder);
        if (context == null || !context.isProgramClass()) {
            return;
        }
        InvokeMethod newMessageInfoInvoke = GeneratedMessageLiteShrinker.getNewMessageInfoInvoke(code, this.references);
        if (newMessageInfoInvoke != null) {
            Value objectsValue;
            Value infoValue = ProtoUtils.getInfoValueFromMessageInfoConstructionInvoke(newMessageInfoInvoke, this.references);
            ProtoMessageInfo protoMessageInfo = this.decoder.run(method, context, infoValue, objectsValue = ProtoUtils.getObjectsValueFromMessageInfoConstructionInvoke(newMessageInfoInvoke, this.references));
            if (protoMessageInfo != null) {
                this.rewriteArgumentsToNewMessageInfo(method, code, newMessageInfoInvoke, infoValue, protoMessageInfo);
                IRCodeUtils.removeArrayAndTransitiveInputsIfNotUsed(code, objectsValue.definition);
            } else assert (false);
        }
    }

    private void rewriteArgumentsToNewMessageInfo(DexEncodedMethod method, IRCode code, InvokeMethod newMessageInfoInvoke, Value infoValue, ProtoMessageInfo protoMessageInfo) {
        this.rewriteInfoArgumentToNewMessageInfo(code, infoValue, protoMessageInfo);
        this.rewriteObjectsArgumentToNewMessageInfo(method, code, newMessageInfoInvoke, protoMessageInfo);
    }

    private void rewriteInfoArgumentToNewMessageInfo(IRCode code, Value infoValue, ProtoMessageInfo protoMessageInfo) {
        infoValue.definition.replace(new ConstString(code.createValue(this.stringType), this.encoder.encodeInfo(protoMessageInfo), this.throwingInfo), code);
    }

    private void rewriteObjectsArgumentToNewMessageInfo(DexEncodedMethod method, IRCode code, InvokeMethod newMessageInfoInvoke, ProtoMessageInfo protoMessageInfo) {
        BasicBlock block = newMessageInfoInvoke.getBlock();
        InstructionListIterator instructionIterator = block.listIterator(code, newMessageInfoInvoke);
        Instruction previous = (Instruction)instructionIterator.previous();
        instructionIterator.setInsertionPosition(newMessageInfoInvoke.getPosition());
        assert (previous == newMessageInfoInvoke);
        List<ProtoObject> objects = this.encoder.encodeObjects(protoMessageInfo);
        Value sizeValue = instructionIterator.insertConstIntInstruction(code, this.appView.options(), objects.size());
        Value newObjectsValue = code.createValue(this.objectArrayType);
        instructionIterator.add(new NewArrayEmpty(newObjectsValue, sizeValue, this.appView.dexItemFactory().objectArrayType));
        for (int i = 0; i < objects.size(); ++i) {
            Value indexValue = instructionIterator.insertConstIntInstruction(code, this.appView.options(), i);
            Instruction materializingInstruction = objects.get(i).buildIR(this.appView, code);
            instructionIterator.add(materializingInstruction);
            instructionIterator.add(new ArrayPut(MemberType.OBJECT, newObjectsValue, indexValue, materializingInstruction.outValue()));
        }
        ProtoUtils.setObjectsValueForMessageInfoConstructionInvoke(newMessageInfoInvoke, newObjectsValue, this.references);
    }

    public static InvokeMethod getNewMessageInfoInvoke(IRCode code, ProtoReferences references) {
        for (Instruction instruction : code.instructions()) {
            InvokeMethod invoke;
            if (!instruction.isInvokeMethod() || !references.isMessageInfoConstructionMethod((invoke = instruction.asInvokeMethod()).getInvokedMethod())) continue;
            return invoke;
        }
        return null;
    }
}

