/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.CatchHandlers;
import shadow.bundletool.com.android.tools.r8.ir.code.CheckCast;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.DebugLocalRead;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.Goto;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.IRMetadata;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.Return;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Throw;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.NestUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.IteratorUtils;

public class BasicBlockInstructionListIterator
implements InstructionListIterator {
    protected final BasicBlock block;
    protected final ListIterator<Instruction> listIterator;
    protected Instruction current;
    protected Position position = null;
    private final IRMetadata metadata;

    BasicBlockInstructionListIterator(IRMetadata metadata, BasicBlock block) {
        this.block = block;
        this.listIterator = block.getInstructions().listIterator();
        this.metadata = metadata;
    }

    BasicBlockInstructionListIterator(IRMetadata metadata, BasicBlock block, int index) {
        this.block = block;
        this.listIterator = block.getInstructions().listIterator(index);
        this.metadata = metadata;
    }

    BasicBlockInstructionListIterator(IRMetadata metadata, BasicBlock block, Instruction instruction) {
        this(metadata, block);
        this.nextUntil(x -> x == instruction);
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasNext();
    }

    @Override
    public Instruction next() {
        this.current = this.listIterator.next();
        return this.current;
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public Instruction previous() {
        this.current = this.listIterator.previous();
        return this.current;
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public void setInsertionPosition(Position position) {
        this.position = position;
    }

    @Override
    public void add(Instruction instruction) {
        instruction.setBlock(this.block);
        assert (instruction.getBlock() == this.block);
        if (this.position != null && !instruction.hasPosition()) {
            instruction.setPosition(this.position);
        }
        this.listIterator.add(instruction);
        this.metadata.record(instruction);
    }

    @Override
    public void set(Instruction instruction) {
        instruction.setBlock(this.block);
        assert (instruction.getBlock() == this.block);
        this.listIterator.set(instruction);
        this.metadata.record(instruction);
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        assert (this.current.outValue() == null || !this.current.outValue().isUsed());
        assert (this.current.getDebugValues().isEmpty());
        for (int i = 0; i < this.current.inValues().size(); ++i) {
            Value value = this.current.inValues().get(i);
            value.removeUser(this.current);
        }
        for (Value value : this.current.getDebugValues()) {
            value.removeDebugUser(this.current);
        }
        if (this.current.getLocalInfo() != null) {
            for (Instruction user : this.current.outValue().debugUsers()) {
                user.removeDebugValue(this.current.outValue());
            }
        }
        this.listIterator.remove();
        this.current = null;
    }

    @Override
    public void removeInstructionIgnoreOutValue() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.listIterator.remove();
        this.current = null;
    }

    @Override
    public void removeOrReplaceByDebugLocalRead() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        if (this.current.getDebugValues().isEmpty()) {
            this.remove();
        } else {
            this.replaceCurrentInstruction(new DebugLocalRead());
        }
    }

    @Override
    public void replaceCurrentInstruction(Instruction newInstruction) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        for (Value value : this.current.inValues()) {
            value.removeUser(this.current);
        }
        if (this.current.outValue() != null && this.current.outValue().isUsed()) {
            assert (newInstruction.outValue() != null);
            this.current.outValue().replaceUsers(newInstruction.outValue());
        }
        this.current.moveDebugValues(newInstruction);
        newInstruction.setBlock(this.block);
        newInstruction.setPosition(this.current.getPosition());
        this.listIterator.remove();
        this.listIterator.add(newInstruction);
        this.current.clearBlock();
        this.metadata.record(newInstruction);
    }

    @Override
    public Value insertConstNullInstruction(IRCode code, InternalOptions options) {
        ConstNumber constNumberInstruction = code.createConstNull();
        constNumberInstruction.setPosition(options.debug ? this.current.getPosition() : Position.none());
        this.add(constNumberInstruction);
        return constNumberInstruction.outValue();
    }

    @Override
    public Value insertConstIntInstruction(IRCode code, InternalOptions options, int value) {
        ConstNumber constNumberInstruction = code.createIntConstant(value);
        constNumberInstruction.setPosition(options.debug ? this.current.getPosition() : Position.none());
        this.add(constNumberInstruction);
        return constNumberInstruction.outValue();
    }

    @Override
    public void replaceCurrentInstructionWithConstInt(AppView<? extends AppInfoWithSubtyping> appView, IRCode code, int value) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        assert (!this.current.hasOutValue() || this.current.outValue().getTypeLattice().isInt());
        ConstNumber constNumber = code.createIntConstant(value, this.current.getLocalInfo());
        for (Value inValue : this.current.inValues()) {
            if (!inValue.hasLocalInfo()) continue;
            constNumber.addDebugValue(inValue);
        }
        this.replaceCurrentInstruction(constNumber);
    }

    @Override
    public void replaceCurrentInstructionWithStaticGet(AppView<? extends AppInfoWithSubtyping> appView, IRCode code, DexField field, Set<Value> affectedValues) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        TypeLatticeElement newType = TypeLatticeElement.fromDexType(field.type, Nullability.maybeNull(), appView);
        TypeLatticeElement oldType = this.current.hasOutValue() ? this.current.outValue().getTypeLattice() : null;
        Value value = code.createValue(newType, this.current.getLocalInfo());
        StaticGet staticGet = new StaticGet(value, field);
        for (Value inValue : this.current.inValues()) {
            if (!inValue.hasLocalInfo()) continue;
            staticGet.addDebugValue(inValue);
        }
        this.replaceCurrentInstruction(staticGet);
        if (value.hasAnyUsers() && !newType.equals(oldType)) {
            affectedValues.addAll(value.affectedValues());
        }
    }

    @Override
    public void replaceCurrentInstructionWithThrowNull(AppView<? extends AppInfoWithSubtyping> appView, IRCode code, ListIterator<BasicBlock> blockIterator, Set<BasicBlock> blocksToRemove, Set<Value> affectedValues) {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        BasicBlock block = this.current.getBlock();
        assert (!blocksToRemove.contains(block));
        assert (affectedValues != null);
        BasicBlock normalSuccessorBlock = this.split(code, blockIterator);
        this.previous();
        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        blocksToRemove.addAll(block.unlink(normalSuccessorBlock, dominatorTree, affectedValues));
        this.previous();
        Value nullValue = this.insertConstNullInstruction(code, appView.options());
        this.next();
        Throw throwInstruction = new Throw(nullValue);
        for (Value inValue : this.current.inValues()) {
            if (!inValue.hasLocalInfo()) continue;
            throwInstruction.addDebugValue(inValue);
        }
        this.replaceCurrentInstruction(throwInstruction);
        this.next();
        this.remove();
        if (block.hasCatchHandlers()) {
            CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
            catchHandlers.forEach((guard, target) -> {
                if (blocksToRemove.contains(target)) {
                    return;
                }
                if (!((AppInfoWithSubtyping)appView.appInfo()).isSubtype(appView.dexItemFactory().npeType, (DexType)guard)) {
                    DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
                    blocksToRemove.addAll(block.unlink((BasicBlock)target, dominatorTree, affectedValues));
                }
            });
        }
    }

    @Override
    public BasicBlock split(IRCode code, ListIterator<BasicBlock> blocksIterator) {
        LinkedList<BasicBlock> blocks = code.blocks;
        assert (blocksIterator == null || IteratorUtils.peekPrevious(blocksIterator) == this.block);
        int blockNumber = code.getHighestBlockNumber() + 1;
        assert (this.hasNext());
        Position position = this.current != null ? this.current.getPosition() : this.block.getPosition();
        boolean keepCatchHandlers = this.hasPrevious() && this.peekPrevious().instructionTypeCanThrow();
        BasicBlock newBlock = this.block.createSplitBlock(blockNumber, keepCatchHandlers);
        Goto newGoto = new Goto(this.block);
        this.listIterator.add(newGoto);
        newGoto.setPosition(position);
        while (this.listIterator.hasNext()) {
            Instruction instruction = this.listIterator.next();
            newBlock.getInstructions().addLast(instruction);
            instruction.setBlock(newBlock);
            this.listIterator.remove();
        }
        if (blocksIterator == null) {
            blocks.add(blocks.indexOf(this.block) + 1, newBlock);
        } else {
            blocksIterator.add(newBlock);
            blocksIterator.previous();
            blocksIterator.next();
        }
        return newBlock;
    }

    @Override
    public BasicBlock split(IRCode code, int instructions, ListIterator<BasicBlock> blocksIterator) {
        BasicBlock newBlock = this.split(code, blocksIterator);
        assert (blocksIterator == null || IteratorUtils.peekPrevious(blocksIterator) == newBlock);
        InstructionListIterator iterator2 = newBlock.listIterator(code);
        for (int i = 0; i < instructions; ++i) {
            iterator2.next();
        }
        iterator2.split(code, blocksIterator);
        return newBlock;
    }

    private boolean canThrow(IRCode code) {
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            boolean throwing = ((Instruction)iterator2.next()).instructionTypeCanThrow();
            if (!throwing) continue;
            return true;
        }
        return false;
    }

    private void splitBlockAndCopyCatchHandlers(AppView<?> appView, IRCode code, BasicBlock invokeBlock, BasicBlock inlinedBlock, ListIterator<BasicBlock> blocksIterator) {
        InstructionListIterator instructionsIterator = inlinedBlock.listIterator(code);
        BasicBlock currentBlock = inlinedBlock;
        while (currentBlock != null && instructionsIterator.hasNext()) {
            assert (!currentBlock.hasCatchHandlers());
            Instruction throwingInstruction = instructionsIterator.nextUntil(Instruction::instructionTypeCanThrow);
            if (throwingInstruction != null) {
                BasicBlock b;
                BasicBlock nextBlock;
                if (instructionsIterator.hasNext()) {
                    nextBlock = instructionsIterator.split(code, blocksIterator);
                    assert (nextBlock.getPredecessors().size() == 1);
                    assert (currentBlock == nextBlock.getPredecessors().get(0));
                    b = blocksIterator.previous();
                    assert (b == nextBlock);
                } else {
                    nextBlock = null;
                }
                currentBlock.copyCatchHandlers(code, blocksIterator, invokeBlock, appView.options());
                if (nextBlock != null) {
                    b = blocksIterator.next();
                    assert (b == nextBlock);
                    instructionsIterator = nextBlock.listIterator(code);
                } else {
                    instructionsIterator = null;
                }
                currentBlock = nextBlock;
                continue;
            }
            assert (!instructionsIterator.hasNext());
            instructionsIterator = null;
            currentBlock = null;
        }
    }

    private void appendCatchHandlers(AppView<?> appView, IRCode code, BasicBlock invokeBlock, IRCode inlinee, ListIterator<BasicBlock> blocksIterator) {
        for (int i = 0; i < inlinee.blocks.size(); ++i) {
            blocksIterator.previous();
        }
        assert (IteratorUtils.peekNext(blocksIterator) == inlinee.entryBlock());
        for (BasicBlock inlinedBlock : inlinee.blocks) {
            BasicBlock expected = blocksIterator.next();
            assert (inlinedBlock == expected);
            if (inlinedBlock.hasCatchHandlers()) {
                inlinedBlock.copyCatchHandlers(code, blocksIterator, invokeBlock, appView.options());
                continue;
            }
            this.splitBlockAndCopyCatchHandlers(appView, code, invokeBlock, inlinedBlock, blocksIterator);
        }
    }

    private static void removeArgumentInstruction(InstructionListIterator iterator2, Value expectedArgument) {
        assert (iterator2.hasNext());
        Instruction instruction = (Instruction)iterator2.next();
        assert (instruction.isArgument());
        assert (!instruction.outValue().isUsed());
        assert (instruction.outValue() == expectedArgument);
        iterator2.remove();
    }

    @Override
    public BasicBlock inlineInvoke(AppView<?> appView, IRCode code, IRCode inlinee, ListIterator<BasicBlock> blocksIterator, Set<BasicBlock> blocksToRemove, DexType downcast) {
        InstructionListIterator entryBlockIterator;
        assert (blocksToRemove != null);
        DexType codeHolder = code.method.method.holder;
        DexType inlineeHolder = inlinee.method.method.holder;
        if (codeHolder != inlineeHolder && inlinee.method.isOnlyInlinedIntoNestMembers()) {
            assert (NestUtils.sameNest(codeHolder, inlineeHolder, appView));
            NestUtils.rewriteNestCallsForInlining(inlinee, codeHolder, appView);
        }
        boolean inlineeCanThrow = this.canThrow(inlinee);
        BasicBlock invokeBlock = this.split(code, 1, blocksIterator);
        assert (invokeBlock.getInstructions().size() == 2);
        assert (invokeBlock.getInstructions().getFirst().isInvoke());
        Invoke invoke = invokeBlock.getInstructions().getFirst().asInvoke();
        BasicBlock invokePredecessor = invokeBlock.getPredecessors().get(0);
        BasicBlock invokeSuccessor = invokeBlock.getSuccessors().get(0);
        if (!inlinee.doAllThrowingInstructionsHavePositions()) {
            code.setAllThrowingInstructionsHavePositions(false);
        }
        Set<Value> argumentUsers = Sets.newIdentityHashSet();
        List<Value> arguments = inlinee.collectArguments();
        assert (invoke.inValues().size() == arguments.size());
        BasicBlock entryBlock = inlinee.entryBlock();
        int i = 0;
        assert (downcast == null || arguments.get(0).isThis());
        if (downcast != null && arguments.get(0).isUsed()) {
            Value receiver = invoke.inValues().get(0);
            TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(downcast, receiver.getTypeLattice().nullability(), appView);
            CheckCast castInstruction = new CheckCast(code.createValue(castTypeLattice), receiver, downcast);
            castInstruction.setPosition(invoke.getPosition());
            if (entryBlock.canThrow()) {
                BasicBlock inlineEntry = entryBlock;
                entryBlock = entryBlock.listIterator(code).split(inlinee);
                entryBlockIterator = entryBlock.listIterator(code);
                inlineEntry.listIterator(code).add(castInstruction);
                castInstruction.setBlock(inlineEntry);
                assert (castInstruction.getBlock().getInstructions().size() == 2);
            } else {
                castInstruction.setBlock(entryBlock);
                entryBlockIterator = entryBlock.listIterator(code);
                entryBlockIterator.add(castInstruction);
            }
            Value argument = arguments.get(i);
            argumentUsers.addAll(argument.affectedValues());
            argument.replaceUsers(castInstruction.outValue);
            BasicBlockInstructionListIterator.removeArgumentInstruction(entryBlockIterator, argument);
            ++i;
        } else {
            entryBlockIterator = entryBlock.listIterator(code);
        }
        while (i < invoke.inValues().size()) {
            assert (!arguments.get(i).hasLocalInfo());
            Value argument = arguments.get(i);
            argumentUsers.addAll(argument.affectedValues());
            argument.replaceUsers(invoke.inValues().get(i));
            BasicBlockInstructionListIterator.removeArgumentInstruction(entryBlockIterator, argument);
            ++i;
        }
        assert (entryBlock.getInstructions().stream().noneMatch(Instruction::isArgument));
        new TypeAnalysis(appView).narrowing(argumentUsers);
        BasicBlock inlineEntry = inlinee.entryBlock();
        BasicBlock inlineExit = null;
        List<BasicBlock> normalExits = inlinee.computeNormalExitBlocks();
        if (!normalExits.isEmpty()) {
            InstructionListIterator inlineeIterator = this.ensureSingleReturnInstruction(appView, inlinee, normalExits);
            assert (inlineeIterator.peekNext().isReturn());
            if (invoke.outValue() != null) {
                Set<Value> affectedValues = invoke.outValue().affectedValues();
                Return returnInstruction = inlineeIterator.peekNext().asReturn();
                invoke.outValue().replaceUsers(returnInstruction.returnValue());
                new TypeAnalysis(appView).narrowing(Iterables.concat(ImmutableList.of(returnInstruction.returnValue()), affectedValues));
            }
            BasicBlock returnBlock = inlineeIterator.split(inlinee);
            inlineExit = returnBlock.unlinkSinglePredecessor();
            InstructionListIterator returnBlockIterator = returnBlock.listIterator(code);
            returnBlockIterator.next();
            returnBlockIterator.remove();
            assert (!returnBlockIterator.hasNext());
            inlinee.blocks.remove(returnBlock);
            invokeBlock.unlinkSinglePredecessor();
            InstructionListIterator invokeBlockIterator = invokeBlock.listIterator(code);
            invokeBlockIterator.next();
            invokeBlockIterator.remove();
            invokeSuccessor = invokeBlock;
            assert (invokeBlock.getInstructions().getFirst().isGoto());
        }
        invokePredecessor.link(inlineEntry);
        if (inlineExit != null) {
            inlineExit.link(invokeSuccessor);
        }
        if (blocksIterator == null) {
            blocksIterator = code.listIterator(code.blocks.indexOf(invokeBlock));
        } else {
            blocksIterator.previous();
            blocksIterator.previous();
        }
        assert (IteratorUtils.peekNext(blocksIterator) == invokeBlock);
        int blockNumber = code.getHighestBlockNumber() + 1;
        for (BasicBlock bb : inlinee.blocks) {
            bb.setNumber(blockNumber++);
            blocksIterator.add(bb);
        }
        if (invokeBlock.hasCatchHandlers()) {
            this.appendCatchHandlers(appView, code, invokeBlock, inlinee, blocksIterator);
        }
        if (normalExits.isEmpty()) {
            assert (inlineeCanThrow);
            DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
            Set<Value> affectedValues = Sets.newIdentityHashSet();
            blocksToRemove.addAll(invokePredecessor.unlink(invokeBlock, dominatorTree, affectedValues));
            new TypeAnalysis(appView).narrowing(affectedValues);
        }
        blocksIterator.next();
        assert (IteratorUtils.peekPrevious(blocksIterator) == invokeBlock);
        BasicBlock finalInvokeSuccessor = invokeSuccessor;
        assert (invokeSuccessor == invokeBlock || IteratorUtils.anyRemainingMatch(blocksIterator, remaining -> remaining == finalInvokeSuccessor));
        code.metadata().merge(inlinee.metadata());
        return invokeSuccessor;
    }

    private InstructionListIterator ensureSingleReturnInstruction(AppView<?> appView, IRCode code, List<BasicBlock> normalExits) {
        Return newReturn;
        if (normalExits.size() == 1) {
            InstructionListIterator it = normalExits.get(0).listIterator(code);
            it.nextUntil(Instruction::isReturn);
            it.previous();
            return it;
        }
        BasicBlock newExitBlock = new BasicBlock();
        newExitBlock.setNumber(code.getHighestBlockNumber() + 1);
        if (normalExits.get(0).exit().asReturn().isReturnVoid()) {
            newReturn = new Return();
        } else {
            Value value;
            boolean same = true;
            ArrayList<Value> operands = new ArrayList<Value>(normalExits.size());
            for (BasicBlock exitBlock : normalExits) {
                Return exit = exitBlock.exit().asReturn();
                Value retValue = exit.returnValue();
                operands.add(retValue);
                same = same && retValue == operands.get(0);
            }
            if (same) {
                value = (Value)operands.get(0);
            } else {
                Phi phi = new Phi(code.valueNumberGenerator.next(), newExitBlock, TypeLatticeElement.BOTTOM, null, Phi.RegisterReadType.NORMAL);
                phi.addOperands(operands);
                new TypeAnalysis(appView).widening(ImmutableSet.of(phi));
                value = phi;
            }
            newReturn = new Return(value);
        }
        newReturn.setPosition(Position.none());
        newExitBlock.add((Instruction)newReturn, this.metadata);
        for (BasicBlock exitBlock : normalExits) {
            InstructionListIterator it = exitBlock.listIterator(code, exitBlock.getInstructions().size());
            Instruction oldExit = (Instruction)it.previous();
            assert (oldExit.isReturn());
            it.replaceCurrentInstruction(new Goto());
            exitBlock.link(newExitBlock);
        }
        newExitBlock.close(null);
        code.blocks.add(newExitBlock);
        return newExitBlock.listIterator(code);
    }
}

