/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstMethodType;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class ConstMethodType
extends ConstInstruction {
    private final DexProto methodType;

    public ConstMethodType(Value dest, DexProto methodType) {
        super(dest);
        this.methodType = methodType;
    }

    @Override
    public int opcode() {
        return 14;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static ConstMethodType copyOf(IRCode code, ConstMethodType original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.outValue().getTypeLattice(), original.getLocalInfo());
        return ConstMethodType.copyOf(newValue, original);
    }

    public static ConstMethodType copyOf(Value newValue, ConstMethodType original) {
        return new ConstMethodType(newValue, original.getValue());
    }

    public Value dest() {
        return this.outValue;
    }

    public DexProto getValue() {
        return this.methodType;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new shadow.bundletool.com.android.tools.r8.code.ConstMethodType(dest, this.methodType));
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfConstMethodType(this.methodType));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isConstMethodType() && other.asConstMethodType().methodType == this.methodType;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstMethodType has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.methodType + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstMethodType() {
        return true;
    }

    @Override
    public ConstMethodType asConstMethodType() {
        return this;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(appView.dexItemFactory().methodTypeType, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().methodTypeType;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forConstMethodType();
    }
}

