/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.io.UTFDataFormatException;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstString;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.UnknownValue;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;

public class ConstString
extends ConstInstruction {
    private final DexString value;
    private final BasicBlock.ThrowingInfo throwingInfo;

    public ConstString(Value dest, DexString value, BasicBlock.ThrowingInfo throwingInfo) {
        super(dest);
        this.value = value;
        this.throwingInfo = throwingInfo;
    }

    @Override
    public int opcode() {
        return 16;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static ConstString copyOf(IRCode code, ConstString original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.outValue().getTypeLattice(), original.getLocalInfo());
        return ConstString.copyOf(newValue, original);
    }

    public static ConstString copyOf(Value newValue, ConstString original) {
        assert (newValue != original.outValue());
        return new ConstString(newValue, original.getValue(), original.throwingInfo);
    }

    public Value dest() {
        return this.outValue;
    }

    public DexString getValue() {
        return this.value;
    }

    @Override
    public boolean instructionTypeCanBeCanonicalized() {
        return true;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new shadow.bundletool.com.android.tools.r8.code.ConstString(dest, this.value));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isConstString() && other.asConstString().value == this.value;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstString has no register arguments.";
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.value + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return this.throwingInfo == BasicBlock.ThrowingInfo.CAN_THROW;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstString() {
        return true;
    }

    @Override
    public ConstString asConstString() {
        return this;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        if (this.throwingInfo == BasicBlock.ThrowingInfo.NO_THROW) {
            return false;
        }
        try {
            this.value.toString();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof UTFDataFormatException) {
                return true;
            }
            throw e;
        }
        return false;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return appView.options().isGeneratingClassFiles() || !this.instructionInstanceCanThrow();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfConstString(this.value));
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().stringType;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.stringClassType(appView, Nullability.definitelyNotNull());
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }

    @Override
    public AbstractValue getAbstractValue(AppView<?> appView, DexType context) {
        if (!this.instructionInstanceCanThrow()) {
            return appView.abstractValueFactory().createSingleStringValue(this.value);
        }
        return UnknownValue.getInstance();
    }
}

