/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionOrPhi;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.utils.DequeUtils;

public class IRCodeUtils {
    public static void removeArrayAndTransitiveInputsIfNotUsed(IRCode code, Instruction definition) {
        ArrayDeque<InstructionOrPhi> worklist = new ArrayDeque<InstructionOrPhi>();
        if (definition.isConstNumber()) {
            assert (definition.asConstNumber().isZero());
            return;
        }
        if (definition.isNewArrayEmpty()) {
            Value arrayValue = definition.outValue();
            if (arrayValue.hasPhiUsers() || arrayValue.hasDebugUsers()) {
                return;
            }
            for (Instruction user : arrayValue.uniqueUsers()) {
                assert (!user.isAssume());
                if (!user.isArrayPut()) {
                    return;
                }
                worklist.add(user);
            }
            IRCodeUtils.internalRemoveInstructionAndTransitiveInputsIfNotUsed(code, worklist);
            return;
        }
        assert (false);
    }

    public static void removeInstructionAndTransitiveInputsIfNotUsed(IRCode code, Instruction instruction) {
        IRCodeUtils.internalRemoveInstructionAndTransitiveInputsIfNotUsed(code, DequeUtils.newArrayDeque(instruction));
    }

    private static void internalRemoveInstructionAndTransitiveInputsIfNotUsed(IRCode code, Deque<InstructionOrPhi> worklist) {
        Set<InstructionOrPhi> removed = Sets.newIdentityHashSet();
        while (!worklist.isEmpty()) {
            InstructionOrPhi current;
            InstructionOrPhi instructionOrPhi = worklist.removeFirst();
            if (removed.contains(instructionOrPhi)) continue;
            if (instructionOrPhi.isPhi()) {
                current = instructionOrPhi.asPhi();
                if (((Value)((Object)current)).hasUsers() || ((Value)((Object)current)).hasDebugUsers()) continue;
                boolean hasOtherPhiUserThanSelf = false;
                for (Phi phiUser : ((Value)((Object)current)).uniquePhiUsers()) {
                    if (phiUser == current) continue;
                    hasOtherPhiUserThanSelf = true;
                    break;
                }
                if (hasOtherPhiUserThanSelf) continue;
                ((Phi)current).removeDeadPhi();
                for (Value operand : ((Phi)current).getOperands()) {
                    worklist.add(operand.isPhi() ? operand.asPhi() : operand.definition);
                }
                removed.add(current);
                continue;
            }
            current = instructionOrPhi.asInstruction();
            if (((Instruction)current).hasOutValue() && ((Instruction)current).outValue().hasAnyUsers()) continue;
            ((Instruction)current).getBlock().listIterator(code, (Instruction)current).removeOrReplaceByDebugLocalRead();
            for (Value inValue : ((Instruction)current).inValues()) {
                worklist.add(inValue.isPhi() ? inValue.asPhi() : inValue.definition);
            }
            removed.add(current);
        }
    }
}

