/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Set;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFieldInstruction;
import shadow.bundletool.com.android.tools.r8.code.Format22c;
import shadow.bundletool.com.android.tools.r8.code.Iget;
import shadow.bundletool.com.android.tools.r8.code.IgetBoolean;
import shadow.bundletool.com.android.tools.r8.code.IgetByte;
import shadow.bundletool.com.android.tools.r8.code.IgetChar;
import shadow.bundletool.com.android.tools.r8.code.IgetObject;
import shadow.bundletool.com.android.tools.r8.code.IgetShort;
import shadow.bundletool.com.android.tools.r8.code.IgetWide;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class InstanceGet
extends FieldInstruction {
    public InstanceGet(Value dest, Value object, DexField field) {
        super(field, dest, object);
    }

    @Override
    public int opcode() {
        return 27;
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.getField().type.isBooleanType();
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Value dest() {
        return this.outValue;
    }

    public Value object() {
        assert (this.inValues.size() == 1);
        return (Value)this.inValues.get(0);
    }

    @Override
    public Value value() {
        return this.outValue;
    }

    @Override
    public boolean couldIntroduceAnAlias(AppView<?> appView, Value root) {
        assert (root != null && root.getTypeLattice().isReference());
        assert (this.outValue != null);
        return this.outValue.getTypeLattice().isReference();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format22c instruction;
        int destRegister = builder.allocatedRegister(this.dest(), this.getNumber());
        int objectRegister = builder.allocatedRegister(this.object(), this.getNumber());
        DexField field = this.getField();
        switch (this.getType()) {
            case INT: 
            case FLOAT: {
                instruction = new Iget(destRegister, objectRegister, field);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new IgetWide(destRegister, objectRegister, field);
                break;
            }
            case OBJECT: {
                instruction = new IgetObject(destRegister, objectRegister, field);
                break;
            }
            case BOOLEAN: {
                instruction = new IgetBoolean(destRegister, objectRegister, field);
                break;
            }
            case BYTE: {
                instruction = new IgetByte(destRegister, objectRegister, field);
                break;
            }
            case CHAR: {
                instruction = new IgetChar(destRegister, objectRegister, field);
                break;
            }
            case SHORT: {
                instruction = new IgetShort(destRegister, objectRegister, field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.getType()));
            }
        }
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionMayHaveSideEffects(AppView<?> appView, DexType context) {
        return this.instructionInstanceCanThrow(appView, context).isThrowing();
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        return !this.instructionMayHaveSideEffects(appView, code.method.method.holder);
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInstanceGet()) {
            return false;
        }
        InstanceGet o = other.asInstanceGet();
        return o.getField() == this.getField() && o.getType() == this.getType();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInstanceGet(this.getField(), invocationContext);
    }

    @Override
    public boolean isInstanceGet() {
        return true;
    }

    @Override
    public InstanceGet asInstanceGet() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.getField().toSourceString();
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(this.getField().type, Nullability.maybeNull(), appView);
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.getField().type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(180, this.getField(), builder.resolveField(this.getField())));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, DexItemFactory dexItemFactory) {
        return this.object() == value;
    }

    @Override
    public boolean throwsOnNullInput() {
        return true;
    }

    @Override
    public Value getNonNullInput() {
        return this.object();
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, DexType context, AppView<?> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInstanceGet(this, clazz, appView, mode, assumption);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }
}

