/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.List;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInvokeDynamic;
import shadow.bundletool.com.android.tools.r8.code.Base3Format;
import shadow.bundletool.com.android.tools.r8.code.InvokeCustomRange;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaDescriptor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public final class InvokeCustom
extends Invoke {
    private final DexCallSite callSite;

    public InvokeCustom(DexCallSite callSite, Value result, List<Value> arguments) {
        super(result, arguments);
        assert (callSite != null);
        this.callSite = callSite;
    }

    @Override
    public int opcode() {
        return 31;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    private static boolean verifyLambdaInterfaces(TypeLatticeElement returnTypeLattice, Set<DexType> lambdaInterfaceSet, DexType objectType) {
        Set<DexType> primaryInterfaces = returnTypeLattice.asClassTypeLatticeElement().getInterfaces();
        if (returnTypeLattice.asClassTypeLatticeElement().getClassType() == objectType) {
            assert (primaryInterfaces.size() == 1);
            assert (lambdaInterfaceSet.contains(primaryInterfaces.iterator().next()));
        } else {
            assert (primaryInterfaces.isEmpty());
            assert (lambdaInterfaceSet.contains(returnTypeLattice.asClassTypeLatticeElement().getClassType()));
        }
        return true;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        TypeLatticeElement returnTypeLattice = super.evaluate(appView);
        if (!((AppInfo)appView.appInfo()).hasSubtyping()) {
            return returnTypeLattice;
        }
        List<DexType> lambdaInterfaces = LambdaDescriptor.getInterfaces(this.callSite, appView.appInfo());
        if (lambdaInterfaces == null || lambdaInterfaces.isEmpty()) {
            return returnTypeLattice;
        }
        assert (returnTypeLattice instanceof ClassTypeLatticeElement);
        Set<DexType> primaryInterfaces = returnTypeLattice.asClassTypeLatticeElement().getInterfaces();
        DexType objectType = appView.dexItemFactory().objectType;
        if (returnTypeLattice.asClassTypeLatticeElement().getClassType() == objectType) {
            assert (primaryInterfaces.size() == 1);
            if (lambdaInterfaces.size() == 1) {
                assert (lambdaInterfaces.get(0) == primaryInterfaces.iterator().next());
                return returnTypeLattice;
            }
        }
        ImmutableCollection lambdaInterfaceSet = ((ImmutableSet.Builder)ImmutableSet.builder().addAll(lambdaInterfaces)).build();
        assert (InvokeCustom.verifyLambdaInterfaces(returnTypeLattice, (Set<DexType>)((Object)lambdaInterfaceSet), objectType));
        return ClassTypeLatticeElement.create(objectType, Nullability.maybeNull(), (Set<DexType>)((Object)lambdaInterfaceSet));
    }

    @Override
    public DexType getReturnType() {
        return this.callSite.methodProto.returnType;
    }

    public DexCallSite getCallSite() {
        return this.callSite;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.CUSTOM;
    }

    @Override
    protected String getTypeString() {
        return "Custom";
    }

    @Override
    public String toString() {
        return super.toString() + "; call site: " + this.callSite.toSourceString();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeCustomRange(firstRegister, argumentRegisters, this.getCallSite());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new shadow.bundletool.com.android.tools.r8.code.InvokeCustom(argumentRegistersCount, this.getCallSite(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInvokeDynamic(this.getCallSite()));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeCustom() && this.callSite == other.asInvokeCustom().callSite;
    }

    @Override
    public boolean isInvokeCustom() {
        return true;
    }

    @Override
    public InvokeCustom asInvokeCustom() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeCustom();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        if (this.getCallSite().methodProto.returnType.isVoidType()) {
            return;
        }
        if (this.outValue == null) {
            helper.popOutType(this.getCallSite().methodProto.returnType, this, it);
        } else {
            assert (this.outValue.isUsed());
            helper.storeOutValue(this, it);
        }
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.getCallSite().methodProto.returnType;
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return true;
    }
}

