/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.errors.InternalCompilerError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;

public enum ValueType {
    OBJECT,
    INT,
    FLOAT,
    LONG,
    DOUBLE;


    public boolean isObject() {
        return this == OBJECT;
    }

    public boolean isSingle() {
        return this == INT || this == FLOAT;
    }

    public boolean isWide() {
        return this == LONG || this == DOUBLE;
    }

    public int requiredRegisters() {
        return this.isWide() ? 2 : 1;
    }

    public static ValueType fromMemberType(MemberType type) {
        switch (type) {
            case BOOLEAN_OR_BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case OBJECT: {
                return OBJECT;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)type));
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)type));
    }

    public static ValueType fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                throw new InternalCompilerError("No value type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static ValueType fromDexType(DexType type) {
        return ValueType.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }

    public static ValueType fromNumericType(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)type) + "'");
    }

    public static ValueType fromTypeLattice(TypeLatticeElement typeLatticeElement) {
        if (typeLatticeElement.isReference()) {
            return OBJECT;
        }
        if (typeLatticeElement.isInt()) {
            return INT;
        }
        if (typeLatticeElement.isFloat()) {
            return FLOAT;
        }
        if (typeLatticeElement.isLong()) {
            return LONG;
        }
        if (typeLatticeElement.isDouble()) {
            return DOUBLE;
        }
        throw new Unreachable("Unexpected conversion of imprecise type: " + typeLatticeElement);
    }

    public PrimitiveTypeLatticeElement toPrimitiveTypeLattice() {
        switch (this) {
            case INT: {
                return TypeLatticeElement.INT;
            }
            case FLOAT: {
                return TypeLatticeElement.FLOAT;
            }
            case LONG: {
                return TypeLatticeElement.LONG;
            }
            case DOUBLE: {
                return TypeLatticeElement.DOUBLE;
            }
        }
        throw new Unreachable("Unexpected type in conversion to primitive: " + (Object)((Object)this));
    }
}

