/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.code.FillArrayData;
import shadow.bundletool.com.android.tools.r8.code.FillArrayDataPayload;
import shadow.bundletool.com.android.tools.r8.code.Format31t;
import shadow.bundletool.com.android.tools.r8.code.Goto16;
import shadow.bundletool.com.android.tools.r8.code.Goto32;
import shadow.bundletool.com.android.tools.r8.code.IfEq;
import shadow.bundletool.com.android.tools.r8.code.IfEqz;
import shadow.bundletool.com.android.tools.r8.code.IfGe;
import shadow.bundletool.com.android.tools.r8.code.IfGez;
import shadow.bundletool.com.android.tools.r8.code.IfGt;
import shadow.bundletool.com.android.tools.r8.code.IfGtz;
import shadow.bundletool.com.android.tools.r8.code.IfLe;
import shadow.bundletool.com.android.tools.r8.code.IfLez;
import shadow.bundletool.com.android.tools.r8.code.IfLt;
import shadow.bundletool.com.android.tools.r8.code.IfLtz;
import shadow.bundletool.com.android.tools.r8.code.IfNe;
import shadow.bundletool.com.android.tools.r8.code.IfNez;
import shadow.bundletool.com.android.tools.r8.code.InstanceOf;
import shadow.bundletool.com.android.tools.r8.code.Move16;
import shadow.bundletool.com.android.tools.r8.code.MoveFrom16;
import shadow.bundletool.com.android.tools.r8.code.MoveObject;
import shadow.bundletool.com.android.tools.r8.code.MoveObject16;
import shadow.bundletool.com.android.tools.r8.code.MoveObjectFrom16;
import shadow.bundletool.com.android.tools.r8.code.MoveWide;
import shadow.bundletool.com.android.tools.r8.code.MoveWide16;
import shadow.bundletool.com.android.tools.r8.code.MoveWideFrom16;
import shadow.bundletool.com.android.tools.r8.code.Nop;
import shadow.bundletool.com.android.tools.r8.code.Throw;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashBiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Lists;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexCode;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEventBuilder;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Argument;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.CatchHandlers;
import shadow.bundletool.com.android.tools.r8.ir.code.DebugPosition;
import shadow.bundletool.com.android.tools.r8.ir.code.Goto;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.IntSwitch;
import shadow.bundletool.com.android.tools.r8.ir.code.JumpInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Move;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayFilledData;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.Return;
import shadow.bundletool.com.android.tools.r8.ir.code.StackValue;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.CodeRewriter;
import shadow.bundletool.com.android.tools.r8.ir.regalloc.RegisterAllocator;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.InternalOutputMode;

public class DexBuilder {
    private final IRCode ir;
    private final RegisterAllocator registerAllocator;
    private final InternalOptions options;
    private final List<SwitchPayloadInfo> switchPayloadInfos = new ArrayList<SwitchPayloadInfo>();
    private final List<FillArrayDataInfo> fillArrayDataInfos = new ArrayList<FillArrayDataInfo>();
    private final Set<BasicBlock> ifsNeedingRewrite = Sets.newIdentityHashSet();
    private int maxOffset = 0;
    private int minOffset = 0;
    private Info[] instructionToInfo;
    private Info previousNonFallthroughInfo;
    private int inRegisterCount = 0;
    private int outRegisterCount = 0;
    private boolean hasBackwardsBranch = false;
    BasicBlock nextBlock;

    public DexBuilder(IRCode ir, RegisterAllocator registerAllocator) {
        this(ir, registerAllocator, registerAllocator.options());
        assert (ir != null);
    }

    private DexBuilder(IRCode ir, RegisterAllocator registerAllocator, InternalOptions options) {
        this.ir = ir;
        this.registerAllocator = registerAllocator;
        this.options = options;
        if (this.isBuildingForComparison()) {
            this.instructionToInfo = new Info[1];
        }
    }

    public static boolean identicalInstructionsAfterBuildingDexCode(Instruction a, Instruction b, RegisterAllocator allocator) {
        DexBuilder builder = new DexBuilder(null, allocator, allocator.options());
        Info infoA = DexBuilder.buildInfoForComparison(a, builder);
        Info infoB = DexBuilder.buildInfoForComparison(b, builder);
        return infoA.identicalInstructions(infoB, builder);
    }

    private static Info buildInfoForComparison(Instruction instruction, DexBuilder builder) {
        instruction.buildDex(builder);
        assert (builder.instructionToInfo.length == 1);
        return builder.instructionToInfo[0];
    }

    private boolean isBuildingForComparison() {
        return this.ir == null;
    }

    private void reset() {
        this.switchPayloadInfos.clear();
        this.fillArrayDataInfos.clear();
        this.ifsNeedingRewrite.clear();
        this.maxOffset = 0;
        this.minOffset = 0;
        this.instructionToInfo = new Info[DexBuilder.instructionNumberToIndex(this.ir.numberRemainingInstructions())];
        this.inRegisterCount = 0;
        this.outRegisterCount = 0;
        this.nextBlock = null;
    }

    public DexCode build() {
        Nop payload;
        Nop nop;
        int offset;
        int numberOfInstructions;
        do {
            this.rewriteIfs();
            DexBuilder.removeRedundantDebugPositions(this.ir);
            this.reset();
            numberOfInstructions = 0;
            ListIterator<BasicBlock> iterator2 = this.ir.listIterator();
            assert (iterator2.hasNext());
            BasicBlock block = iterator2.next();
            do {
                this.nextBlock = iterator2.hasNext() ? iterator2.next() : null;
                block.buildDex(this);
            } while ((block = this.nextBlock) != null);
            offset = 0;
            for (Instruction instruction : this.ir.instructions()) {
                Info info = this.getInfo(instruction);
                info.setOffset(offset);
                offset += info.computeSize(this);
                ++numberOfInstructions;
            }
        } while (!this.ifsNeedingRewrite.isEmpty());
        DexDebugEventBuilder debugEventBuilder = new DexDebugEventBuilder(this.ir, this.options);
        ArrayList<shadow.bundletool.com.android.tools.r8.code.Instruction> dexInstructions = new ArrayList<shadow.bundletool.com.android.tools.r8.code.Instruction>(numberOfInstructions);
        int instructionOffset = 0;
        for (Instruction instruction : this.ir.instructions()) {
            Info info = this.getInfo(instruction);
            int previousInstructionCount = dexInstructions.size();
            info.addInstructions(this, dexInstructions);
            int instructionStartOffset = instructionOffset;
            while (previousInstructionCount < dexInstructions.size()) {
                shadow.bundletool.com.android.tools.r8.code.Instruction dexInstruction = (shadow.bundletool.com.android.tools.r8.code.Instruction)dexInstructions.get(previousInstructionCount++);
                dexInstruction.setOffset(instructionOffset);
                instructionOffset += dexInstruction.getSize();
            }
            debugEventBuilder.add(instructionStartOffset, instructionOffset, instruction);
        }
        if (this.options.canHaveTracingPastInstructionsStreamBug() && dexInstructions.get(dexInstructions.size() - 1) instanceof Throw && this.hasBackwardsBranch) {
            shadow.bundletool.com.android.tools.r8.code.Instruction instruction = (shadow.bundletool.com.android.tools.r8.code.Instruction)dexInstructions.get(dexInstructions.size() - 1);
            offset = instruction.getOffset();
            shadow.bundletool.com.android.tools.r8.code.Goto goto_ = new shadow.bundletool.com.android.tools.r8.code.Goto(instruction.getSize() + 1);
            shadow.bundletool.com.android.tools.r8.code.Goto backward = new shadow.bundletool.com.android.tools.r8.code.Goto(-instruction.getSize());
            goto_.setOffset(offset);
            instruction.setOffset(offset += ((shadow.bundletool.com.android.tools.r8.code.Instruction)goto_).getSize());
            backward.setOffset(offset += instruction.getSize());
            offset += ((shadow.bundletool.com.android.tools.r8.code.Instruction)backward).getSize();
            dexInstructions.remove(dexInstructions.size() - 1);
            dexInstructions.add(goto_);
            dexInstructions.add(instruction);
            dexInstructions.add(backward);
        }
        for (SwitchPayloadInfo switchPayloadInfo : this.switchPayloadInfos) {
            if (offset % 2 != 0) {
                nop = new Nop();
                nop.setOffset(offset++);
                dexInstructions.add(nop);
            }
            payload = this.createSwitchPayload(switchPayloadInfo, offset);
            payload.setOffset(offset);
            offset += payload.getSize();
            dexInstructions.add(payload);
        }
        for (FillArrayDataInfo fillArrayDataInfo : this.fillArrayDataInfos) {
            if (offset % 2 != 0) {
                nop = new Nop();
                nop.setOffset(offset++);
                dexInstructions.add(nop);
            }
            payload = fillArrayDataInfo.ir.createPayload();
            payload.setOffset(offset);
            fillArrayDataInfo.dex.setPayloadOffset(offset - fillArrayDataInfo.dex.getOffset());
            offset += ((FillArrayDataPayload)payload).getSize();
            dexInstructions.add(payload);
        }
        TryInfo tryInfo = this.computeTryInfo();
        DexCode dexCode = new DexCode(this.registerAllocator.registersUsed(), this.inRegisterCount, this.outRegisterCount, dexInstructions.toArray(shadow.bundletool.com.android.tools.r8.code.Instruction.EMPTY_ARRAY), tryInfo.tries, tryInfo.handlers, debugEventBuilder.build());
        return dexCode;
    }

    private static boolean isTrivialFallthroughTarget(BasicBlock previousBlock, BasicBlock currentBlock) {
        return previousBlock.exit().isGoto() && currentBlock.getPredecessors().size() == 1 && currentBlock.getPredecessors().get(0) == previousBlock;
    }

    public static void removeRedundantDebugPositions(IRCode code) {
        if (!code.metadata().mayHaveDebugPosition()) {
            return;
        }
        Position currentMaterializedPosition = Position.none();
        Instruction unresolvedPosition = null;
        Int2ReferenceOpenHashMap<DebugLocalInfo> localsAtUnresolvedPosition = null;
        ArrayList<Instruction> toRemove = new ArrayList<Instruction>();
        HashSet<BasicBlock> trivialBlocks = new HashSet<BasicBlock>();
        for (int blockIndex = 0; blockIndex < code.blocks.size(); ++blockIndex) {
            BasicBlock previousBlock;
            BasicBlock currentBlock = code.blocks.get(blockIndex);
            if (blockIndex != 0 && !DexBuilder.isTrivialFallthroughTarget(previousBlock = code.blocks.get(blockIndex - 1), currentBlock)) {
                Position positionAtAllPredecessors = null;
                for (BasicBlock pred : currentBlock.getPredecessors()) {
                    Position predExit = pred == previousBlock ? (unresolvedPosition != null ? unresolvedPosition.getPosition() : currentMaterializedPosition) : pred.exit().getPosition();
                    if (positionAtAllPredecessors == null) {
                        positionAtAllPredecessors = predExit;
                        continue;
                    }
                    if (positionAtAllPredecessors.equals(predExit)) continue;
                    positionAtAllPredecessors = Position.none();
                    break;
                }
                unresolvedPosition = null;
                currentMaterializedPosition = positionAtAllPredecessors;
            }
            Int2ReferenceOpenHashMap<DebugLocalInfo> locals = currentBlock.getLocalsAtEntry() != null ? new Int2ReferenceOpenHashMap<DebugLocalInfo>(currentBlock.getLocalsAtEntry()) : new Int2ReferenceOpenHashMap();
            BasicBlock nextBlock = blockIndex + 1 < code.blocks.size() ? code.blocks.get(blockIndex + 1) : null;
            for (Instruction instruction : currentBlock.getInstructions()) {
                if (instruction.isDebugPosition()) {
                    if (unresolvedPosition == null && currentMaterializedPosition == instruction.getPosition()) {
                        JumpInstruction exit;
                        toRemove.add(instruction.asDebugPosition());
                        if (currentBlock.getInstructions().size() != 2 || !(exit = currentBlock.exit()).isGoto() || exit.getPosition() != currentMaterializedPosition) continue;
                        trivialBlocks.add(currentBlock);
                        continue;
                    }
                    if (unresolvedPosition != null && unresolvedPosition.getPosition() == instruction.getPosition() && ((Object)locals).equals(localsAtUnresolvedPosition)) {
                        toRemove.add(unresolvedPosition);
                        unresolvedPosition = instruction.asDebugPosition();
                        continue;
                    }
                    unresolvedPosition = instruction.asDebugPosition();
                    localsAtUnresolvedPosition = new Int2ReferenceOpenHashMap<DebugLocalInfo>((Int2ReferenceMap<DebugLocalInfo>)locals);
                    continue;
                }
                assert (instruction.getPosition().isSome());
                if (instruction.isDebugLocalsChange()) {
                    instruction.asDebugLocalsChange().apply(locals);
                    continue;
                }
                if (DexBuilder.isNopInstruction(instruction, nextBlock)) continue;
                if (unresolvedPosition != null) {
                    if (unresolvedPosition.getPosition() == instruction.getPosition() && ((Object)locals).equals(localsAtUnresolvedPosition)) {
                        toRemove.add(unresolvedPosition);
                    }
                    unresolvedPosition = null;
                    localsAtUnresolvedPosition = null;
                }
                currentMaterializedPosition = instruction.getPosition();
            }
        }
        if (!toRemove.isEmpty()) {
            InstructionListIterator it = code.instructionListIterator();
            int i = 0;
            while (it.hasNext() && i < toRemove.size()) {
                if (it.next() != toRemove.get(i)) continue;
                it.remove();
                ++i;
            }
            assert (i == toRemove.size());
        }
        if (!trivialBlocks.isEmpty()) {
            ArrayList<BasicBlock> blocksToRemove = new ArrayList<BasicBlock>();
            ListIterator<BasicBlock> iterator2 = code.listIterator();
            assert (code.blocks.size() > 1);
            iterator2.next();
            BasicBlock nextBlock = iterator2.next();
            do {
                BasicBlock block = nextBlock;
                BasicBlock basicBlock = nextBlock = iterator2.hasNext() ? iterator2.next() : null;
                if (!block.isTrivialGoto() || !trivialBlocks.contains(block) || block.exit().asGoto().getTarget() == block || CodeRewriter.isFallthroughBlock(block)) continue;
                BasicBlock target = block.exit().asGoto().getTarget();
                blocksToRemove.add(block);
                CodeRewriter.unlinkTrivialGotoBlock(block, target);
            } while (iterator2.hasNext());
            code.removeBlocks(blocksToRemove);
        }
    }

    private void rewriteIfs() {
        if (this.ifsNeedingRewrite.isEmpty()) {
            return;
        }
        ListIterator<BasicBlock> it = this.ir.listIterator();
        while (it.hasNext()) {
            BasicBlock block = it.next();
            if (!this.ifsNeedingRewrite.contains(block)) continue;
            If theIf = block.exit().asIf();
            BasicBlock trueTarget = theIf.getTrueTarget();
            BasicBlock newBlock = BasicBlock.createGotoBlock(this.ir.blocks.size(), theIf.getPosition(), this.ir.metadata(), trueTarget);
            theIf.setTrueTarget(newBlock);
            theIf.invert();
            it.add(newBlock);
        }
    }

    private void needsIfRewriting(BasicBlock block) {
        this.ifsNeedingRewrite.add(block);
    }

    public void requestOutgoingRegisters(int requiredRegisterCount) {
        if (requiredRegisterCount > this.outRegisterCount) {
            this.outRegisterCount = requiredRegisterCount;
        }
    }

    public int allocatedRegister(Value value, int instructionNumber) {
        return this.registerAllocator.getRegisterForValue(value, instructionNumber);
    }

    public int argumentOrAllocateRegister(Value value, int instructionNumber) {
        return this.registerAllocator.getArgumentOrAllocateRegisterForValue(value, instructionNumber);
    }

    public void addGoto(Goto jump) {
        if (jump.getTarget() != this.nextBlock) {
            this.add((Instruction)jump, new GotoInfo(jump));
        } else {
            this.addNothing(jump);
        }
    }

    private boolean needsNopBetweenMoveAndInstanceOf(InstanceOf instanceOf) {
        int moveDestRegister;
        MoveInfo moveInfo;
        int moveSrcRegister;
        if (!this.options.canHaveArtInstanceOfVerifierBug()) {
            return false;
        }
        return this.previousNonFallthroughInfo instanceof MoveInfo && (moveSrcRegister = (moveInfo = (MoveInfo)this.previousNonFallthroughInfo).srcRegister(this)) != (moveDestRegister = moveInfo.destRegister(this)) && moveSrcRegister == instanceOf.A && moveDestRegister == instanceOf.B;
    }

    public void addInstanceOf(shadow.bundletool.com.android.tools.r8.ir.code.InstanceOf ir, InstanceOf instanceOf) {
        if (this.needsNopBetweenMoveAndInstanceOf(instanceOf)) {
            this.add((Instruction)ir, new Nop(), instanceOf);
        } else {
            this.add((Instruction)ir, (shadow.bundletool.com.android.tools.r8.code.Instruction)instanceOf);
        }
    }

    public void addIf(If branch) {
        assert (this.nextBlock == branch.fallthroughBlock());
        this.add((Instruction)branch, new IfInfo(branch));
    }

    public void addMove(Move move) {
        this.add((Instruction)move, new MoveInfo(move));
    }

    public void addNothing(Instruction instruction) {
        this.add(instruction, new FallThroughInfo(instruction));
    }

    private static boolean isNopInstruction(Instruction instruction, BasicBlock nextBlock) {
        return instruction.isArgument() || instruction.isDebugLocalsChange() || DexBuilder.isNonMaterializingConstNumber(instruction) || instruction.isGoto() && instruction.asGoto().getTarget() == nextBlock;
    }

    private static boolean isNonMaterializingConstNumber(Instruction instruction) {
        return instruction.isConstNumber() && !(instruction.outValue() instanceof StackValue) && !instruction.outValue().needsRegister();
    }

    public void addNop(Instruction ir) {
        this.add(ir, new FixedSizeInfo(ir, new Nop()));
    }

    public void addDebugPosition(DebugPosition position) {
        this.addNop(position);
    }

    public void add(Instruction instr, shadow.bundletool.com.android.tools.r8.code.Instruction dex) {
        assert (!instr.isGoto());
        this.add(instr, new FixedSizeInfo(instr, dex));
    }

    public void add(Instruction ir, shadow.bundletool.com.android.tools.r8.code.Instruction ... dex) {
        assert (!ir.isGoto());
        this.add(ir, new MultiFixedSizeInfo(ir, dex));
    }

    public void addSwitch(IntSwitch s, Format31t dex) {
        assert (this.nextBlock == s.fallthroughBlock());
        this.switchPayloadInfos.add(new SwitchPayloadInfo(s, dex));
        this.add((Instruction)s, (shadow.bundletool.com.android.tools.r8.code.Instruction)dex);
    }

    public void addFillArrayData(NewArrayFilledData nafd, FillArrayData dex) {
        this.fillArrayDataInfos.add(new FillArrayDataInfo(nafd, dex));
        this.add((Instruction)nafd, (shadow.bundletool.com.android.tools.r8.code.Instruction)dex);
    }

    public void addArgument(Argument argument) {
        this.inRegisterCount += argument.outValue().requiredRegisters();
        this.add((Instruction)argument, new FallThroughInfo(argument));
    }

    public void addReturn(Return ret, shadow.bundletool.com.android.tools.r8.code.Instruction dex) {
        if (this.nextBlock != null && ret.identicalAfterRegisterAllocation(this.nextBlock.entry(), this.registerAllocator)) {
            this.addNothing(ret);
        } else {
            this.add((Instruction)ret, dex);
        }
    }

    private void add(Instruction ir, Info info) {
        if (this.isBuildingForComparison()) {
            this.setSingleInfo(info);
            return;
        }
        assert (ir != null);
        assert (info != null);
        assert (this.getInfo(ir) == null);
        info.setMinOffset(this.minOffset);
        info.setMaxOffset(this.maxOffset);
        this.minOffset += info.minSize();
        this.maxOffset += info.maxSize();
        this.setInfo(ir, info);
    }

    public static int instructionNumberToIndex(int instructionNumber) {
        return instructionNumber / 2;
    }

    private Info getInfo(Instruction instruction) {
        assert (instruction.getNumber() >= 0);
        return this.instructionToInfo[DexBuilder.instructionNumberToIndex(instruction.getNumber())];
    }

    private void setInfo(Instruction instruction, Info info) {
        assert (instruction.getNumber() >= 0);
        if (!(info instanceof FallThroughInfo)) {
            this.previousNonFallthroughInfo = info;
        }
        this.instructionToInfo[DexBuilder.instructionNumberToIndex((int)instruction.getNumber())] = info;
    }

    private void setSingleInfo(Info info) {
        assert (this.instructionToInfo.length == 1);
        this.instructionToInfo[0] = info;
    }

    private Info getTargetInfo(BasicBlock block) {
        InstructionIterator iterator2 = block.iterator();
        Instruction instruction = null;
        while (iterator2.hasNext()) {
            instruction = (Instruction)iterator2.next();
            Info info = this.getInfo(instruction);
            if (info instanceof FallThroughInfo) continue;
            return info;
        }
        assert (instruction != null);
        if (instruction.isReturn()) {
            assert (this.getInfo(instruction) instanceof FallThroughInfo);
            return this.getTargetInfo(this.computeNextBlock(block));
        }
        assert (instruction.isGoto());
        return this.getTargetInfo(instruction.asGoto().getTarget());
    }

    private BasicBlock computeNextBlock(BasicBlock block) {
        ListIterator<BasicBlock> it = this.ir.listIterator();
        BasicBlock current = it.next();
        while (current != block) {
            current = it.next();
        }
        return it.next();
    }

    private Nop createSwitchPayload(SwitchPayloadInfo info, int offset) {
        IntSwitch ir = info.ir;
        info.dex.setPayloadOffset(offset - this.getInfo(ir).getOffset());
        int[] targetBlockIndices = ir.targetBlockIndices();
        int[] targets = new int[targetBlockIndices.length];
        for (int i = 0; i < targetBlockIndices.length; ++i) {
            BasicBlock targetBlock = ir.targetBlock(i);
            Instruction targetInstruction = targetBlock.entry();
            targets[i] = this.getInfo(targetInstruction).getOffset() - this.getInfo(ir).getOffset();
        }
        BasicBlock fallthroughBlock = ir.fallthroughBlock();
        Instruction fallthroughTargetInstruction = fallthroughBlock.entry();
        int fallthroughTarget = this.getInfo(fallthroughTargetInstruction).getOffset() - this.getInfo(ir).getOffset();
        return ir.buildPayload(targets, fallthroughTarget, InternalOutputMode.DexIndexed);
    }

    private TryInfo computeTryInfo() {
        HashBiMap<CatchHandlers<BasicBlock>, Integer> canonicalHandlers = HashBiMap.create();
        List<TryItem> tryItems = this.computeTryItems(canonicalHandlers);
        DexCode.Try[] tries = DexBuilder.getDexTryItems(tryItems, canonicalHandlers);
        DexCode.TryHandler[] handlers = this.getDexTryHandlers(canonicalHandlers.inverse());
        return new TryInfo(tries, handlers);
    }

    private List<TryItem> computeTryItems(BiMap<CatchHandlers<BasicBlock>, Integer> handlerToIndex) {
        BiMap<Integer, CatchHandlers<BasicBlock>> indexToHandler = handlerToIndex.inverse();
        ArrayList<TryItem> tryItems = new ArrayList<TryItem>();
        ArrayList<BasicBlock> blocksWithHandlers = new ArrayList<BasicBlock>();
        TryItem currentTryItem = null;
        for (BasicBlock block : this.ir.blocks) {
            CatchHandlers handlers = block.getCatchHandlers();
            assert (handlers.isEmpty() || block.canThrow());
            if (!handlers.isEmpty()) {
                if (handlerToIndex.containsKey(handlers)) {
                    handlers = (CatchHandlers)indexToHandler.get(handlerToIndex.get(handlers));
                } else {
                    handlerToIndex.put(handlers, handlerToIndex.size());
                }
                Info startInfo = this.getInfo(block.entry());
                Info endInfo = this.getInfo(block.exit());
                int start = startInfo.getOffset();
                int end = endInfo.getOffset() + endInfo.getSize();
                currentTryItem = new TryItem(handlers, start, end);
                tryItems.add(currentTryItem);
                blocksWithHandlers.add(block);
                continue;
            }
            if (currentTryItem != null && !block.canThrow()) {
                Info endInfo = this.getInfo(block.exit());
                if (endInfo == null) continue;
                currentTryItem.end = endInfo.getOffset() + endInfo.getSize();
                continue;
            }
            currentTryItem = null;
        }
        if (tryItems.isEmpty()) {
            return tryItems;
        }
        tryItems.sort(TryItem::compareTo);
        ArrayList<TryItem> coalescedTryItems = new ArrayList<TryItem>(tryItems.size());
        TryItem item = null;
        int i = 0;
        block1: while (i < tryItems.size()) {
            if (item != null) {
                item.end = this.trimEnd((BasicBlock)blocksWithHandlers.get(i - 1));
            }
            item = (TryItem)tryItems.get(i);
            coalescedTryItems.add(item);
            LinkedList<Instruction> instructions = ((BasicBlock)blocksWithHandlers.get(i)).getInstructions();
            for (Instruction insn : instructions) {
                if (!insn.instructionTypeCanThrow()) continue;
                item.start = this.getInfo(insn).getOffset();
                break;
            }
            ++i;
            while (i < tryItems.size()) {
                TryItem next = (TryItem)tryItems.get(i);
                if (item.end != next.start || !item.handlers.equals(next.handlers)) continue block1;
                item.end = next.end;
                ++i;
            }
        }
        int lastIndex = tryItems.size() - 1;
        item.end = this.trimEnd((BasicBlock)blocksWithHandlers.get(lastIndex));
        return coalescedTryItems;
    }

    private int trimEnd(BasicBlock block) {
        LinkedList<Instruction> instructions = block.getInstructions();
        for (Instruction insn : Lists.reverse(instructions)) {
            if (!insn.instructionTypeCanThrow()) continue;
            Info info = this.getInfo(insn);
            return info.getOffset() + info.getSize();
        }
        throw new Unreachable("Expected to find a possibly throwing instruction");
    }

    private static DexCode.Try[] getDexTryItems(List<TryItem> tryItems, Map<CatchHandlers<BasicBlock>, Integer> catchHandlers) {
        DexCode.Try[] tries = new DexCode.Try[tryItems.size()];
        for (int i = 0; i < tries.length; ++i) {
            TryItem item = tryItems.get(i);
            DexCode.Try dexTry = new DexCode.Try(item.start, item.end - item.start, -1);
            dexTry.handlerIndex = catchHandlers.get(item.handlers);
            tries[i] = dexTry;
        }
        return tries;
    }

    private DexCode.TryHandler[] getDexTryHandlers(Map<Integer, CatchHandlers<BasicBlock>> catchHandlers) {
        DexCode.TryHandler[] handlers = new DexCode.TryHandler[catchHandlers.size()];
        for (int j = 0; j < catchHandlers.size(); ++j) {
            CatchHandlers<BasicBlock> handlerGroup = catchHandlers.get(j);
            int catchAllOffset = -1;
            ArrayList<DexCode.TryHandler.TypeAddrPair> pairs = new ArrayList<DexCode.TryHandler.TypeAddrPair>();
            for (int i = 0; i < handlerGroup.getGuards().size(); ++i) {
                DexType type = handlerGroup.getGuards().get(i);
                BasicBlock target = handlerGroup.getAllTargets().get(i);
                int targetOffset = this.getInfo(target.entry()).getOffset();
                if (type == this.options.itemFactory.throwableType) {
                    assert (i == handlerGroup.getGuards().size() - 1);
                    catchAllOffset = targetOffset;
                    continue;
                }
                pairs.add(new DexCode.TryHandler.TypeAddrPair(type, targetOffset));
            }
            DexCode.TryHandler.TypeAddrPair[] pairsArray = pairs.toArray(new DexCode.TryHandler.TypeAddrPair[0]);
            handlers[j] = new DexCode.TryHandler(pairsArray, catchAllOffset);
        }
        return handlers;
    }

    public InternalOptions getOptions() {
        return this.options;
    }

    public RegisterAllocator getRegisterAllocator() {
        return this.registerAllocator;
    }

    private static class FillArrayDataInfo {
        public final NewArrayFilledData ir;
        public final FillArrayData dex;

        public FillArrayDataInfo(NewArrayFilledData ir, FillArrayData dex) {
            this.ir = ir;
            this.dex = dex;
        }
    }

    private static class SwitchPayloadInfo {
        public final IntSwitch ir;
        public final Format31t dex;

        public SwitchPayloadInfo(IntSwitch ir, Format31t dex) {
            this.ir = ir;
            this.dex = dex;
        }
    }

    private static class TryItem
    implements Comparable<TryItem> {
        public final CatchHandlers<BasicBlock> handlers;
        public int start;
        public int end;

        public TryItem(CatchHandlers<BasicBlock> handlers, int start, int end) {
            this.handlers = handlers;
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(TryItem other) {
            return Integer.compare(this.start, other.start);
        }
    }

    private static class TryInfo {
        public final DexCode.Try[] tries;
        public final DexCode.TryHandler[] handlers;

        public TryInfo(DexCode.Try[] tries, DexCode.TryHandler[] handlers) {
            this.tries = tries;
            this.handlers = handlers;
        }
    }

    public static class MoveInfo
    extends Info {
        private int size = -1;

        public MoveInfo(Move move) {
            super(move);
        }

        private Move getMove() {
            return (Move)this.getIR();
        }

        public int srcRegister(DexBuilder builder) {
            return builder.argumentOrAllocateRegister(this.getMove().src(), this.getMove().getNumber());
        }

        public int destRegister(DexBuilder builder) {
            return builder.allocatedRegister(this.getMove().dest(), this.getMove().getNumber());
        }

        @Override
        public boolean identicalInstructions(Info other, DexBuilder builder) {
            if (!(other instanceof MoveInfo)) {
                return false;
            }
            MoveInfo moveInfo = (MoveInfo)other;
            return this.srcRegister(builder) == moveInfo.srcRegister(builder) && this.destRegister(builder) == moveInfo.destRegister(builder);
        }

        @Override
        public int computeSize(DexBuilder builder) {
            int destRegister;
            int srcRegister = this.srcRegister(builder);
            this.size = srcRegister == (destRegister = this.destRegister(builder)) ? 1 : (srcRegister <= 15 && destRegister <= 15 ? 1 : (destRegister <= 255 ? 2 : 3));
            return this.size;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<shadow.bundletool.com.android.tools.r8.code.Instruction> instructions) {
            shadow.bundletool.com.android.tools.r8.code.Instruction instruction;
            Move move = this.getMove();
            TypeLatticeElement moveType = move.outValue().getTypeLattice();
            int src = this.srcRegister(builder);
            int dest = this.destRegister(builder);
            switch (this.size) {
                case 1: {
                    if (src == dest) {
                        instruction = new Nop();
                        break;
                    }
                    if (moveType.isSinglePrimitive()) {
                        instruction = new shadow.bundletool.com.android.tools.r8.code.Move(dest, src);
                        break;
                    }
                    if (moveType.isWidePrimitive()) {
                        instruction = new MoveWide(dest, src);
                        break;
                    }
                    if (moveType.isReference()) {
                        instruction = new MoveObject(dest, src);
                        break;
                    }
                    throw new Unreachable("Unexpected type: " + (Object)((Object)move.outType()));
                }
                case 2: {
                    if (moveType.isSinglePrimitive()) {
                        instruction = new MoveFrom16(dest, src);
                        break;
                    }
                    if (moveType.isWidePrimitive()) {
                        instruction = new MoveWideFrom16(dest, src);
                        break;
                    }
                    if (moveType.isReference()) {
                        instruction = new MoveObjectFrom16(dest, src);
                        break;
                    }
                    throw new Unreachable("Unexpected type: " + (Object)((Object)move.outType()));
                }
                case 3: {
                    if (moveType.isSinglePrimitive()) {
                        instruction = new Move16(dest, src);
                        break;
                    }
                    if (moveType.isWidePrimitive()) {
                        instruction = new MoveWide16(dest, src);
                        break;
                    }
                    if (moveType.isReference()) {
                        instruction = new MoveObject16(dest, src);
                        break;
                    }
                    throw new Unreachable("Unexpected type: " + (Object)((Object)move.outType()));
                }
                default: {
                    throw new Unreachable("Unexpected size: " + this.size);
                }
            }
            instruction.setOffset(this.getOffset());
            instructions.add(instruction);
        }

        @Override
        public int minSize() {
            assert (new Nop().getSize() == 1 && new shadow.bundletool.com.android.tools.r8.code.Move(0, 0).getSize() == 1);
            return 1;
        }

        @Override
        public int maxSize() {
            assert (new Move16(0, 0).getSize() == 3);
            return 3;
        }

        @Override
        public int getSize() {
            assert (this.size > 0);
            return this.size;
        }
    }

    public static class IfInfo
    extends Info {
        private int size = -1;

        public IfInfo(If branch) {
            super(branch);
        }

        private int getRegister(int operandIndex, DexBuilder builder) {
            If branch = this.getBranch();
            return builder.allocatedRegister(branch.inValues().get(operandIndex), branch.getNumber());
        }

        private int[] getRegisters(DexBuilder builder) {
            if (this.getBranch().isZeroTest()) {
                return new int[]{this.getRegister(0, builder)};
            }
            return new int[]{this.getRegister(0, builder), this.getRegister(1, builder)};
        }

        private If getBranch() {
            return (If)this.getIR();
        }

        private boolean branchesToSelf(DexBuilder builder) {
            Info trueTargetInfo;
            If branch = this.getBranch();
            return branch == (trueTargetInfo = builder.getTargetInfo(branch.getTrueTarget())).getIR();
        }

        private boolean offsetOutOfRange(DexBuilder builder) {
            Info targetInfo = builder.getTargetInfo(this.getBranch().getTrueTarget());
            int maxOffset = this.getMaxOffset();
            int maxTargetOffset = targetInfo.getMaxOffset();
            if (maxTargetOffset < maxOffset) {
                return this.getOffset() - targetInfo.getOffset() < Short.MIN_VALUE;
            }
            int maxOverEstimation = maxOffset - this.getOffset();
            return maxTargetOffset - maxOverEstimation - this.getOffset() > Short.MAX_VALUE;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<shadow.bundletool.com.android.tools.r8.code.Instruction> instructions) {
            If branch = this.getBranch();
            int source = builder.getInfo(branch).getOffset();
            int target = builder.getInfo(branch.getTrueTarget().entry()).getOffset();
            int relativeOffset = target - source;
            int register1 = this.getRegister(0, builder);
            if (relativeOffset < 0) {
                builder.hasBackwardsBranch = true;
            }
            if (this.size == 3) {
                assert (this.branchesToSelf(builder));
                Nop nop = new Nop();
                relativeOffset -= nop.getSize();
                instructions.add(nop);
            }
            assert (relativeOffset != 0);
            shadow.bundletool.com.android.tools.r8.code.Instruction instruction = null;
            if (branch.isZeroTest()) {
                switch (this.getBranch().getType()) {
                    case EQ: {
                        instruction = new IfEqz(register1, relativeOffset);
                        break;
                    }
                    case GE: {
                        instruction = new IfGez(register1, relativeOffset);
                        break;
                    }
                    case GT: {
                        instruction = new IfGtz(register1, relativeOffset);
                        break;
                    }
                    case LE: {
                        instruction = new IfLez(register1, relativeOffset);
                        break;
                    }
                    case LT: {
                        instruction = new IfLtz(register1, relativeOffset);
                        break;
                    }
                    case NE: {
                        instruction = new IfNez(register1, relativeOffset);
                    }
                }
            } else {
                int register2 = this.getRegister(1, builder);
                switch (this.getBranch().getType()) {
                    case EQ: {
                        instruction = new IfEq(register1, register2, relativeOffset);
                        break;
                    }
                    case GE: {
                        instruction = new IfGe(register1, register2, relativeOffset);
                        break;
                    }
                    case GT: {
                        instruction = new IfGt(register1, register2, relativeOffset);
                        break;
                    }
                    case LE: {
                        instruction = new IfLe(register1, register2, relativeOffset);
                        break;
                    }
                    case LT: {
                        instruction = new IfLt(register1, register2, relativeOffset);
                        break;
                    }
                    case NE: {
                        instruction = new IfNe(register1, register2, relativeOffset);
                    }
                }
            }
            instruction.setOffset(this.getOffset());
            instructions.add(instruction);
        }

        @Override
        public int computeSize(DexBuilder builder) {
            if (this.offsetOutOfRange(builder)) {
                builder.needsIfRewriting(this.getBranch().getBlock());
            }
            this.size = this.branchesToSelf(builder) ? 3 : 2;
            return this.size;
        }

        @Override
        public int minSize() {
            return 2;
        }

        @Override
        public int maxSize() {
            return 3;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public boolean identicalInstructions(Info other, DexBuilder builder) {
            if (!(other instanceof IfInfo)) {
                return false;
            }
            IfInfo otherInfo = (IfInfo)other;
            return this.getBranch().getType() == otherInfo.getBranch().getType() && Arrays.equals(this.getRegisters(builder), otherInfo.getRegisters(builder));
        }
    }

    private static class GotoInfo
    extends Info {
        private int size = -1;

        public GotoInfo(Goto jump) {
            super(jump);
        }

        private Goto getJump() {
            return (Goto)this.getIR();
        }

        @Override
        public int getSize() {
            assert (this.size > 0);
            return this.size;
        }

        @Override
        public int minSize() {
            assert (new shadow.bundletool.com.android.tools.r8.code.Goto(42).getSize() == 1);
            return 1;
        }

        @Override
        public int maxSize() {
            assert (new Goto32(0).getSize() == 3);
            return 3;
        }

        @Override
        public int computeSize(DexBuilder builder) {
            int delta;
            Info targetInfo;
            assert (this.size < 0);
            Goto jump = this.getJump();
            if (jump == (targetInfo = builder.getTargetInfo(jump.getTarget())).getIR()) {
                this.size = 2;
                return this.size;
            }
            int maxOffset = this.getMaxOffset();
            int maxTargetOffset = targetInfo.getMaxOffset();
            if (maxTargetOffset < maxOffset) {
                delta = this.getOffset() - targetInfo.getOffset();
            } else {
                int maxOverEstimation = maxOffset - this.getOffset();
                delta = maxTargetOffset - maxOverEstimation - this.getOffset();
            }
            this.size = delta <= 127 ? 1 : (delta <= Short.MAX_VALUE ? 2 : 3);
            if (targetInfo.getIR().isReturn() && targetInfo.getIR().getPosition().isNone()) {
                assert (!(targetInfo instanceof FallThroughInfo));
                this.size = Math.min(targetInfo.getSize(), this.size);
            }
            assert (this.size != 0);
            return this.size;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<shadow.bundletool.com.android.tools.r8.code.Instruction> instructions) {
            Return ret;
            Goto jump = this.getJump();
            int source = builder.getInfo(jump).getOffset();
            Info targetInfo = builder.getTargetInfo(jump.getTarget());
            int relativeOffset = targetInfo.getOffset() - source;
            if (relativeOffset < 0) {
                builder.hasBackwardsBranch = true;
            }
            if ((ret = targetInfo.getIR().asReturn()) != null && this.size == targetInfo.getSize() && ret.getPosition().isNone()) {
                shadow.bundletool.com.android.tools.r8.code.Instruction dex = ret.createDexInstruction(builder);
                dex.setOffset(this.getOffset());
                instructions.add(dex);
            } else if (this.size == relativeOffset) {
                for (int i = 0; i < this.size; ++i) {
                    Nop dex = new Nop();
                    assert (((shadow.bundletool.com.android.tools.r8.code.Instruction)dex).getSize() == 1);
                    dex.setOffset(this.getOffset() + i);
                    instructions.add(dex);
                }
            } else {
                shadow.bundletool.com.android.tools.r8.code.Instruction dex;
                switch (this.size) {
                    case 1: {
                        assert (relativeOffset != 0);
                        dex = new shadow.bundletool.com.android.tools.r8.code.Goto(relativeOffset);
                        break;
                    }
                    case 2: {
                        if (relativeOffset == 0) {
                            Nop nop = new Nop();
                            instructions.add(nop);
                            dex = new shadow.bundletool.com.android.tools.r8.code.Goto(-nop.getSize());
                            break;
                        }
                        dex = new Goto16(relativeOffset);
                        break;
                    }
                    case 3: {
                        dex = new Goto32(relativeOffset);
                        break;
                    }
                    default: {
                        throw new Unreachable("Unexpected size for goto instruction: " + this.size);
                    }
                }
                dex.setOffset(this.getOffset());
                instructions.add(dex);
            }
        }

        @Override
        public boolean identicalInstructions(Info other, DexBuilder builder) {
            return other instanceof GotoInfo;
        }
    }

    private static class FallThroughInfo
    extends Info {
        public FallThroughInfo(Instruction ir) {
            super(ir);
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public int computeSize(DexBuilder builder) {
            return 0;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<shadow.bundletool.com.android.tools.r8.code.Instruction> instructions) {
        }

        @Override
        public int minSize() {
            return 0;
        }

        @Override
        public int maxSize() {
            return 0;
        }

        @Override
        public boolean identicalInstructions(Info other, DexBuilder builder) {
            return other instanceof FallThroughInfo;
        }
    }

    private static class MultiFixedSizeInfo
    extends Info {
        private final shadow.bundletool.com.android.tools.r8.code.Instruction[] instructions;
        private final int size;

        public MultiFixedSizeInfo(Instruction ir, shadow.bundletool.com.android.tools.r8.code.Instruction[] instructions) {
            super(ir);
            this.instructions = instructions;
            int size = 0;
            for (shadow.bundletool.com.android.tools.r8.code.Instruction instruction : instructions) {
                size += instruction.getSize();
            }
            this.size = size;
        }

        @Override
        public int computeSize(DexBuilder builder) {
            return this.size;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<shadow.bundletool.com.android.tools.r8.code.Instruction> instructions) {
            int offset = this.getOffset();
            for (shadow.bundletool.com.android.tools.r8.code.Instruction instruction : this.instructions) {
                instructions.add(instruction);
                instruction.setOffset(offset);
                offset += instruction.getSize();
            }
        }

        @Override
        public int minSize() {
            return this.size;
        }

        @Override
        public int maxSize() {
            return this.size;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public boolean identicalInstructions(Info other, DexBuilder builder) {
            return other instanceof MultiFixedSizeInfo && Arrays.equals(this.instructions, ((MultiFixedSizeInfo)other).instructions);
        }
    }

    private static class FixedSizeInfo
    extends Info {
        private final shadow.bundletool.com.android.tools.r8.code.Instruction instruction;

        public FixedSizeInfo(Instruction ir, shadow.bundletool.com.android.tools.r8.code.Instruction instruction) {
            super(ir);
            this.instruction = instruction;
        }

        @Override
        public int getSize() {
            return this.instruction.getSize();
        }

        @Override
        public int minSize() {
            return this.instruction.getSize();
        }

        @Override
        public int maxSize() {
            return this.instruction.getSize();
        }

        @Override
        public int computeSize(DexBuilder builder) {
            this.instruction.setOffset(this.getOffset());
            return this.instruction.getSize();
        }

        @Override
        public void addInstructions(DexBuilder builder, List<shadow.bundletool.com.android.tools.r8.code.Instruction> instructions) {
            instructions.add(this.instruction);
        }

        @Override
        public boolean identicalInstructions(Info other, DexBuilder builder) {
            return other instanceof FixedSizeInfo && this.instruction.equals(((FixedSizeInfo)other).instruction);
        }
    }

    private static abstract class Info {
        private final Instruction ir;
        private int offset = -1;
        private int minOffset = -1;
        private int maxOffset = -1;

        public Info(Instruction ir) {
            assert (ir != null);
            this.ir = ir;
        }

        public abstract int computeSize(DexBuilder var1);

        public abstract void addInstructions(DexBuilder var1, List<shadow.bundletool.com.android.tools.r8.code.Instruction> var2);

        public abstract int minSize();

        public abstract int maxSize();

        public abstract int getSize();

        public int getOffset() {
            assert (this.offset >= 0) : this;
            return this.offset;
        }

        public void setOffset(int offset) {
            assert (offset >= 0);
            this.offset = offset;
        }

        public int getMinOffset() {
            assert (this.minOffset >= 0);
            return this.minOffset;
        }

        public void setMinOffset(int minOffset) {
            assert (minOffset >= 0);
            this.minOffset = minOffset;
        }

        public int getMaxOffset() {
            assert (this.maxOffset >= 0);
            return this.maxOffset;
        }

        public void setMaxOffset(int maxOffset) {
            assert (maxOffset >= 0);
            this.maxOffset = maxOffset;
        }

        public Instruction getIR() {
            return this.ir;
        }

        public abstract boolean identicalInstructions(Info var1, DexBuilder var2);
    }
}

