/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.Goto;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.IntSwitch;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.JumpInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.StringSwitch;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;

class StringSwitchConverter {
    StringSwitchConverter() {
    }

    static void convertToStringSwitchInstructions(IRCode code, DexItemFactory dexItemFactory) {
        List<BasicBlock> rewritingCandidates = StringSwitchConverter.getRewritingCandidates(code, dexItemFactory);
        if (rewritingCandidates != null) {
            boolean changed = false;
            for (BasicBlock block : rewritingCandidates) {
                if (!StringSwitchConverter.convertRewritingCandidateToStringSwitchInstruction(code, block, dexItemFactory)) continue;
                changed = true;
            }
            if (changed) {
                code.removeAllTrivialPhis();
                code.removeUnreachableBlocks();
            }
        }
    }

    private static List<BasicBlock> getRewritingCandidates(IRCode code, DexItemFactory dexItemFactory) {
        int markingColor = code.reserveMarkingColor();
        ArrayList<BasicBlock> rewritingCandidates = null;
        for (BasicBlock block : code.blocks) {
            if (block.isMarked(markingColor)) continue;
            block.mark(markingColor);
            if (!Utils.isComparisonOfStringHashValue(block.exit(), dexItemFactory)) continue;
            BasicBlock end = block;
            while (true) {
                BasicBlock fallthroughBlock;
                if ((fallthroughBlock = Utils.fallthroughBlock(end.exit())).isMarked(markingColor)) {
                    end = null;
                    break;
                }
                fallthroughBlock.mark(markingColor);
                if (!Utils.isComparisonOfStringHashValue(fallthroughBlock.exit(), dexItemFactory)) break;
                end = fallthroughBlock;
            }
            if (end == null) continue;
            if (rewritingCandidates == null) {
                rewritingCandidates = new ArrayList<BasicBlock>();
            }
            rewritingCandidates.add(end);
        }
        code.returnMarkingColor(markingColor);
        return rewritingCandidates;
    }

    private static boolean convertRewritingCandidateToStringSwitchInstruction(IRCode code, BasicBlock block, DexItemFactory dexItemFactory) {
        StringSwitchBuilderInfo info = StringSwitchBuilderInfo.builder(dexItemFactory).build(block);
        if (info != null) {
            info.createAndInsertStringSwitch(code);
            return true;
        }
        return false;
    }

    private static boolean isDefinedByStringHashCode(Value value, DexItemFactory dexItemFactory) {
        Value root = value.getAliasedValue();
        if (root.isPhi()) {
            return false;
        }
        Instruction definition = root.definition;
        return definition.isInvokeVirtual() && definition.asInvokeVirtual().getInvokedMethod() == dexItemFactory.stringMethods.hashCode;
    }

    static class Utils {
        Utils() {
        }

        static BasicBlock getTrueTarget(If theIf) {
            assert (theIf.getType() == If.Type.EQ || theIf.getType() == If.Type.NE);
            return theIf.getType() == If.Type.EQ ? theIf.getTrueTarget() : theIf.fallthroughBlock();
        }

        static BasicBlock fallthroughBlock(JumpInstruction exit) {
            if (exit.isIf()) {
                If theIf = exit.asIf();
                return theIf.getType() == If.Type.EQ ? theIf.fallthroughBlock() : theIf.getTrueTarget();
            }
            if (exit.isIntSwitch()) {
                return exit.asIntSwitch().fallthroughBlock();
            }
            throw new Unreachable();
        }

        static Value getStringHashValueFromJump(JumpInstruction instruction, DexItemFactory dexItemFactory) {
            if (instruction.isIf()) {
                return Utils.getStringHashValueFromIf(instruction.asIf(), dexItemFactory);
            }
            if (instruction.isIntSwitch()) {
                return Utils.getStringHashValueFromSwitch(instruction.asIntSwitch(), dexItemFactory);
            }
            return null;
        }

        static Value getStringHashValueFromIf(If theIf, DexItemFactory dexItemFactory) {
            Value rhs;
            Value lhs = theIf.lhs();
            if (StringSwitchConverter.isDefinedByStringHashCode(lhs, dexItemFactory)) {
                return lhs;
            }
            if (!theIf.isZeroTest() && StringSwitchConverter.isDefinedByStringHashCode(rhs = theIf.rhs(), dexItemFactory)) {
                return rhs;
            }
            return null;
        }

        static Value getStringHashValueFromSwitch(IntSwitch theSwitch, DexItemFactory dexItemFactory) {
            Value switchValue = theSwitch.value();
            if (StringSwitchConverter.isDefinedByStringHashCode(switchValue, dexItemFactory)) {
                return switchValue;
            }
            return null;
        }

        static Value getStringValueFromHashValue(Value stringHashValue, DexItemFactory dexItemFactory) {
            assert (StringSwitchConverter.isDefinedByStringHashCode(stringHashValue, dexItemFactory));
            return stringHashValue.definition.asInvokeVirtual().getReceiver();
        }

        static boolean isComparisonOfStringHashValue(JumpInstruction instruction, DexItemFactory dexItemFactory) {
            return Utils.getStringHashValueFromJump(instruction, dexItemFactory) != null;
        }

        static boolean isSameStringHashValue(Value value, Value other) {
            return value == other || value.definition.asInvokeVirtual().getReceiver() == other.definition.asInvokeVirtual().getReceiver();
        }
    }

    static class IdToTargetMapping {
        private BasicBlock fallthroughBlock;
        private final Phi idValue;
        private final Int2ReferenceMap<BasicBlock> mapping = new Int2ReferenceOpenHashMap<BasicBlock>();

        private IdToTargetMapping(Phi idValue) {
            this.idValue = idValue;
        }

        static Builder builder() {
            return new Builder();
        }

        static class Builder {
            Builder() {
            }

            IdToTargetMapping build(BasicBlock block) {
                return this.extend(null, block);
            }

            private static IdToTargetMapping setFallthroughBlock(IdToTargetMapping toBeExtended, BasicBlock fallthroughBlock) {
                if (toBeExtended != null) {
                    toBeExtended.fallthroughBlock = fallthroughBlock;
                }
                return toBeExtended;
            }

            private IdToTargetMapping extend(IdToTargetMapping toBeExtended, BasicBlock block) {
                BasicBlock end = block.endOfGotoChain();
                if (end == null) {
                    return Builder.setFallthroughBlock(toBeExtended, block);
                }
                int numberOfInstructions = end.getInstructions().size();
                if (numberOfInstructions == 1) {
                    JumpInstruction exit = end.exit();
                    if (exit.isIf()) {
                        return this.extendWithIf(toBeExtended, exit.asIf());
                    }
                    if (exit.isIntSwitch()) {
                        return this.extendWithSwitch(toBeExtended, exit.asIntSwitch());
                    }
                }
                if (numberOfInstructions == 2) {
                    Instruction entry = end.entry();
                    JumpInstruction exit = end.exit();
                    if (entry.isConstNumber() && entry.outValue().onlyUsedInBlock(end) && exit.isIf()) {
                        return this.extendWithIf(toBeExtended, exit.asIf());
                    }
                }
                return Builder.setFallthroughBlock(toBeExtended, block);
            }

            private IdToTargetMapping extendWithIf(IdToTargetMapping toBeExtended, If theIf) {
                int id;
                Value rhs;
                If.Type type = theIf.getType();
                if (type != If.Type.EQ && type != If.Type.NE) {
                    return Builder.setFallthroughBlock(toBeExtended, theIf.getBlock());
                }
                Phi idValue = null;
                Value lhs = theIf.lhs();
                if (lhs.isPhi()) {
                    idValue = lhs.asPhi();
                } else if (!theIf.isZeroTest() && (rhs = theIf.rhs()).isPhi()) {
                    idValue = rhs.asPhi();
                }
                if (idValue == null || toBeExtended != null && idValue != toBeExtended.idValue) {
                    return Builder.setFallthroughBlock(toBeExtended, theIf.getBlock());
                }
                if (theIf.isZeroTest()) {
                    id = 0;
                } else {
                    Value other = idValue == theIf.lhs() ? theIf.rhs() : theIf.lhs();
                    Value root = other.getAliasedValue();
                    if (root.isPhi() || !root.definition.isConstNumber()) {
                        return Builder.setFallthroughBlock(toBeExtended, theIf.getBlock());
                    }
                    ConstNumber constNumberInstruction = root.definition.asConstNumber();
                    id = constNumberInstruction.getIntValue();
                }
                if (toBeExtended == null) {
                    toBeExtended = new IdToTargetMapping(idValue);
                }
                toBeExtended.mapping.putIfAbsent(id, Utils.getTrueTarget(theIf));
                return this.extend(toBeExtended, Utils.fallthroughBlock(theIf));
            }

            private IdToTargetMapping extendWithSwitch(IdToTargetMapping toBeExtended, IntSwitch theSwitch) {
                Value switchValue = theSwitch.value();
                if (!switchValue.isPhi() || toBeExtended != null && switchValue != toBeExtended.idValue) {
                    return Builder.setFallthroughBlock(toBeExtended, theSwitch.getBlock());
                }
                Phi idValue = switchValue.asPhi();
                if (toBeExtended == null) {
                    toBeExtended = new IdToTargetMapping(idValue);
                }
                theSwitch.forEachCase(toBeExtended.mapping::putIfAbsent);
                return this.extend(toBeExtended, theSwitch.fallthroughBlock());
            }
        }
    }

    static class StringToIdMapping {
        BasicBlock insertionBlock;
        private final Value stringHashValue;
        private final Reference2IntMap<DexString> mapping = new Reference2IntOpenHashMap<DexString>();

        private StringToIdMapping(Value stringHashValue, DexItemFactory dexItemFactory) {
            assert (StringSwitchConverter.isDefinedByStringHashCode(stringHashValue, dexItemFactory));
            this.stringHashValue = stringHashValue;
        }

        static Builder builder(BasicBlock continuationBlock, DexItemFactory dexItemFactory, Phi idValue, Value stringValue) {
            return new Builder(continuationBlock, dexItemFactory, idValue, stringValue);
        }

        static class Builder {
            private final BasicBlock continuationBlock;
            private final DexItemFactory dexItemFactory;
            private final Phi idValue;
            private final Value stringValue;

            Builder(BasicBlock continuationBlock, DexItemFactory dexItemFactory, Phi idValue, Value stringValue) {
                this.continuationBlock = continuationBlock;
                this.dexItemFactory = dexItemFactory;
                this.idValue = idValue;
                this.stringValue = stringValue;
            }

            StringToIdMapping build(BasicBlock block) {
                return this.extend(null, block);
            }

            private StringToIdMapping extend(StringToIdMapping toBeExtended, BasicBlock block) {
                JumpInstruction exit = block.exit();
                if (exit.isIf()) {
                    return this.extendWithIf(toBeExtended, exit.asIf());
                }
                if (exit.isIntSwitch()) {
                    return this.extendWithSwitch(toBeExtended, exit.asIntSwitch());
                }
                return toBeExtended;
            }

            private StringToIdMapping extendWithPredecessor(StringToIdMapping toBeExtended, BasicBlock block) {
                boolean mayExtendWithPredecessor = true;
                for (Instruction instruction : block.getInstructions()) {
                    InvokeVirtual invoke;
                    if (instruction.isConstNumber() && instruction.outValue().onlyUsedInBlock(block) || instruction.isInvokeVirtual() && (invoke = instruction.asInvokeVirtual()).getInvokedMethod() == this.dexItemFactory.stringMethods.hashCode && invoke.getReceiver() == this.stringValue && invoke.outValue().onlyUsedInBlock(block) || instruction.isJumpInstruction()) continue;
                    mayExtendWithPredecessor = false;
                    break;
                }
                if (!mayExtendWithPredecessor) {
                    return toBeExtended;
                }
                if (!block.hasUniquePredecessor()) {
                    return toBeExtended;
                }
                BasicBlock predecessor = block.getUniquePredecessor().startOfGotoChain();
                return this.extend(toBeExtended, predecessor);
            }

            private StringToIdMapping extendWithIf(StringToIdMapping toBeExtended, If theIf) {
                int hash;
                if (theIf.getType() != If.Type.EQ && theIf.getType() != If.Type.NE) {
                    return toBeExtended;
                }
                Value stringHashValue = Utils.getStringHashValueFromIf(theIf, this.dexItemFactory);
                if (stringHashValue == null || toBeExtended != null && !Utils.isSameStringHashValue(stringHashValue, toBeExtended.stringHashValue)) {
                    return toBeExtended;
                }
                if (theIf.isZeroTest()) {
                    hash = 0;
                } else {
                    Value other = stringHashValue == theIf.lhs() ? theIf.rhs() : theIf.lhs();
                    Value root = other.getAliasedValue();
                    if (root.isPhi() || !root.definition.isConstNumber()) {
                        return toBeExtended;
                    }
                    ConstNumber constNumberInstruction = root.definition.asConstNumber();
                    hash = constNumberInstruction.getIntValue();
                }
                Reference2IntOpenHashMap<DexString> extension = new Reference2IntOpenHashMap<DexString>();
                BasicBlock ifEqualsHashTarget = Utils.getTrueTarget(theIf);
                if (!this.addMappingsForStringsWithHash(ifEqualsHashTarget, hash, extension)) {
                    return toBeExtended;
                }
                if (toBeExtended == null) {
                    toBeExtended = new StringToIdMapping(stringHashValue, this.dexItemFactory);
                }
                for (DexString key : extension.keySet()) {
                    toBeExtended.mapping.put(key, extension.getInt(key));
                }
                toBeExtended.insertionBlock = theIf.getBlock();
                return this.extendWithPredecessor(toBeExtended, theIf.getBlock());
            }

            private StringToIdMapping extendWithSwitch(StringToIdMapping toBeExtended, IntSwitch theSwitch) {
                Value stringHashValue = Utils.getStringHashValueFromSwitch(theSwitch, this.dexItemFactory);
                if (stringHashValue == null || toBeExtended != null && !Utils.isSameStringHashValue(stringHashValue, toBeExtended.stringHashValue)) {
                    return toBeExtended;
                }
                Reference2IntOpenHashMap<DexString> extension = new Reference2IntOpenHashMap<DexString>();
                for (int i = 0; i < theSwitch.numberOfKeys(); ++i) {
                    int hash = theSwitch.getKey(i);
                    BasicBlock equalsHashTarget = theSwitch.targetBlock(i);
                    if (this.addMappingsForStringsWithHash(equalsHashTarget, hash, extension)) continue;
                    return toBeExtended;
                }
                if (toBeExtended == null) {
                    toBeExtended = new StringToIdMapping(stringHashValue, this.dexItemFactory);
                }
                for (DexString key : extension.keySet()) {
                    toBeExtended.mapping.put(key, extension.getInt(key));
                }
                toBeExtended.insertionBlock = theSwitch.getBlock();
                return this.extendWithPredecessor(toBeExtended, theSwitch.getBlock());
            }

            private boolean addMappingsForStringsWithHash(BasicBlock block, int hash, Reference2IntMap<DexString> extension) {
                return this.addMappingsForStringsWithHash(block, hash, extension, Sets.newIdentityHashSet());
            }

            private boolean addMappingsForStringsWithHash(BasicBlock block, int hash, Reference2IntMap<DexString> extension, Set<BasicBlock> visited) {
                InstructionIterator instructionIterator = block.iterator();
                ConstString theString = ((Instruction)instructionIterator.next()).asConstString();
                if (theString == null || theString.instructionInstanceCanThrow()) {
                    return false;
                }
                InvokeVirtual theInvoke = ((Instruction)instructionIterator.next()).asInvokeVirtual();
                if (theInvoke == null || theInvoke.getInvokedMethod() != this.dexItemFactory.stringMethods.equals || theInvoke.getReceiver() != this.stringValue || theInvoke.inValues().get(1) != theString.outValue()) {
                    return false;
                }
                If theIf = ((Instruction)instructionIterator.next()).asIf();
                if (theIf == null) {
                    return false;
                }
                if (theIf.getType() != If.Type.EQ && theIf.getType() != If.Type.NE) {
                    return false;
                }
                try {
                    BasicBlock trueTarget;
                    if (theString.getValue().decodedHashCode() == hash && !this.addMappingForString(trueTarget = theIf.targetFromCondition(1).endOfGotoChain(), theString.getValue(), extension)) {
                        return false;
                    }
                }
                catch (UTFDataFormatException e) {
                    throw new Unreachable();
                }
                BasicBlock fallthroughBlock = theIf.targetFromCondition(0).endOfGotoChain();
                if (fallthroughBlock == this.continuationBlock) {
                    return true;
                }
                if (visited.add(fallthroughBlock)) {
                    return this.addMappingsForStringsWithHash(fallthroughBlock, hash, extension, visited);
                }
                return false;
            }

            private boolean addMappingForString(BasicBlock block, DexString string, Reference2IntMap<DexString> extension) {
                InstructionIterator instructionIterator = block.iterator();
                ConstNumber constNumberInstruction = ((Instruction)instructionIterator.next()).asConstNumber();
                if (constNumberInstruction == null || !this.idValue.getOperands().contains(constNumberInstruction.outValue())) {
                    return false;
                }
                Goto gotoContinuationBlock = ((Instruction)instructionIterator.next()).asGoto();
                if (gotoContinuationBlock == null || gotoContinuationBlock.getTarget().endOfGotoChain() != this.continuationBlock) {
                    return false;
                }
                extension.putIfAbsent(string, constNumberInstruction.getIntValue());
                return true;
            }
        }
    }

    static class StringSwitchBuilderInfo {
        private final BasicBlock fallthroughBlock;
        private final BasicBlock insertionBlock;
        private final Map<DexString, BasicBlock> mapping;
        private final Value value;

        StringSwitchBuilderInfo(BasicBlock fallthroughBlock, BasicBlock insertionBlock, Map<DexString, BasicBlock> mapping, Value value) {
            this.fallthroughBlock = fallthroughBlock;
            this.insertionBlock = insertionBlock;
            this.mapping = mapping;
            this.value = value;
        }

        static Builder builder(DexItemFactory dexItemFactory) {
            return new Builder(dexItemFactory);
        }

        void createAndInsertStringSwitch(IRCode code) {
            for (BasicBlock successor : this.insertionBlock.getNormalSuccessors()) {
                successor.removePredecessor(this.insertionBlock, null);
            }
            this.insertionBlock.removeAllNormalSuccessors();
            DexString[] keys2 = new DexString[this.mapping.size()];
            int[] targetBlockIndices = new int[this.mapping.size()];
            Reference2IntOpenHashMap<BasicBlock> emittedTargetBlockIndices = new Reference2IntOpenHashMap<BasicBlock>();
            int i = 0;
            int nextTargetBlockIndex = this.insertionBlock.numberOfCatchHandlers();
            for (Map.Entry<DexString, BasicBlock> entry : this.mapping.entrySet()) {
                keys2[i] = entry.getKey();
                BasicBlock targetBlock = entry.getValue();
                if (emittedTargetBlockIndices.containsKey(targetBlock)) {
                    targetBlockIndices[i] = emittedTargetBlockIndices.getInt(targetBlock);
                } else {
                    int targetBlockIndex;
                    targetBlockIndices[i] = targetBlockIndex = nextTargetBlockIndex++;
                    emittedTargetBlockIndices.put(targetBlock, targetBlockIndex);
                    this.insertionBlock.link(targetBlock);
                }
                ++i;
            }
            this.insertionBlock.link(this.fallthroughBlock);
            JumpInstruction exit = this.insertionBlock.exit();
            int fallthroughBlockIndex = nextTargetBlockIndex;
            exit.replace(new StringSwitch(this.value, keys2, targetBlockIndices, fallthroughBlockIndex), code);
        }

        static class Builder {
            private final DexItemFactory dexItemFactory;

            private Builder(DexItemFactory dexItemFactory) {
                this.dexItemFactory = dexItemFactory;
            }

            StringSwitchBuilderInfo build(BasicBlock block) {
                BasicBlock continuationBlock = Utils.fallthroughBlock(block.exit()).endOfGotoChain();
                IdToTargetMapping idToTargetMapping = IdToTargetMapping.builder().build(continuationBlock);
                if (idToTargetMapping == null) {
                    return null;
                }
                if (idToTargetMapping.fallthroughBlock == null) {
                    assert (false) : "Expected to find a fallthrough block";
                    return null;
                }
                Value stringHashValue = Utils.getStringHashValueFromJump(block.exit(), this.dexItemFactory);
                Value stringValue = Utils.getStringValueFromHashValue(stringHashValue, this.dexItemFactory);
                StringToIdMapping stringToIdMapping = StringToIdMapping.builder(continuationBlock, this.dexItemFactory, idToTargetMapping.idValue, stringValue).build(block);
                if (stringToIdMapping == null) {
                    return null;
                }
                if (stringToIdMapping.insertionBlock == null) {
                    assert (false) : "Expected to find an insertion block";
                    return null;
                }
                if (stringToIdMapping.mapping.size() != idToTargetMapping.mapping.size()) {
                    return null;
                }
                IdentityHashMap<DexString, BasicBlock> stringToTargetMapping = new IdentityHashMap<DexString, BasicBlock>();
                for (DexString key : stringToIdMapping.mapping.keySet()) {
                    int id = stringToIdMapping.mapping.getInt(key);
                    BasicBlock target = (BasicBlock)idToTargetMapping.mapping.get(id);
                    if (target == null) {
                        return null;
                    }
                    stringToTargetMapping.put(key, target);
                }
                return new StringSwitchBuilderInfo(idToTargetMapping.fallthroughBlock, stringToIdMapping.insertionBlock, stringToTargetMapping, stringValue);
            }
        }
    }
}

