/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.ExceptionThrowingSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.SynthesizedCode;
import shadow.bundletool.com.android.tools.r8.utils.MethodSignatureEquivalence;

final class ClassProcessor {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final InterfaceMethodRewriter rewriter;
    private final Consumer<DexEncodedMethod> newSynthesizedMethodConsumer;
    private final MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
    private final boolean needsLibraryInfo;
    private final Map<DexClass, ClassInfo> classInfo = new IdentityHashMap<DexClass, ClassInfo>();
    private final Map<DexLibraryClass, MethodSignatures> libraryClassInfo = new IdentityHashMap<DexLibraryClass, MethodSignatures>();
    private final Map<DexClass, MethodSignatures> interfaceInfo = new IdentityHashMap<DexClass, MethodSignatures>();
    private final Map<DexProgramClass, List<DexEncodedMethod>> newSyntheticMethods = new IdentityHashMap<DexProgramClass, List<DexEncodedMethod>>();

    ClassProcessor(AppView<?> appView, InterfaceMethodRewriter rewriter, Consumer<DexEncodedMethod> newSynthesizedMethodConsumer) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.rewriter = rewriter;
        this.newSynthesizedMethodConsumer = newSynthesizedMethodConsumer;
        this.needsLibraryInfo = !appView.options().desugaredLibraryConfiguration.getEmulateLibraryInterface().isEmpty() || !appView.options().desugaredLibraryConfiguration.getRetargetCoreLibMember().isEmpty();
    }

    private boolean needsLibraryInfo() {
        return this.needsLibraryInfo;
    }

    private boolean ignoreLibraryInfo() {
        return !this.needsLibraryInfo;
    }

    public void processClass(DexProgramClass clazz) {
        this.visitClassInfo(clazz, new ReportingContext(clazz, clazz));
    }

    final void addSyntheticMethods() {
        for (DexProgramClass clazz : this.newSyntheticMethods.keySet()) {
            List<DexEncodedMethod> newForwardingMethods = this.newSyntheticMethods.get(clazz);
            if (newForwardingMethods == null) continue;
            clazz.appendVirtualMethods(newForwardingMethods);
            newForwardingMethods.forEach(this.newSynthesizedMethodConsumer);
        }
    }

    private MethodSignatures computeInterfaceInfo(DexClass iface, MethodSignatures signatures) {
        assert (iface.isInterface());
        assert (iface.superType == this.dexItemFactory.objectType);
        if (!iface.isLibraryClass() || this.needsLibraryInfo() && this.rewriter.isInDesugaredLibrary(iface)) {
            List<DexEncodedMethod> methods = iface.virtualMethods();
            ArrayList<Equivalence.Wrapper<DexMethod>> additions = new ArrayList<Equivalence.Wrapper<DexMethod>>(methods.size());
            for (DexEncodedMethod method : methods) {
                if (!method.isDefaultMethod()) continue;
                additions.add(this.equivalence.wrap(method.method));
            }
            if (!additions.isEmpty()) {
                signatures = signatures.merge(MethodSignatures.create(new HashSet<Equivalence.Wrapper<DexMethod>>(additions)));
            }
        }
        return signatures;
    }

    private MethodSignatures computeLibraryClassInfo(DexLibraryClass clazz, MethodSignatures signatures) {
        return signatures;
    }

    private ClassInfo computeClassInfo(DexClass clazz, ClassInfo superInfo, MethodSignatures signatures) {
        ImmutableList.Builder additionalForwards = ImmutableList.builder();
        for (Equivalence.Wrapper<DexMethod> wrapper : signatures.signatures) {
            this.resolveForwardForSignature(clazz, wrapper.get(), (targetHolder, target) -> {
                if (!superInfo.isTargetedByForwards((DexEncodedMethod)target)) {
                    additionalForwards.add(target);
                    this.addForwardingMethod((DexClass)targetHolder, (DexEncodedMethod)target, clazz);
                }
            });
        }
        return ClassInfo.create(superInfo, (ImmutableList<DexEncodedMethod>)additionalForwards.build());
    }

    private void resolveForwardForSignature(DexClass clazz, DexMethod method, BiConsumer<DexClass, DexEncodedMethod> addForward) {
        ResolutionResult resolution = ((AppInfo)this.appView.appInfo()).resolveMethod(clazz, method);
        if (resolution.isFailedResolution()) {
            if (resolution instanceof ResolutionResult.IncompatibleClassResult) {
                this.addICCEThrowingMethod(method, clazz);
            }
            return;
        }
        DexEncodedMethod target = resolution.getSingleTarget();
        DexClass targetHolder = this.appView.definitionFor(target.method.holder);
        if (targetHolder == null || this.dontRewrite(targetHolder, target)) {
            return;
        }
        if (targetHolder.isInterface() && target.isDefaultMethod()) {
            addForward.accept(targetHolder, target);
            return;
        }
        DexLibraryClass libraryHolder = targetHolder.asLibraryClass();
        if (libraryHolder == null || this.ignoreLibraryInfo()) {
            return;
        }
        if (this.isRetargetMethod(libraryHolder, target)) {
            addForward.accept(targetHolder, target);
            return;
        }
        if (!libraryHolder.isInterface() && (target = ((AppInfo)this.appView.appInfo()).resolveMaximallySpecificMethods(libraryHolder, method).getSingleTarget()) != null && this.rewriter.isEmulatedInterface(target.method.holder)) {
            targetHolder = this.appView.definitionFor(target.method.holder);
            addForward.accept(targetHolder, target);
        }
    }

    private boolean isRetargetMethod(DexLibraryClass holder, DexEncodedMethod method) {
        assert (this.needsLibraryInfo());
        assert (holder.type == method.method.holder);
        assert (method.isNonPrivateVirtualMethod());
        if (method.isFinal()) {
            return false;
        }
        return this.appView.options().desugaredLibraryConfiguration.retargetMethod(method.method, this.appView) != null;
    }

    private boolean dontRewrite(DexClass clazz, DexEncodedMethod method) {
        return this.needsLibraryInfo() && clazz.isLibraryClass() && this.rewriter.dontRewrite(method.method);
    }

    private void addSyntheticMethod(DexProgramClass clazz, DexEncodedMethod newMethod) {
        this.newSyntheticMethods.computeIfAbsent(clazz, key -> new ArrayList()).add(newMethod);
    }

    private void addICCEThrowingMethod(DexMethod method, DexClass clazz) {
        if (!clazz.isProgramClass()) {
            return;
        }
        DexMethod newMethod = this.dexItemFactory.createMethod(clazz.type, method.proto, method.name);
        DexEncodedMethod newEncodedMethod = new DexEncodedMethod(newMethod, MethodAccessFlags.fromCfAccessFlags(1, false), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)new SynthesizedCode(callerPosition -> new ExceptionThrowingSourceCode(clazz.type, method, callerPosition, this.dexItemFactory.icceType)), true);
        this.addSyntheticMethod(clazz.asProgramClass(), newEncodedMethod);
    }

    private void addForwardingMethod(DexClass targetHolder, DexEncodedMethod target, DexClass clazz) {
        assert (targetHolder != null);
        if (!clazz.isProgramClass()) {
            return;
        }
        DexMethod method = target.method;
        DexMethod forwardMethod = targetHolder.isInterface() ? this.rewriter.defaultAsMethodOfCompanionClass(method) : this.appView.options().desugaredLibraryConfiguration.retargetMethod(method, this.appView);
        DexEncodedMethod desugaringForwardingMethod = DexEncodedMethod.createDesugaringForwardingMethod(target, clazz, forwardMethod, this.dexItemFactory);
        this.addSyntheticMethod(clazz.asProgramClass(), desugaringForwardingMethod);
    }

    private DexClass definitionOrNull(DexType type, ReportingContext context) {
        if (type == null || type == this.dexItemFactory.objectType) {
            return null;
        }
        DexClass clazz = context.definitionFor(type, this.appView);
        if (clazz == null) {
            context.reportMissingType(type, this.rewriter);
            return null;
        }
        return clazz;
    }

    private ClassInfo visitClassInfo(DexType type, ReportingContext context) {
        DexClass clazz = this.definitionOrNull(type, context);
        return clazz == null ? ClassInfo.EMPTY : this.visitClassInfo(clazz, context);
    }

    private ClassInfo visitClassInfo(DexClass clazz, ReportingContext context) {
        assert (!clazz.isInterface());
        if (clazz.isLibraryClass()) {
            return ClassInfo.EMPTY;
        }
        return this.classInfo.computeIfAbsent(clazz, key -> this.visitClassInfoRaw((DexClass)key, context));
    }

    private ClassInfo visitClassInfoRaw(DexClass clazz, ReportingContext context) {
        ReportingContext thisContext = context.forClass(clazz);
        ClassInfo superInfo = this.visitClassInfo(clazz.superType, thisContext);
        MethodSignatures signatures = this.visitLibraryClassInfo(clazz.superType);
        assert (superInfo.isEmpty() || signatures.isEmpty());
        for (DexType iface : clazz.interfaces.values) {
            signatures = signatures.merge(this.visitInterfaceInfo(iface, thisContext));
        }
        return this.computeClassInfo(clazz, superInfo, signatures);
    }

    private MethodSignatures visitLibraryClassInfo(DexType type) {
        if (this.ignoreLibraryInfo()) {
            return MethodSignatures.EMPTY;
        }
        DexClass clazz = this.definitionOrNull(type, LibraryReportingContext.LIBRARY_CONTEXT);
        return clazz == null ? MethodSignatures.EMPTY : this.visitLibraryClassInfo(clazz);
    }

    private MethodSignatures visitLibraryClassInfo(DexClass clazz) {
        assert (!clazz.isInterface());
        return clazz.isLibraryClass() ? this.libraryClassInfo.computeIfAbsent(clazz.asLibraryClass(), this::visitLibraryClassInfoRaw) : MethodSignatures.EMPTY;
    }

    private MethodSignatures visitLibraryClassInfoRaw(DexLibraryClass clazz) {
        MethodSignatures signatures = this.visitLibraryClassInfo(clazz.superType);
        for (DexType iface : clazz.interfaces.values) {
            signatures = signatures.merge(this.visitInterfaceInfo(iface, (ReportingContext)LibraryReportingContext.LIBRARY_CONTEXT));
        }
        return this.computeLibraryClassInfo(clazz, signatures);
    }

    private MethodSignatures visitInterfaceInfo(DexType iface, ReportingContext context) {
        DexClass definition = this.definitionOrNull(iface, context);
        return definition == null ? MethodSignatures.EMPTY : this.visitInterfaceInfo(definition, context);
    }

    private MethodSignatures visitInterfaceInfo(DexClass iface, ReportingContext context) {
        if (iface.isLibraryClass() && this.ignoreLibraryInfo()) {
            return MethodSignatures.EMPTY;
        }
        return this.interfaceInfo.computeIfAbsent(iface, key -> this.visitInterfaceInfoRaw((DexClass)key, context));
    }

    private MethodSignatures visitInterfaceInfoRaw(DexClass iface, ReportingContext context) {
        ReportingContext thisContext = context.forClass(iface);
        MethodSignatures signatures = MethodSignatures.EMPTY;
        for (DexType superiface : iface.interfaces.values) {
            signatures = signatures.merge(this.visitInterfaceInfo(superiface, thisContext));
        }
        return this.computeInterfaceInfo(iface, signatures);
    }

    private static class LibraryReportingContext
    extends ReportingContext {
        static final LibraryReportingContext LIBRARY_CONTEXT = new LibraryReportingContext();

        LibraryReportingContext() {
            super(null, null);
        }

        @Override
        ReportingContext forClass(DexClass directSubClass) {
            return this;
        }

        @Override
        public DexClass definitionFor(DexType type, AppView<?> appView) {
            return appView.definitionFor(type);
        }

        @Override
        public void reportMissingType(DexType missingType, InterfaceMethodRewriter rewriter) {
        }
    }

    private static class ReportingContext {
        final DexClass directSubClass;
        final DexProgramClass closestProgramSubClass;

        public ReportingContext(DexClass directSubClass, DexProgramClass closestProgramSubClass) {
            this.directSubClass = directSubClass;
            this.closestProgramSubClass = closestProgramSubClass;
        }

        ReportingContext forClass(DexClass directSubClass) {
            return new ReportingContext(directSubClass, directSubClass.isProgramClass() ? directSubClass.asProgramClass() : this.closestProgramSubClass);
        }

        public DexClass definitionFor(DexType type, AppView<?> appView) {
            return ((AppInfo)appView.appInfo()).definitionForDesugarDependency(this.directSubClass, type);
        }

        public void reportMissingType(DexType missingType, InterfaceMethodRewriter rewriter) {
            rewriter.warnMissingInterface(this.closestProgramSubClass, this.closestProgramSubClass, missingType);
        }
    }

    private static class ClassInfo {
        static final ClassInfo EMPTY = new ClassInfo(null, ImmutableList.of());
        final ClassInfo parent;
        final ImmutableList<DexEncodedMethod> forwardedMethodTargets;

        ClassInfo(ClassInfo parent, ImmutableList<DexEncodedMethod> forwardedMethodTargets) {
            this.parent = parent;
            this.forwardedMethodTargets = forwardedMethodTargets;
        }

        static ClassInfo create(ClassInfo parent, ImmutableList<DexEncodedMethod> forwardedMethodTargets) {
            return forwardedMethodTargets.isEmpty() ? parent : new ClassInfo(parent, forwardedMethodTargets);
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        boolean isTargetedByForwards(DexEncodedMethod method) {
            return this.forwardedMethodTargets.contains(method) || this.parent != null && this.parent.isTargetedByForwards(method);
        }
    }

    private static class MethodSignatures {
        static final MethodSignatures EMPTY = new MethodSignatures(Collections.emptySet());
        final Set<Equivalence.Wrapper<DexMethod>> signatures;

        static MethodSignatures create(Set<Equivalence.Wrapper<DexMethod>> signatures) {
            return signatures.isEmpty() ? EMPTY : new MethodSignatures(signatures);
        }

        MethodSignatures(Set<Equivalence.Wrapper<DexMethod>> signatures) {
            this.signatures = Collections.unmodifiableSet(signatures);
        }

        MethodSignatures merge(MethodSignatures other) {
            if (this.isEmpty()) {
                return other;
            }
            if (other.isEmpty()) {
                return this;
            }
            HashSet<Equivalence.Wrapper<DexMethod>> merged = new HashSet<Equivalence.Wrapper<DexMethod>>(this.signatures);
            merged.addAll(other.signatures);
            return this.signatures.size() == merged.size() ? this : new MethodSignatures(merged);
        }

        MethodSignatures merge(List<MethodSignatures> others) {
            MethodSignatures merged = this;
            for (MethodSignatures other : others) {
                merged = merged.merge(others);
            }
            return merged;
        }

        boolean isEmpty() {
            return this.signatures.isEmpty();
        }
    }
}

