/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInvoke;
import shadow.bundletool.com.android.tools.r8.code.Instruction;
import shadow.bundletool.com.android.tools.r8.code.InvokeSuper;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.SynthesizedCode;
import shadow.bundletool.com.android.tools.r8.origin.SynthesizedOrigin;
import shadow.bundletool.com.android.tools.r8.utils.Pair;

final class InterfaceProcessor {
    private final AppView<?> appView;
    private final InterfaceMethodRewriter rewriter;
    private final OptimizationFeedback feedback;
    final Map<DexType, DexProgramClass> syntheticClasses = new IdentityHashMap<DexType, DexProgramClass>();

    InterfaceProcessor(AppView<?> appView, InterfaceMethodRewriter rewriter, OptimizationFeedback feedback) {
        this.appView = appView;
        this.rewriter = rewriter;
        this.feedback = feedback;
    }

    void process(DexProgramClass iface, GraphLense.Builder graphLensBuilder) {
        assert (iface.isInterface());
        ArrayList<DexEncodedMethod> companionMethods = new ArrayList<DexEncodedMethod>();
        ArrayList<DexEncodedMethod> remainingMethods = new ArrayList<DexEncodedMethod>();
        for (DexEncodedMethod virtual : iface.virtualMethods()) {
            if (this.rewriter.isDefaultMethod(virtual)) {
                if (!this.canMoveToCompanionClass(virtual)) {
                    throw new CompilationError("One or more instruction is preventing default interface method from being desugared: " + virtual.method.toSourceString(), iface.origin);
                }
                DexMethod companionMethod = this.rewriter.defaultAsMethodOfCompanionClass(virtual.method);
                Code code = virtual.getCode();
                if (code == null) {
                    throw new CompilationError("Code is missing for default interface method: " + virtual.method.toSourceString(), iface.origin);
                }
                MethodAccessFlags newFlags = virtual.accessFlags.copy();
                newFlags.unsetBridge();
                newFlags.promoteToStatic();
                DexEncodedMethod.setDebugInfoWithFakeThisParameter(code, companionMethod.getArity(), this.appView);
                DexEncodedMethod implMethod = new DexEncodedMethod(companionMethod, newFlags, virtual.annotations, virtual.parameterAnnotationsList, code, true);
                implMethod.copyMetadata(virtual, this.feedback);
                virtual.setDefaultInterfaceMethodImplementation(implMethod);
                companionMethods.add(implMethod);
                graphLensBuilder.move(virtual.method, implMethod.method);
            }
            if (!this.interfaceMethodRemovalChangesApi(virtual, iface)) continue;
            remainingMethods.add(virtual);
        }
        if (remainingMethods.size() < iface.virtualMethods().size()) {
            iface.setVirtualMethods(remainingMethods.toArray(DexEncodedMethod.EMPTY_ARRAY));
        }
        remainingMethods.clear();
        for (DexEncodedMethod direct : iface.directMethods()) {
            DexEncodedMethod implMethod;
            Code code;
            DexMethod companionMethod;
            MethodAccessFlags originalFlags = direct.accessFlags;
            MethodAccessFlags newFlags = originalFlags.copy();
            if (originalFlags.isPrivate()) {
                newFlags.promoteToPublic();
            }
            DexMethod oldMethod = direct.method;
            if (this.isStaticMethod(direct)) {
                assert (originalFlags.isPrivate() || originalFlags.isPublic()) : "Static interface method " + direct.toSourceString() + " is expected to either be public or private in " + iface.origin;
                companionMethod = this.rewriter.staticAsMethodOfCompanionClass(oldMethod);
                code = direct.getCode();
                implMethod = new DexEncodedMethod(companionMethod, newFlags, direct.annotations, direct.parameterAnnotationsList, direct.getCode(), true);
                implMethod.copyMetadata(direct, this.feedback);
                companionMethods.add(implMethod);
                graphLensBuilder.move(oldMethod, companionMethod);
                continue;
            }
            if (originalFlags.isPrivate()) {
                assert (!this.rewriter.factory.isClassConstructor(oldMethod)) : "Unexpected private constructor " + direct.toSourceString() + " in " + iface.origin;
                newFlags.promoteToStatic();
                companionMethod = this.rewriter.privateAsMethodOfCompanionClass(oldMethod);
                code = direct.getCode();
                if (code == null) {
                    throw new CompilationError("Code is missing for private instance interface method: " + oldMethod.toSourceString(), iface.origin);
                }
                DexEncodedMethod.setDebugInfoWithFakeThisParameter(code, companionMethod.getArity(), this.appView);
                implMethod = new DexEncodedMethod(companionMethod, newFlags, direct.annotations, direct.parameterAnnotationsList, code, true);
                implMethod.copyMetadata(direct, this.feedback);
                companionMethods.add(implMethod);
                graphLensBuilder.move(oldMethod, companionMethod);
                continue;
            }
            assert (this.rewriter.factory.isClassConstructor(oldMethod));
            remainingMethods.add(direct);
        }
        if (remainingMethods.size() < iface.directMethods().size()) {
            iface.setDirectMethods(remainingMethods.toArray(DexEncodedMethod.EMPTY_ARRAY));
        }
        if (companionMethods.isEmpty()) {
            return;
        }
        ClassAccessFlags companionClassFlags = iface.accessFlags.copy();
        companionClassFlags.unsetAbstract();
        companionClassFlags.unsetInterface();
        companionClassFlags.unsetAnnotation();
        companionClassFlags.setFinal();
        companionClassFlags.setSynthetic();
        companionClassFlags.setPublic();
        DexType companionClassType = this.rewriter.getCompanionClassType(iface.type);
        DexProgramClass companionClass = new DexProgramClass(companionClassType, null, new SynthesizedOrigin("interface desugaring", this.getClass()), companionClassFlags, this.rewriter.factory.objectType, DexTypeList.empty(), iface.sourceFile, null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, companionMethods.toArray(DexEncodedMethod.EMPTY_ARRAY), DexEncodedMethod.EMPTY_ARRAY, this.rewriter.factory.getSkipNameValidationForTesting(), this.getChecksumSupplier(iface), Collections.singletonList(iface));
        this.syntheticClasses.put(iface.type, companionClass);
    }

    private DexProgramClass.ChecksumSupplier getChecksumSupplier(DexProgramClass iface) {
        if (!this.appView.options().encodeChecksums) {
            return DexProgramClass::invalidChecksumRequest;
        }
        long checksum = iface.getChecksum();
        return c -> 7L * checksum;
    }

    List<DexEncodedMethod> process(DexLibraryClass iface, Set<DexProgramClass> callers) {
        assert (iface.isInterface());
        ArrayList<DexEncodedMethod> dispatchMethods = new ArrayList<DexEncodedMethod>();
        for (DexEncodedMethod direct : iface.directMethods()) {
            MethodAccessFlags originalAccessFlags = direct.accessFlags;
            if (!originalAccessFlags.isStatic() || !originalAccessFlags.isPublic()) {
                assert (!originalAccessFlags.isStatic() || originalAccessFlags.isPrivate());
                continue;
            }
            assert (!this.rewriter.factory.isClassConstructor(direct.method));
            DexMethod origMethod = direct.method;
            DexMethod newMethod = this.rewriter.staticAsMethodOfDispatchClass(origMethod);
            ForwardMethodSourceCode.Builder forwardSourceCodeBuilder = ForwardMethodSourceCode.builder(newMethod);
            forwardSourceCodeBuilder.setTarget(origMethod).setInvokeType(Invoke.Type.STATIC).setIsInterface(false);
            DexEncodedMethod newEncodedMethod = new DexEncodedMethod(newMethod, MethodAccessFlags.fromSharedAccessFlags(4105, false), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)new SynthesizedCode(forwardSourceCodeBuilder::build), true);
            newEncodedMethod.getMutableOptimizationInfo().markNeverInline();
            dispatchMethods.add(newEncodedMethod);
        }
        ClassAccessFlags dispatchClassFlags = ClassAccessFlags.fromSharedAccessFlags(4113);
        DexType dispatchClassType = this.rewriter.getDispatchClassType(iface.type);
        DexProgramClass dispatchClass = new DexProgramClass(dispatchClassType, null, new SynthesizedOrigin("interface dispatch", this.getClass()), dispatchClassFlags, this.rewriter.factory.objectType, DexTypeList.empty(), iface.sourceFile, null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, dispatchMethods.toArray(DexEncodedMethod.EMPTY_ARRAY), DexEncodedMethod.EMPTY_ARRAY, this.rewriter.factory.getSkipNameValidationForTesting(), DexProgramClass::checksumFromType, callers);
        this.syntheticClasses.put(iface.type, dispatchClass);
        return dispatchMethods;
    }

    private boolean canMoveToCompanionClass(DexEncodedMethod method) {
        Code code = method.getCode();
        assert (code != null);
        if (code.isDexCode()) {
            for (Instruction insn : code.asDexCode().instructions) {
                if (!(insn instanceof InvokeSuper)) continue;
                return false;
            }
        } else {
            assert (code.isCfCode());
            for (CfInstruction insn : code.asCfCode().getInstructions()) {
                if (!(insn instanceof CfInvoke) || !((CfInvoke)insn).isInvokeSuper(method.method.holder)) continue;
                return false;
            }
        }
        return true;
    }

    private DexClass definitionForDependency(DexType dependency, DexClass dependent) {
        return dependent.isProgramClass() ? ((AppInfo)this.appView.appInfo()).definitionForDesugarDependency(dependent.asProgramClass(), dependency) : this.appView.definitionFor(dependency);
    }

    private boolean interfaceMethodRemovalChangesApi(DexEncodedMethod method, DexClass iface) {
        if (this.appView.enableWholeProgramOptimizations() && ((AppInfo)this.appView.appInfo()).withLiveness().isPinned(method.method)) {
            return true;
        }
        if (method.accessFlags.isBridge()) {
            ArrayDeque<Pair<DexClass, DexType>> worklist = new ArrayDeque<Pair<DexClass, DexType>>();
            HashSet<DexType> seenBefore = new HashSet<DexType>();
            InterfaceProcessor.addSuperTypes(iface, worklist);
            while (!worklist.isEmpty()) {
                Pair item = (Pair)worklist.pop();
                DexClass clazz = this.definitionForDependency((DexType)item.getSecond(), (DexClass)item.getFirst());
                if (clazz == null || !seenBefore.add(clazz.type)) continue;
                if (clazz.lookupVirtualMethod(method.method) != null) {
                    return false;
                }
                InterfaceProcessor.addSuperTypes(clazz, worklist);
            }
        }
        return true;
    }

    private static void addSuperTypes(DexClass clazz, Deque<Pair<DexClass, DexType>> worklist) {
        if (clazz.superType != null) {
            worklist.add(new Pair<DexClass, DexType>(clazz, clazz.superType));
        }
        for (DexType iface : clazz.interfaces.values) {
            worklist.add(new Pair<DexClass, DexType>(clazz, iface));
        }
    }

    private boolean isStaticMethod(DexEncodedMethod method) {
        if (method.accessFlags.isNative()) {
            throw new Unimplemented("Native interface methods are not yet supported.");
        }
        return method.accessFlags.isStatic() && !this.rewriter.factory.isClassConstructor(method.method);
    }

    public static class InterfaceProcessorNestedGraphLense
    extends GraphLense.NestedGraphLense {
        public InterfaceProcessorNestedGraphLense(Map<DexType, DexType> typeMap, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, BiMap<DexField, DexField> originalFieldSignatures, BiMap<DexMethod, DexMethod> originalMethodSignatures, GraphLense previousLense, DexItemFactory dexItemFactory) {
            super(typeMap, methodMap, fieldMap, originalFieldSignatures, originalMethodSignatures, previousLense, dexItemFactory);
        }

        @Override
        protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, Invoke.Type type) {
            return Invoke.Type.STATIC;
        }

        public static GraphLense.Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends GraphLense.Builder {
            @Override
            public GraphLense build(DexItemFactory dexItemFactory, GraphLense previousLense) {
                if (this.originalFieldSignatures.isEmpty() && this.originalMethodSignatures.isEmpty()) {
                    return previousLense;
                }
                return new InterfaceProcessorNestedGraphLense(this.typeMap, this.methodMap, this.fieldMap, this.originalFieldSignatures, this.originalMethodSignatures, previousLense, dexItemFactory);
            }
        }
    }
}

