/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Suppliers;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.MethodAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.desugar.AccessorMethodSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaBridgeMethodSynthesizedCode;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaClassConstructorSynthesizedCode;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaConstructorSynthesizedCode;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaDescriptor;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaMainMethodSynthesizedCode;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.SynthesizedCode;
import shadow.bundletool.com.android.tools.r8.origin.SynthesizedOrigin;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

final class LambdaClass {
    final LambdaRewriter rewriter;
    final DexType type;
    final LambdaDescriptor descriptor;
    final DexMethod constructor;
    final DexMethod classConstructor;
    final DexField lambdaField;
    final Target target;
    final AtomicBoolean addToMainDexList = new AtomicBoolean(false);
    private final Collection<DexProgramClass> synthesizedFrom = new ArrayList<DexProgramClass>(1);
    private final Supplier<DexProgramClass> lazyDexClass = Suppliers.memoize(this::synthesizeLambdaClass);

    LambdaClass(LambdaRewriter rewriter, DexType accessedFrom, DexType lambdaClassType, LambdaDescriptor descriptor) {
        assert (rewriter != null);
        assert (lambdaClassType != null);
        assert (descriptor != null);
        this.rewriter = rewriter;
        this.type = lambdaClassType;
        this.descriptor = descriptor;
        DexItemFactory factory = rewriter.getFactory();
        DexProto constructorProto = factory.createProto(factory.voidType, descriptor.captures.values);
        this.constructor = factory.createMethod(lambdaClassType, constructorProto, rewriter.constructorName);
        this.target = this.createTarget(accessedFrom);
        boolean stateless = this.isStateless();
        this.classConstructor = !stateless ? null : factory.createMethod(lambdaClassType, constructorProto, rewriter.classConstructorName);
        this.lambdaField = !stateless ? null : factory.createField(lambdaClassType, lambdaClassType, rewriter.instanceFieldName);
    }

    static DexType createLambdaClassType(LambdaRewriter rewriter, DexType accessedFrom, LambdaDescriptor match) {
        return LambdaClass.createLambdaClassType(rewriter.getFactory(), accessedFrom, match);
    }

    public static DexType createLambdaClassType(DexItemFactory factory, DexType accessedFrom, LambdaDescriptor match) {
        StringBuilder lambdaClassDescriptor = new StringBuilder("L");
        String packageDescriptor = accessedFrom.getPackageDescriptor();
        if (!packageDescriptor.isEmpty()) {
            lambdaClassDescriptor.append(packageDescriptor).append('/');
        }
        lambdaClassDescriptor.append("-$$Lambda$");
        if (match.delegatesToLambdaImplMethod() || match.needsAccessor(accessedFrom)) {
            lambdaClassDescriptor.append(accessedFrom.getName()).append('$');
        }
        lambdaClassDescriptor.append(match.uniqueId).append(';');
        return factory.createType(lambdaClassDescriptor.toString());
    }

    final DexProgramClass getOrCreateLambdaClass() {
        return this.lazyDexClass.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexProgramClass synthesizeLambdaClass() {
        DexMethod mainMethod = this.rewriter.getFactory().createMethod(this.type, this.descriptor.erasedProto, this.descriptor.name);
        DexProgramClass clazz = new DexProgramClass(this.type, null, new SynthesizedOrigin("lambda desugaring", this.getClass()), ClassAccessFlags.fromDexAccessFlags(4113), this.rewriter.getFactory().objectType, this.buildInterfaces(), this.rewriter.getFactory().createString("lambda"), null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), this.synthesizeStaticFields(), this.synthesizeInstanceFields(), this.synthesizeDirectMethods(), this.synthesizeVirtualMethods(mainMethod), this.rewriter.getFactory().getSkipNameValidationForTesting(), LambdaClass::computeChecksumForSynthesizedClass);
        this.rewriter.getAppInfo().addSynthesizedClass(clazz);
        Collection<DexProgramClass> collection = this.synthesizedFrom;
        synchronized (collection) {
            this.synthesizedFrom.forEach(clazz::addSynthesizedFrom);
        }
        return clazz;
    }

    private static long computeChecksumForSynthesizedClass(DexProgramClass clazz) {
        Collection<DexProgramClass> synthesizedFrom = clazz.getSynthesizedFrom();
        ByteBuffer buffer = ByteBuffer.allocate(synthesizedFrom.size() * 8);
        for (DexProgramClass from : synthesizedFrom) {
            buffer.putLong(from.getChecksum());
        }
        CRC32 crc = new CRC32();
        byte[] array = buffer.array();
        crc.update(array, 0, array.length);
        return crc.getValue();
    }

    final DexField getCaptureField(int index) {
        return this.rewriter.getFactory().createField(this.type, this.descriptor.captures.values[index], this.rewriter.getFactory().createString("f$" + index));
    }

    final boolean isStateless() {
        return this.descriptor.isStateless();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSynthesizedFrom(DexProgramClass clazz) {
        assert (clazz != null);
        Collection<DexProgramClass> collection = this.synthesizedFrom;
        synchronized (collection) {
            if (this.synthesizedFrom.add(clazz)) {
                this.getOrCreateLambdaClass().addSynthesizedFrom(clazz);
            }
        }
    }

    private DexEncodedMethod[] synthesizeVirtualMethods(DexMethod mainMethod) {
        DexEncodedMethod[] methods = new DexEncodedMethod[1 + this.descriptor.bridges.size()];
        int index = 0;
        methods[index++] = new DexEncodedMethod(mainMethod, MethodAccessFlags.fromSharedAccessFlags(17, false), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)new LambdaMainMethodSynthesizedCode(this, mainMethod), true);
        for (DexProto bridgeProto : this.descriptor.bridges) {
            DexMethod bridgeMethod = this.rewriter.getFactory().createMethod(this.type, bridgeProto, this.descriptor.name);
            methods[index++] = new DexEncodedMethod(bridgeMethod, MethodAccessFlags.fromSharedAccessFlags(4177, false), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)new LambdaBridgeMethodSynthesizedCode(this, mainMethod, bridgeMethod), true);
        }
        return methods;
    }

    private DexEncodedMethod[] synthesizeDirectMethods() {
        boolean stateless = this.isStateless();
        DexEncodedMethod[] methods = new DexEncodedMethod[stateless ? 2 : 1];
        methods[0] = new DexEncodedMethod(this.constructor, MethodAccessFlags.fromSharedAccessFlags((stateless ? 2 : 1) | 0x1000, true), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)new LambdaConstructorSynthesizedCode(this), true);
        if (stateless) {
            methods[1] = new DexEncodedMethod(this.classConstructor, MethodAccessFlags.fromSharedAccessFlags(4104, true), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)new LambdaClassConstructorSynthesizedCode(this), true);
        }
        return methods;
    }

    private DexEncodedField[] synthesizeInstanceFields() {
        DexType[] fieldTypes = this.descriptor.captures.values;
        int fieldCount = fieldTypes.length;
        DexEncodedField[] fields = new DexEncodedField[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            FieldAccessFlags accessFlags = FieldAccessFlags.fromSharedAccessFlags(4113);
            fields[i] = new DexEncodedField(this.getCaptureField(i), accessFlags, DexAnnotationSet.empty(), null);
        }
        return fields;
    }

    private DexEncodedField[] synthesizeStaticFields() {
        if (!this.isStateless()) {
            return DexEncodedField.EMPTY_ARRAY;
        }
        assert (this.lambdaField != null);
        DexEncodedField[] fields = new DexEncodedField[]{new DexEncodedField(this.lambdaField, FieldAccessFlags.fromSharedAccessFlags(4121), DexAnnotationSet.empty(), DexValue.DexValueNull.NULL)};
        return fields;
    }

    private DexTypeList buildInterfaces() {
        List<DexType> interfaces = this.descriptor.interfaces;
        return interfaces.isEmpty() ? DexTypeList.empty() : new DexTypeList(interfaces.toArray(DexType.EMPTY_ARRAY));
    }

    private Target createTarget(DexType accessedFrom) {
        if (this.descriptor.delegatesToLambdaImplMethod()) {
            return this.createLambdaImplMethodTarget(accessedFrom);
        }
        switch (this.descriptor.implHandle.type) {
            case INVOKE_SUPER: {
                throw new Unimplemented("Method references to super methods are not yet supported");
            }
            case INVOKE_INTERFACE: {
                return this.createInterfaceMethodTarget(accessedFrom);
            }
            case INVOKE_CONSTRUCTOR: {
                return this.createConstructorTarget(accessedFrom);
            }
            case INVOKE_STATIC: {
                return this.createStaticMethodTarget(accessedFrom);
            }
            case INVOKE_DIRECT: 
            case INVOKE_INSTANCE: {
                return this.createInstanceMethodTarget(accessedFrom);
            }
        }
        throw new Unreachable("Unexpected method handle type in " + this.descriptor.implHandle);
    }

    private Target createLambdaImplMethodTarget(DexType accessedFrom) {
        DexMethodHandle implHandle = this.descriptor.implHandle;
        assert (implHandle != null);
        DexMethod implMethod = implHandle.asMethod();
        assert (implMethod.holder == accessedFrom);
        assert (this.descriptor.targetFoundInClass(accessedFrom));
        assert (this.descriptor.getAccessibility() != null);
        if (implHandle.type.isInvokeStatic()) {
            return new StaticLambdaImplTarget();
        }
        assert (implHandle.type.isInvokeInstance() || implHandle.type.isInvokeDirect());
        if (implHandle.type.isInvokeDirect() && this.rewriter.getAppView().definitionFor(implMethod.holder).isInterface()) {
            DexProto implProto = implMethod.proto;
            DexType[] implParams = implProto.parameters.values;
            DexType[] newParams = new DexType[implParams.length + 1];
            newParams[0] = implMethod.holder;
            System.arraycopy(implParams, 0, newParams, 1, implParams.length);
            DexProto newProto = this.rewriter.getFactory().createProto(implProto.returnType, newParams);
            return new InterfaceLambdaImplTarget(this.rewriter.getFactory().createMethod(implMethod.holder, newProto, implMethod.name));
        }
        return new InstanceLambdaImplTarget(this.rewriter.getFactory().createMethod(implMethod.holder, implMethod.proto, this.rewriter.getFactory().createString(implMethod.name.toString() + "$" + implMethod.holder.getName())));
    }

    private Target createInstanceMethodTarget(DexType accessedFrom) {
        assert (this.descriptor.implHandle.type.isInvokeInstance() || this.descriptor.implHandle.type.isInvokeDirect());
        if (!this.descriptor.needsAccessor(accessedFrom)) {
            return new NoAccessorMethodTarget(Invoke.Type.VIRTUAL);
        }
        DexMethod implMethod = this.descriptor.implHandle.asMethod();
        DexProto implProto = implMethod.proto;
        DexType[] implParams = implProto.parameters.values;
        DexType[] accessorParams = new DexType[1 + implParams.length];
        accessorParams[0] = this.descriptor.getImplReceiverType();
        System.arraycopy(implParams, 0, accessorParams, 1, implParams.length);
        DexProto accessorProto = this.rewriter.getFactory().createProto(implProto.returnType, accessorParams);
        DexMethod accessorMethod = this.rewriter.getFactory().createMethod(accessedFrom, accessorProto, this.generateUniqueLambdaMethodName());
        return new ClassMethodWithAccessorTarget(accessorMethod);
    }

    private Target createStaticMethodTarget(DexType accessedFrom) {
        assert (this.descriptor.implHandle.type.isInvokeStatic());
        if (!this.descriptor.needsAccessor(accessedFrom)) {
            return new NoAccessorMethodTarget(Invoke.Type.STATIC);
        }
        DexMethod accessorMethod = this.rewriter.getFactory().createMethod(accessedFrom, this.descriptor.implHandle.asMethod().proto, this.generateUniqueLambdaMethodName());
        return new ClassMethodWithAccessorTarget(accessorMethod);
    }

    private Target createConstructorTarget(DexType accessedFrom) {
        DexMethodHandle implHandle = this.descriptor.implHandle;
        assert (implHandle != null);
        assert (implHandle.type.isInvokeConstructor());
        if (!this.descriptor.needsAccessor(accessedFrom)) {
            return new NoAccessorMethodTarget(Invoke.Type.DIRECT);
        }
        DexMethod implMethod = implHandle.asMethod();
        DexType returnType = implMethod.holder;
        DexProto accessorProto = this.rewriter.getFactory().createProto(returnType, implMethod.proto.parameters.values);
        DexMethod accessorMethod = this.rewriter.getFactory().createMethod(accessedFrom, accessorProto, this.generateUniqueLambdaMethodName());
        return new ClassMethodWithAccessorTarget(accessorMethod);
    }

    private Target createInterfaceMethodTarget(DexType accessedFrom) {
        assert (this.descriptor.implHandle.type.isInvokeInterface());
        assert (!this.descriptor.needsAccessor(accessedFrom));
        return new NoAccessorMethodTarget(Invoke.Type.INTERFACE);
    }

    private DexString generateUniqueLambdaMethodName() {
        return this.rewriter.getFactory().createString("lambda$" + this.descriptor.uniqueId);
    }

    private class ClassMethodWithAccessorTarget
    extends Target {
        ClassMethodWithAccessorTarget(DexMethod accessorMethod) {
            super(accessorMethod, Invoke.Type.STATIC);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void ensureAccessibility(IRConverter converter, OptimizationFeedback feedback) {
            DexProgramClass accessorClass = this.programDefinitionFor(this.callTarget.holder);
            assert (accessorClass != null);
            MethodAccessFlags accessorFlags = MethodAccessFlags.fromSharedAccessFlags(4105, false);
            DexEncodedMethod accessorEncodedMethod = new DexEncodedMethod(this.callTarget, accessorFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), (Code)new SynthesizedCode(callerPosition -> new AccessorMethodSourceCode(LambdaClass.this, callerPosition)), true);
            DexProgramClass dexProgramClass = accessorClass;
            synchronized (dexProgramClass) {
                accessorClass.appendDirectMethod(accessorEncodedMethod);
            }
            converter.optimizeSynthesizedMethod(accessorEncodedMethod);
        }
    }

    private class InstanceLambdaImplTarget
    extends Target {
        InstanceLambdaImplTarget(DexMethod staticMethod) {
            super(staticMethod, Invoke.Type.VIRTUAL);
        }

        @Override
        void ensureAccessibility(IRConverter converter, OptimizationFeedback feedback) {
            DexMethod implMethod = LambdaClass.this.descriptor.implHandle.asMethod();
            DexClass implMethodHolder = this.definitionFor(implMethod.holder);
            List<DexEncodedMethod> oldDirectMethods = implMethodHolder.directMethods();
            for (int i = 0; i < oldDirectMethods.size(); ++i) {
                DexEncodedMethod encodedMethod = oldDirectMethods.get(i);
                if (!implMethod.match(encodedMethod)) continue;
                MethodAccessFlags newAccessFlags = encodedMethod.accessFlags.copy();
                newAccessFlags.unsetPrivate();
                newAccessFlags.setPublic();
                DexEncodedMethod newMethod = new DexEncodedMethod(this.callTarget, newAccessFlags, encodedMethod.annotations, encodedMethod.parameterAnnotationsList, encodedMethod.getCode(), true);
                newMethod.copyMetadata(encodedMethod, feedback);
                LambdaClass.this.rewriter.methodMapping.put(encodedMethod.method, this.callTarget);
                implMethodHolder.removeDirectMethod(i);
                implMethodHolder.appendVirtualMethod(newMethod);
                return;
            }
        }
    }

    private class InterfaceLambdaImplTarget
    extends Target {
        InterfaceLambdaImplTarget(DexMethod staticMethod) {
            super(staticMethod, Invoke.Type.STATIC);
        }

        @Override
        void ensureAccessibility(IRConverter converter, OptimizationFeedback feedback) {
            DexMethod implMethod = LambdaClass.this.descriptor.implHandle.asMethod();
            DexClass implMethodHolder = this.definitionFor(implMethod.holder);
            List<DexEncodedMethod> directMethods = implMethodHolder.directMethods();
            for (int i = 0; i < directMethods.size(); ++i) {
                DexEncodedMethod encodedMethod = directMethods.get(i);
                if (!implMethod.match(encodedMethod)) continue;
                MethodAccessFlags newAccessFlags = encodedMethod.accessFlags.copy();
                newAccessFlags.setStatic();
                newAccessFlags.unsetPrivate();
                newAccessFlags.setPublic();
                DexEncodedMethod newMethod = new DexEncodedMethod(this.callTarget, newAccessFlags, encodedMethod.annotations, encodedMethod.parameterAnnotationsList, encodedMethod.getCode(), true);
                newMethod.copyMetadata(encodedMethod, feedback);
                LambdaClass.this.rewriter.methodMapping.put(encodedMethod.method, this.callTarget);
                DexEncodedMethod.setDebugInfoWithFakeThisParameter(newMethod.getCode(), this.callTarget.getArity(), LambdaClass.this.rewriter.getAppView());
                implMethodHolder.setDirectMethod(i, newMethod);
                return;
            }
            assert (false) : "Unexpected failure to find direct lambda target for: " + implMethod.qualifiedName();
        }
    }

    private final class StaticLambdaImplTarget
    extends Target {
        StaticLambdaImplTarget() {
            super(LambdaClass.this.descriptor.implHandle.asMethod(), Invoke.Type.STATIC);
        }

        @Override
        void ensureAccessibility(IRConverter converter, OptimizationFeedback feedback) {
            assert (LambdaClass.this.descriptor.getAccessibility() != null);
            LambdaClass.this.descriptor.getAccessibility().unsetPrivate();
            DexClass implMethodHolder = this.definitionFor(LambdaClass.this.descriptor.implHandle.asMethod().holder);
            if (implMethodHolder.isInterface()) {
                LambdaClass.this.descriptor.getAccessibility().setPublic();
            }
        }
    }

    private final class NoAccessorMethodTarget
    extends Target {
        NoAccessorMethodTarget(Invoke.Type invokeType) {
            super(LambdaClass.this.descriptor.implHandle.asMethod(), invokeType);
        }

        @Override
        void ensureAccessibility(IRConverter converter, OptimizationFeedback feedback) {
        }
    }

    abstract class Target {
        final DexMethod callTarget;
        final Invoke.Type invokeType;

        Target(DexMethod callTarget, Invoke.Type invokeType) {
            assert (callTarget != null);
            assert (invokeType != null);
            this.callTarget = callTarget;
            this.invokeType = invokeType;
        }

        abstract void ensureAccessibility(IRConverter var1, OptimizationFeedback var2);

        DexClass definitionFor(DexType type) {
            return LambdaClass.this.rewriter.getAppInfo().app().definitionFor(type);
        }

        DexProgramClass programDefinitionFor(DexType type) {
            return LambdaClass.this.rewriter.getAppInfo().app().programDefinitionFor(type);
        }

        boolean holderIsInterface() {
            InternalOptions options = LambdaClass.this.rewriter.getAppView().options();
            if (!options.isGeneratingClassFiles()) {
                return false;
            }
            assert (options.isDesugaredLibraryCompilation() || options.enableCfInterfaceMethodDesugaring);
            DexMethod implMethod = LambdaClass.this.descriptor.implHandle.asMethod();
            DexClass implMethodHolder = this.definitionFor(implMethod.holder);
            if (implMethodHolder == null) {
                assert (options.desugaredLibraryConfiguration.getBackportCoreLibraryMember().containsKey(implMethod.holder));
                return false;
            }
            return implMethodHolder.isInterface();
        }
    }
}

