/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public abstract class PrefixRewritingMapper {
    public static PrefixRewritingMapper empty() {
        return new EmptyPrefixRewritingMapper();
    }

    public abstract DexType rewrittenType(DexType var1);

    public abstract void rewriteType(DexType var1, DexType var2);

    public boolean hasRewrittenType(DexType type) {
        return this.rewrittenType(type) != null;
    }

    public boolean hasRewrittenTypeInSignature(DexProto proto) {
        if (this.hasRewrittenType(proto.returnType)) {
            return true;
        }
        for (DexType paramType : proto.parameters.values) {
            if (!this.hasRewrittenType(paramType)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isRewriting();

    public static class EmptyPrefixRewritingMapper
    extends PrefixRewritingMapper {
        @Override
        public DexType rewrittenType(DexType type) {
            return null;
        }

        @Override
        public void rewriteType(DexType type, DexType rewrittenType) {
        }

        @Override
        public boolean isRewriting() {
            return false;
        }
    }

    public static class DesugarPrefixRewritingMapper
    extends PrefixRewritingMapper {
        private final Set<DexType> notRewritten = Sets.newConcurrentHashSet();
        private final Map<DexType, DexType> rewritten = new ConcurrentHashMap<DexType, DexType>();
        private final Map<DexString, DexString> initialPrefixes;
        private final DexItemFactory factory;

        public DesugarPrefixRewritingMapper(Map<String, String> prefixes, DexItemFactory factory) {
            this.factory = factory;
            ImmutableMap.Builder<DexString, DexString> builder = ImmutableMap.builder();
            for (String key : prefixes.keySet()) {
                builder.put(this.toDescriptorPrefix(key), this.toDescriptorPrefix(prefixes.get(key)));
            }
            this.initialPrefixes = builder.build();
            this.validatePrefixes(prefixes);
        }

        private DexString toDescriptorPrefix(String prefix) {
            return this.factory.createString("L" + DescriptorUtils.getBinaryNameFromJavaType(prefix));
        }

        private void validatePrefixes(Map<String, String> initialPrefixes) {
            String[] prefixes = initialPrefixes.keySet().toArray(new String[0]);
            for (int i = 0; i < prefixes.length; ++i) {
                for (int j = i + 1; j < prefixes.length; ++j) {
                    String large;
                    String small;
                    if (prefixes[i].length() < prefixes[j].length()) {
                        small = prefixes[i];
                        large = prefixes[j];
                    } else {
                        small = prefixes[j];
                        large = prefixes[i];
                    }
                    if (!large.startsWith(small)) continue;
                    throw new CompilationError("Inconsistent prefix in desugared library: Should a class starting with " + small + " be rewritten using " + small + " -> " + initialPrefixes.get(small) + " or using " + large + " - > " + initialPrefixes.get(large) + " ?");
                }
            }
        }

        @Override
        public DexType rewrittenType(DexType type) {
            if (this.notRewritten.contains(type)) {
                return null;
            }
            if (this.rewritten.containsKey(type)) {
                return this.rewritten.get(type);
            }
            return this.computePrefix(type);
        }

        @Override
        public void rewriteType(DexType type, DexType rewrittenType) {
            assert (!this.notRewritten.contains(type)) : "New rewriting rule for " + type + " but the compiler has already made decisions based on the fact that this type was not rewritten";
            assert (!this.rewritten.containsKey(type) || this.rewritten.get(type) == rewrittenType) : "New rewriting rule for " + type + " but the compiler has already made decisions based on a different rewriting rule for this type";
            this.rewritten.put(type, rewrittenType);
        }

        private DexType computePrefix(DexType type) {
            DexString prefixToMatch = type.descriptor.withoutArray(this.factory);
            DexType result = this.lookup(type, prefixToMatch, this.initialPrefixes);
            if (result != null) {
                return result;
            }
            this.notRewritten.add(type);
            return null;
        }

        private DexType lookup(DexType type, DexString prefixToMatch, Map<DexString, DexString> map2) {
            for (DexString prefix : map2.keySet()) {
                if (!prefixToMatch.startsWith(prefix)) continue;
                DexString rewrittenTypeDescriptor = type.descriptor.withNewPrefix(prefix, map2.get(prefix), this.factory);
                DexType rewrittenType = this.factory.createType(rewrittenTypeDescriptor);
                this.rewriteType(type, rewrittenType);
                return rewrittenType;
            }
            return null;
        }

        @Override
        public boolean isRewriting() {
            return true;
        }
    }
}

