/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ListIterator;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningOracle;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningStrategy;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

final class ForcedInliningOracle
implements InliningOracle,
InliningStrategy {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexEncodedMethod method;
    private final Map<? extends InvokeMethod, Inliner.InliningInfo> invokesToInline;

    ForcedInliningOracle(AppView<AppInfoWithLiveness> appView, DexEncodedMethod method, Map<? extends InvokeMethod, Inliner.InliningInfo> invokesToInline) {
        this.appView = appView;
        this.method = method;
        this.invokesToInline = invokesToInline;
    }

    @Override
    public boolean isForcedInliningOracle() {
        return true;
    }

    @Override
    public boolean passesInliningConstraints(InvokeMethod invoke, DexEncodedMethod candidate, Inliner.Reason reason, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return true;
    }

    @Override
    public DexEncodedMethod lookupSingleTarget(InvokeMethod invoke, DexType context) {
        Inliner.InliningInfo info = this.invokesToInline.get(invoke);
        if (info != null) {
            return info.target;
        }
        return invoke.lookupSingleTarget(this.appView, context);
    }

    @Override
    public Inliner.InlineAction computeInlining(InvokeMethod invoke, DexEncodedMethod singleTarget, ClassInitializationAnalysis classInitializationAnalysis, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return this.computeForInvoke(invoke, whyAreYouNotInliningReporter);
    }

    private Inliner.InlineAction computeForInvoke(InvokeMethod invoke, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        Inliner.InliningInfo info = this.invokesToInline.get(invoke);
        if (info == null) {
            return null;
        }
        assert (this.method != info.target);
        assert (!info.target.getOptimizationInfo().neverInline());
        assert (this.passesInliningConstraints(invoke, info.target, Inliner.Reason.FORCE, whyAreYouNotInliningReporter));
        return new Inliner.InlineAction(info.target, invoke, Inliner.Reason.FORCE);
    }

    @Override
    public void ensureMethodProcessed(DexEncodedMethod target, IRCode inlinee, OptimizationFeedback feedback) {
    }

    @Override
    public void updateTypeInformationIfNeeded(IRCode inlinee, ListIterator<BasicBlock> blockIterator, BasicBlock block) {
    }

    @Override
    public boolean allowInliningOfInvokeInInlinee(Inliner.InlineAction action, int inliningDepth, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return false;
    }

    @Override
    public boolean canInlineInstanceInitializer(IRCode code, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return true;
    }

    @Override
    public boolean stillHasBudget(Inliner.InlineAction action, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return true;
    }

    @Override
    public boolean willExceedBudget(IRCode code, InvokeMethod invoke, Inliner.InlineeWithReason inlinee, BasicBlock block, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return false;
    }

    @Override
    public void markInlined(Inliner.InlineeWithReason inlinee) {
    }

    @Override
    public DexType getReceiverTypeIfKnown(InvokeMethod invoke) {
        assert (invoke.isInvokeMethodWithReceiver());
        Inliner.InliningInfo info = this.invokesToInline.get(invoke.asInvokeMethodWithReceiver());
        assert (info != null);
        return info.receiverType;
    }
}

