/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.Hash;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.optimize.MemberRebindingAnalysis;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class IdempotentFunctionCallCanonicalizer {
    private static final int MAX_CANONICALIZED_CALL = 15;
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private int numberOfLibraryCallCanonicalization = 0;
    private int numberOfProgramCallCanonicalization = 0;
    private final Object2IntMap<Long> histogramOfCanonicalizationCandidatesPerMethod;

    public IdempotentFunctionCallCanonicalizer(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.histogramOfCanonicalizationCandidatesPerMethod = Log.ENABLED ? new Object2IntArrayMap<Long>() : null;
    }

    public void logResults() {
        assert (Log.ENABLED);
        Log.info(this.getClass(), "# invoke canonicalization (library): %s", this.numberOfLibraryCallCanonicalization);
        Log.info(this.getClass(), "# invoke canonicalization (program): %s", this.numberOfProgramCallCanonicalization);
        assert (this.histogramOfCanonicalizationCandidatesPerMethod != null);
        Log.info(this.getClass(), "------ histogram of invoke canonicalization candidates ------", new Object[0]);
        this.histogramOfCanonicalizationCandidatesPerMethod.forEach((length, count) -> Log.info(this.getClass(), "%s: %s (%s)", length, StringUtils.times("*", Math.min(count, 53)), count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void canonicalize(IRCode code) {
        Object2ObjectLinkedOpenCustomHashMap<InvokeMethod, List> returnValues = new Object2ObjectLinkedOpenCustomHashMap<InvokeMethod, List>(new Hash.Strategy<InvokeMethod>(){

            @Override
            public int hashCode(InvokeMethod o) {
                return o.getInvokedMethod().hashCode() * 31 + o.inValues().hashCode();
            }

            @Override
            public boolean equals(InvokeMethod a, InvokeMethod b) {
                assert (a == null || !a.outValue().hasLocalInfo());
                assert (b == null || !b.outValue().hasLocalInfo());
                return a == b || a != null && b != null && a.identicalNonValueNonPositionParts(b) && a.inValues().equals(b.inValues());
            }
        });
        DexType context = code.method.method.holder;
        for (BasicBlock block : code.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                Object receiver;
                InvokeMethod invoke;
                if (!instruction.isInvokeMethod() || (invoke = instruction.asInvokeMethod()).outValue() == null || instruction.outValue().hasLocalInfo()) continue;
                if (!this.isIdempotentLibraryMethodInvoke(invoke)) {
                    if (!this.appView.enableWholeProgramOptimizations()) continue;
                    assert (((AppInfo)this.appView.appInfo()).hasLiveness());
                    DexEncodedMethod target = invoke.lookupSingleTarget(this.appView.withLiveness(), context);
                    if (target == null || target.getOptimizationInfo().mayHaveSideEffects() || !target.getOptimizationInfo().returnValueOnlyDependsOnArguments() || !MemberRebindingAnalysis.isMemberVisibleFromOriginalContext(this.appView, context, target.method.holder, target.accessFlags) || instruction.isInvokeMethodWithReceiver() && ((Value)(receiver = instruction.asInvokeMethodWithReceiver().getReceiver().getAliasedValue())).getTypeLattice().isNullable()) continue;
                }
                boolean invocationCanBeMovedToEntryBlock = true;
                receiver = instruction.inValues().iterator();
                while (receiver.hasNext()) {
                    Value in = receiver.next();
                    if (!in.isPhi() && in.definition.isConstInstruction() && in.definition.getBlock().getNumber() == 0) continue;
                    invocationCanBeMovedToEntryBlock = false;
                    break;
                }
                if (!invocationCanBeMovedToEntryBlock) continue;
                List oldReturnValues = returnValues.computeIfAbsent(invoke, k -> new ArrayList());
                oldReturnValues.add(instruction.outValue());
            }
        }
        if (returnValues.isEmpty()) {
            return;
        }
        assert (!code.entryBlock().hasCatchHandlers());
        HashMap deadInvocations = Maps.newHashMap();
        ObjectSortedSet entries = returnValues.object2ObjectEntrySet();
        if (Log.ENABLED && Log.isLoggingEnabledFor(IdempotentFunctionCallCanonicalizer.class)) {
            Long numOfCandidates = entries.stream().filter(a -> ((List)a.getValue()).size() > 1).count();
            Object2IntMap<Long> object2IntMap = this.histogramOfCanonicalizationCandidatesPerMethod;
            synchronized (object2IntMap) {
                int count = this.histogramOfCanonicalizationCandidatesPerMethod.getOrDefault(numOfCandidates, 0);
                this.histogramOfCanonicalizationCandidatesPerMethod.put(numOfCandidates, count + 1);
            }
        }
        entries.stream().filter(a -> ((List)a.getValue()).size() > 1).sorted((a, b) -> Integer.compare(((List)b.getValue()).size(), ((List)a.getValue()).size())).limit(15L).forEach(entry -> {
            InvokeMethod invoke = (InvokeMethod)entry.getKey();
            if (Log.ENABLED) {
                if (this.factory.libraryMethodsWithReturnValueDependingOnlyOnArguments.contains(invoke.getInvokedMethod())) {
                    this.numberOfLibraryCallCanonicalization += ((List)entry.getValue()).size() - 1;
                } else {
                    this.numberOfProgramCallCanonicalization += ((List)entry.getValue()).size() - 1;
                }
            }
            Value canonicalizedValue = code.createValue(invoke.outValue().getTypeLattice(), invoke.outValue().getLocalInfo());
            Invoke canonicalizedInvoke = Invoke.create(invoke.getType(), invoke.getInvokedMethod(), null, canonicalizedValue, invoke.inValues());
            Position firstInvocationPosition = ((Value)((List)entry.getValue()).get((int)0)).definition.getPosition();
            canonicalizedInvoke.setPosition(firstInvocationPosition);
            if (invoke.inValues().size() > 0) {
                IdempotentFunctionCallCanonicalizer.insertCanonicalizedInvokeWithInValues(code, canonicalizedInvoke);
            } else {
                IdempotentFunctionCallCanonicalizer.insertCanonicalizedInvokeWithoutInValues(code, canonicalizedInvoke);
            }
            for (Value oldOutValue : (List)entry.getValue()) {
                deadInvocations.put(oldOutValue.definition.asInvokeMethod(), canonicalizedValue);
            }
        });
        if (!deadInvocations.isEmpty()) {
            for (BasicBlock basicBlock : code.blocks) {
                InstructionListIterator it = basicBlock.listIterator(code);
                while (it.hasNext()) {
                    InvokeMethod invoke;
                    Instruction current = (Instruction)it.next();
                    if (!current.isInvokeMethod() || !deadInvocations.containsKey(invoke = current.asInvokeMethod())) continue;
                    Value newOutValue = (Value)deadInvocations.get(invoke);
                    assert (newOutValue != null);
                    invoke.outValue().replaceUsers(newOutValue);
                    it.removeOrReplaceByDebugLocalRead();
                }
            }
        }
        code.removeAllTrivialPhis();
        assert (code.isConsistentSSA());
    }

    private boolean isIdempotentLibraryMethodInvoke(InvokeMethod invoke) {
        DexMethod invokedMethod = invoke.getInvokedMethod();
        Predicate<InvokeMethod> noSideEffectPredicate = this.factory.libraryMethodsWithoutSideEffects.get(invokedMethod);
        if (noSideEffectPredicate == null || !noSideEffectPredicate.test(invoke)) {
            return false;
        }
        return this.factory.libraryMethodsWithReturnValueDependingOnlyOnArguments.contains(invokedMethod);
    }

    private static void insertCanonicalizedInvokeWithInValues(IRCode code, Invoke canonicalizedInvoke) {
        BasicBlock entryBlock = code.entryBlock();
        int numberOfInValuePassed = 0;
        InstructionListIterator it = entryBlock.listIterator(code);
        while (it.hasNext()) {
            Instruction current = (Instruction)it.next();
            if (current.hasOutValue() && canonicalizedInvoke.inValues().contains(current.outValue())) {
                ++numberOfInValuePassed;
            }
            if (numberOfInValuePassed != canonicalizedInvoke.inValues().size()) continue;
            if (!it.hasNext() || !it.peekNext().isArgument()) break;
            it.nextUntil(instr -> !instr.isArgument());
            break;
        }
        it.add(canonicalizedInvoke);
    }

    private static void insertCanonicalizedInvokeWithoutInValues(IRCode code, Invoke canonicalizedInvoke) {
        BasicBlock entryBlock = code.entryBlock();
        InstructionListIterator it = entryBlock.listIterator(code);
        while (it.hasNext()) {
            if (((Instruction)it.next()).isArgument()) continue;
            it.previous();
            break;
        }
        it.add(canonicalizedInvoke);
    }
}

