/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.NestMemberClassAttribute;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class NestReducer {
    private AppView<?> appView;

    public NestReducer(AppView<?> appView) {
        this.appView = appView;
    }

    private DexClass definitionFor(DexType type) {
        assert (this.appView.graphLense().lookupType(type) == type);
        return this.appView.definitionFor(this.appView.graphLense().lookupType(type));
    }

    public void run(ExecutorService executorService) throws ExecutionException {
        Set<DexType> nestHosts = Sets.newIdentityHashSet();
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classes()) {
            DexType hostType = clazz.getNestHost();
            if (hostType == null || nestHosts.contains(hostType)) continue;
            nestHosts.add(hostType);
            futures.add(executorService.submit(() -> {
                this.processNestFrom(clazz);
                return null;
            }));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private void processNestFrom(DexClass clazz) {
        DexClass nestHost = this.definitionFor(clazz.getNestHost());
        if (nestHost == null) {
            this.reportMissingNestHost(clazz);
            clazz.clearNestHost();
            return;
        }
        boolean hasPrivateMembers = this.hasPrivateMembers(nestHost);
        Iterator<NestMemberClassAttribute> iterator2 = nestHost.getNestMembersClassAttributes().iterator();
        boolean reported = false;
        while (iterator2.hasNext()) {
            DexClass member = this.definitionFor(iterator2.next().getNestMember());
            if (member == null) {
                if (!reported) {
                    reported = true;
                    this.reportIncompleteNest(nestHost);
                }
                iterator2.remove();
                continue;
            }
            hasPrivateMembers = hasPrivateMembers || this.hasPrivateMembers(member);
        }
        if (!hasPrivateMembers && this.appView.options().enableNestReduction) {
            this.clearNestAttributes(nestHost);
        }
    }

    private void reportMissingNestHost(DexClass clazz) {
        if (this.appView.options().ignoreMissingClasses) {
            this.appView.options().warningMissingClassMissingNestHost(clazz);
        } else {
            this.appView.options().errorMissingClassMissingNestHost(clazz);
        }
    }

    private void reportIncompleteNest(DexClass nestHost) {
        ArrayList<DexType> nest = new ArrayList<DexType>(nestHost.getNestMembersClassAttributes().size() + 1);
        for (NestMemberClassAttribute attr : nestHost.getNestMembersClassAttributes()) {
            nest.add(attr.getNestMember());
        }
        nest.add(nestHost.type);
        if (this.appView.options().ignoreMissingClasses) {
            this.appView.options().warningMissingClassIncompleteNest(nest, this.appView);
        } else {
            this.appView.options().errorMissingClassIncompleteNest(nest, this.appView);
        }
    }

    private void clearNestAttributes(DexClass nestHost) {
        nestHost.getNestMembersClassAttributes().clear();
        for (NestMemberClassAttribute attr : nestHost.getNestMembersClassAttributes()) {
            DexClass member = this.appView.definitionFor(this.appView.graphLense().lookupType(attr.getNestMember()));
            member.clearNestHost();
        }
    }

    private boolean hasPrivateMembers(DexClass clazz) {
        for (DexEncodedMethod method : clazz.methods()) {
            if (!method.accessFlags.isPrivate()) continue;
            return true;
        }
        for (DexEncodedField field : clazz.fields()) {
            if (!field.accessFlags.isPrivate()) continue;
            return true;
        }
        return false;
    }
}

