/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.CheckCast;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.CaptureSignature;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.CodeProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaMerger;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroup;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;

final class KotlinLambdaGroupCodeStrategy
implements CodeProcessor.Strategy {
    private final KotlinLambdaGroup group;

    KotlinLambdaGroupCodeStrategy(KotlinLambdaGroup group) {
        this.group = group;
    }

    @Override
    public LambdaGroup group() {
        return this.group;
    }

    @Override
    public boolean isValidStaticFieldWrite(CodeProcessor context, DexField field) {
        DexType lambda2 = field.holder;
        assert (this.group.containsLambda(lambda2));
        return field.name == context.kotlin.functional.kotlinStyleLambdaInstanceName && lambda2 == field.type && context.factory.isClassConstructor(context.method.method) && context.method.method.holder == lambda2;
    }

    @Override
    public boolean isValidStaticFieldRead(CodeProcessor context, DexField field) {
        DexType lambda2 = field.holder;
        assert (this.group.containsLambda(lambda2));
        return field.name == context.kotlin.functional.kotlinStyleLambdaInstanceName && lambda2 == field.type;
    }

    @Override
    public boolean isValidInstanceFieldWrite(CodeProcessor context, DexField field) {
        DexType lambda2 = field.holder;
        DexMethod method = context.method.method;
        assert (this.group.containsLambda(lambda2));
        return method.holder == lambda2 && context.factory.isConstructor(method);
    }

    @Override
    public boolean isValidInstanceFieldRead(CodeProcessor context, DexField field) {
        assert (this.group.containsLambda(field.holder));
        return true;
    }

    @Override
    public boolean isValidNewInstance(CodeProcessor context, NewInstance invoke) {
        return !this.group.isStateless() || !this.group.isSingletonLambda(invoke.clazz);
    }

    @Override
    public boolean isValidInvoke(CodeProcessor context, InvokeMethod invoke) {
        return this.isValidInitializerCall(context, invoke) || this.isValidVirtualCall(invoke);
    }

    private boolean isValidInitializerCall(CodeProcessor context, InvokeMethod invoke) {
        DexMethod method = invoke.getInvokedMethod();
        DexType lambda2 = method.holder;
        assert (this.group.containsLambda(lambda2));
        boolean isSingletonLambda = this.group.isStateless() && this.group.isSingletonLambda(lambda2);
        return isSingletonLambda == (context.method.method.holder == lambda2) && invoke.isInvokeDirect() && context.factory.isConstructor(method) && CaptureSignature.getCaptureSignature(method.proto.parameters).equals(this.group.id().capture);
    }

    private boolean isValidVirtualCall(InvokeMethod invoke) {
        assert (this.group.containsLambda(invoke.getInvokedMethod().holder));
        return invoke.isInvokeVirtual();
    }

    @Override
    public void patch(LambdaMerger.ApplyStrategy context, NewInstance newInstance) {
        DexType oldType = newInstance.clazz;
        DexType newType = this.group.getGroupClassType();
        NewInstance patchedNewInstance = new NewInstance(newType, context.code.createValue(TypeLatticeElement.fromDexType(newType, Nullability.definitelyNotNull(), context.appView)));
        context.instructions().replaceCurrentInstruction(patchedNewInstance);
        assert (newType != oldType);
        context.recordTypeHasChanged(patchedNewInstance.outValue());
    }

    @Override
    public void patch(LambdaMerger.ApplyStrategy context, InvokeMethod invoke) {
        assert (this.group.containsLambda(invoke.getInvokedMethod().holder));
        if (this.isValidInitializerCall(context, invoke)) {
            this.patchInitializer(context, invoke.asInvokeDirect());
        } else {
            assert (this.isValidVirtualCall(invoke));
            DexMethod oldMethod = invoke.getInvokedMethod();
            DexMethod newMethod = this.mapVirtualMethod(context.factory, oldMethod);
            InvokeVirtual patchedInvokeVirtual = new InvokeVirtual(newMethod, this.createValueForType(context, newMethod.proto.returnType), invoke.arguments());
            context.instructions().replaceCurrentInstruction(patchedInvokeVirtual);
            assert (newMethod.proto.returnType == oldMethod.proto.returnType);
        }
    }

    @Override
    public void patch(LambdaMerger.ApplyStrategy context, InstanceGet instanceGet) {
        DexField oldField = instanceGet.getField();
        DexField newField = this.mapCaptureField(context.factory, oldField.holder, oldField);
        DexType oldFieldType = oldField.type;
        DexType newFieldType = newField.type;
        InstanceGet newInstanceGet = new InstanceGet(this.createValueForType(context, newFieldType), instanceGet.object(), newField);
        context.instructions().replaceCurrentInstruction(newInstanceGet);
        if (oldFieldType.isPrimitiveType() || oldFieldType == context.factory.objectType) {
            return;
        }
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(oldFieldType, Nullability.maybeNull(), context.appView);
        Value newValue = context.code.createValue(castTypeLattice, newInstanceGet.getLocalInfo());
        newInstanceGet.outValue().replaceUsers(newValue);
        CheckCast cast = new CheckCast(newValue, newInstanceGet.outValue(), oldFieldType);
        cast.setPosition(newInstanceGet.getPosition());
        context.instructions().add(cast);
        if (cast.getBlock().hasCatchHandlers()) {
            context.instructions().previous();
            context.instructions().split(context.code, 1, context.blocks);
        }
    }

    @Override
    public void patch(LambdaMerger.ApplyStrategy context, StaticGet staticGet) {
        DexField oldField = staticGet.getField();
        DexField newField = this.mapSingletonInstanceField(context.factory, oldField);
        StaticGet patchedStaticGet = new StaticGet(context.code.createValue(TypeLatticeElement.fromDexType(newField.type, Nullability.maybeNull(), context.appView)), newField);
        context.instructions().replaceCurrentInstruction(patchedStaticGet);
        assert (newField.type != oldField.type);
        context.recordTypeHasChanged(patchedStaticGet.outValue());
    }

    private void patchInitializer(CodeProcessor context, InvokeDirect invoke) {
        DexMethod method = invoke.getInvokedMethod();
        DexType lambda2 = method.holder;
        Value lambdaIdValue = context.code.createValue(TypeLatticeElement.INT);
        ConstNumber lambdaId = new ConstNumber(lambdaIdValue, this.group.lambdaId(lambda2));
        lambdaId.setPosition(invoke.getPosition());
        context.instructions().previous();
        context.instructions().add(lambdaId);
        Instruction next = (Instruction)context.instructions().next();
        assert (next == invoke);
        DexMethod newTarget = this.mapInitializerMethod(context.factory, method);
        List<Value> newArguments = this.mapInitializerArgs(lambdaIdValue, invoke.arguments(), method.proto);
        context.instructions().replaceCurrentInstruction(new InvokeDirect(newTarget, null, newArguments));
    }

    private Value createValueForType(CodeProcessor context, DexType returnType) {
        return returnType == context.factory.voidType ? null : context.code.createValue(TypeLatticeElement.fromDexType(returnType, Nullability.maybeNull(), context.appView));
    }

    private List<Value> mapInitializerArgs(Value lambdaIdValue, List<Value> oldArguments, DexProto proto) {
        assert (oldArguments.size() == proto.parameters.size() + 1);
        ArrayList<Value> newArguments = new ArrayList<Value>();
        newArguments.add(oldArguments.get(0));
        newArguments.add(lambdaIdValue);
        IntList reverseMapping = CaptureSignature.getReverseCaptureMapping(proto.parameters.values);
        Iterator iterator2 = reverseMapping.iterator();
        while (iterator2.hasNext()) {
            int index = (Integer)iterator2.next();
            newArguments.add(oldArguments.get(index + 1));
        }
        return newArguments;
    }

    private DexMethod mapInitializerMethod(DexItemFactory factory, DexMethod method) {
        assert (factory.isConstructor(method));
        assert (CaptureSignature.getCaptureSignature(method.proto.parameters).equals(this.group.id().capture));
        return factory.createMethod(this.group.getGroupClassType(), this.group.createConstructorProto(factory), method.name);
    }

    private DexMethod mapVirtualMethod(DexItemFactory factory, DexMethod method) {
        return factory.createMethod(this.group.getGroupClassType(), method.proto, method.name);
    }

    private DexField mapCaptureField(DexItemFactory factory, DexType lambda2, DexField field) {
        return this.group.getCaptureField(factory, this.group.mapFieldIntoCaptureIndex(lambda2, field));
    }

    private DexField mapSingletonInstanceField(DexItemFactory factory, DexField field) {
        return this.group.getSingletonInstanceField(factory, this.group.lambdaId(field.holder));
    }
}

