/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin;

import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.synthetic.SyntheticSourceCode;

final class KotlinLambdaVirtualMethodSourceCode
extends SyntheticSourceCode {
    private final DexItemFactory factory;
    private final DexField idField;
    private final List<DexEncodedMethod> implMethods;

    KotlinLambdaVirtualMethodSourceCode(DexItemFactory factory, DexType groupClass, DexMethod method, DexField idField, List<DexEncodedMethod> implMethods, Position callerPosition) {
        super(groupClass, method, callerPosition);
        this.factory = factory;
        this.idField = idField;
        this.implMethods = implMethods;
    }

    @Override
    protected void prepareInstructions() {
        int implMethodCount = this.implMethods.size();
        DexType returnType = this.proto.returnType;
        boolean returnsValue = returnType != this.factory.voidType;
        ValueType retValueType = returnsValue ? ValueType.fromDexType(returnType) : null;
        int retRegister = returnsValue ? this.nextRegister(retValueType) : -1;
        int idRegister = this.nextRegister(ValueType.INT);
        this.add(builder -> builder.addInstanceGet(idRegister, this.getReceiverRegister(), this.idField));
        int[] keys2 = new int[implMethodCount];
        int[] offsets = new int[implMethodCount];
        int[] fallthrough = new int[1];
        int switchIndex = this.lastInstructionIndex();
        this.add(builder -> builder.addSwitch(idRegister, keys2, fallthrough[0], offsets), builder -> this.endsSwitch((IRBuilder)builder, switchIndex, fallthrough[0], offsets));
        fallthrough[0] = this.nextInstructionIndex();
        int nullRegister = this.nextRegister(ValueType.OBJECT);
        this.add(builder -> builder.addNullConst(nullRegister));
        this.add(builder -> builder.addThrow(nullRegister), endsBlock);
        ArrayList arguments = new ArrayList(this.proto.parameters.values.length + 1);
        for (int i = 0; i < implMethodCount; ++i) {
            keys2[i] = i;
            DexEncodedMethod impl = this.implMethods.get(i);
            if (impl == null) {
                offsets[i] = fallthrough[0];
                continue;
            }
            offsets[i] = this.nextInstructionIndex();
            this.add(builder -> {
                if (arguments.isEmpty()) {
                    arguments.add(builder.getReceiverValue());
                    List<Value> argumentValues = builder.getArgumentValues();
                    if (argumentValues != null) {
                        arguments.addAll(builder.getArgumentValues());
                    }
                }
                builder.addInvoke(Invoke.Type.VIRTUAL, impl.method, impl.method.proto, arguments, false);
            });
            if (returnsValue) {
                this.add(builder -> builder.addMoveResult(retRegister));
                this.add(builder -> builder.addReturn(retRegister), endsBlock);
                continue;
            }
            this.add(IRBuilder::addReturn, endsBlock);
        }
    }
}

