/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Streams;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import shadow.bundletool.com.android.tools.r8.naming.IdentifierNameStringUtils;
import shadow.bundletool.com.android.tools.r8.naming.dexitembasedstring.ClassNameComputationInfo;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.TextPosition;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class IdentifierNameStringMarker {
    private final AppView<AppInfoWithLiveness> appView;
    private final Object2BooleanMap<DexReference> identifierNameStrings;
    private final BasicBlock.ThrowingInfo throwingInfo;

    public IdentifierNameStringMarker(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.identifierNameStrings = appView.appInfo().identifierNameStrings;
        this.throwingInfo = BasicBlock.ThrowingInfo.defaultForConstString(appView.options());
    }

    public void decoupleIdentifierNameStringsInFields(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), clazz -> {
            for (DexEncodedField field : clazz.staticFields()) {
                this.decoupleIdentifierNameStringInStaticField(field);
            }
        }, executorService);
    }

    private void decoupleIdentifierNameStringInStaticField(DexEncodedField encodedField) {
        assert (encodedField.accessFlags.isStatic());
        if (!this.identifierNameStrings.containsKey(encodedField.field)) {
            return;
        }
        DexValue staticValue = encodedField.getStaticValue();
        if (!(staticValue instanceof DexValue.DexValueString)) {
            return;
        }
        DexString original = (DexString)((DexValue.DexValueString)staticValue).getValue();
        DexReference itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appView, original);
        if (itemBasedString != null) {
            encodedField.setStaticValue(new DexValue.DexItemBasedValueString(itemBasedString, ClassNameComputationInfo.none()));
        }
    }

    public void decoupleIdentifierNameStringsInMethod(DexEncodedMethod method, IRCode code) {
        this.decoupleIdentifierNameStringsInBlocks(method, code, null);
    }

    public void decoupleIdentifierNameStringsInBlocks(DexEncodedMethod method, IRCode code, Set<BasicBlock> blocks) {
        if (!code.metadata().mayHaveConstString()) {
            return;
        }
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (blocks != null && !blocks.contains(block)) continue;
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Instruction instruction = (Instruction)iterator2.next();
                if (instruction.isStaticPut() || instruction.isInstancePut()) {
                    iterator2 = this.decoupleIdentifierNameStringForFieldPutInstruction(code, method, blockIterator, iterator2, instruction.asFieldInstruction());
                    continue;
                }
                if (!instruction.isInvokeMethod()) continue;
                iterator2 = this.decoupleIdentifierNameStringForInvokeInstruction(code, method, blockIterator, iterator2, instruction.asInvokeMethod());
            }
        }
    }

    private InstructionListIterator decoupleIdentifierNameStringForFieldPutInstruction(IRCode code, DexEncodedMethod method, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, FieldInstruction instruction) {
        BasicBlock blockWithFieldInstruction;
        assert (instruction.isInstancePut() || instruction.isStaticPut());
        FieldInstruction fieldPut = instruction.asFieldInstruction();
        DexField field = fieldPut.getField();
        if (!this.identifierNameStrings.containsKey(field)) {
            return iterator2;
        }
        Value in = instruction.value();
        if (!in.isConstString()) {
            this.warnUndeterminedIdentifierIfNecessary(field, method.method.holder, instruction, null);
            return iterator2;
        }
        DexString original = in.getConstInstruction().asConstString().getValue();
        DexReference itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appView, original);
        if (itemBasedString == null) {
            this.warnUndeterminedIdentifierIfNecessary(field, method.method.holder, instruction, original);
            return iterator2;
        }
        assert (iterator2.peekPrevious() == fieldPut);
        iterator2.previous();
        Value newIn = code.createValue(in.getTypeLattice(), in.getLocalInfo());
        DexItemBasedConstString decoupled = new DexItemBasedConstString(newIn, itemBasedString, ClassNameComputationInfo.none(), this.throwingInfo);
        decoupled.setPosition(fieldPut.getPosition());
        BasicBlock block = instruction.getBlock();
        BasicBlock basicBlock = blockWithFieldInstruction = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
        if (blockWithFieldInstruction != block) {
            iterator2 = block.listIterator(code, block.getInstructions().size() - 1);
            iterator2.add(decoupled);
            iterator2 = blockWithFieldInstruction.listIterator(code);
            assert (iterator2.peekNext() == fieldPut);
            iterator2.next();
        } else {
            iterator2.add(decoupled);
            assert (iterator2.peekNext() == fieldPut);
            iterator2.next();
        }
        if (instruction.isStaticPut()) {
            iterator2.replaceCurrentInstruction(new StaticPut(newIn, field));
        } else {
            assert (instruction.isInstancePut());
            InstancePut instancePut = instruction.asInstancePut();
            iterator2.replaceCurrentInstruction(new InstancePut(field, instancePut.object(), newIn));
        }
        return iterator2;
    }

    private InstructionListIterator decoupleIdentifierNameStringForInvokeInstruction(IRCode code, DexEncodedMethod method, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, InvokeMethod invoke) {
        DexMethod invokedMethod = invoke.getInvokedMethod();
        boolean isClassNameComparison = IdentifierNameStringUtils.isClassNameComparison(invoke, this.appView.dexItemFactory());
        if (!this.identifierNameStrings.containsKey(invokedMethod) && !isClassNameComparison) {
            return iterator2;
        }
        List<Value> ins = invoke.arguments();
        Value[] changes = new Value[ins.size()];
        if (IdentifierNameStringUtils.isReflectionMethod(this.appView.dexItemFactory(), invokedMethod) || isClassNameComparison) {
            DexReference itemBasedString = IdentifierNameStringUtils.identifyIdentifier(invoke, this.appView);
            if (itemBasedString == null) {
                DexType context = method.method.holder;
                this.warnUndeterminedIdentifierIfNecessary(invokedMethod, context, invoke, null);
                return iterator2;
            }
            int identifierPosition = this.getIdentifierPositionInArguments(invoke);
            assert (identifierPosition >= 0);
            Value in2 = invoke.arguments().get(identifierPosition);
            if (in2.definition.isDexItemBasedConstString()) {
                return iterator2;
            }
            Value newIn = code.createValue(in2.getTypeLattice(), in2.getLocalInfo());
            DexItemBasedConstString decoupled = new DexItemBasedConstString(newIn, itemBasedString, ClassNameComputationInfo.none(), this.throwingInfo);
            changes[identifierPosition] = newIn;
            if (in2.numberOfAllUsers() == 1) {
                ConstString constString = in2.definition.asConstString();
                if (constString.getBlock() == invoke.getBlock()) {
                    iterator2.previousUntil(instruction -> instruction == constString);
                    Instruction current = (Instruction)iterator2.next();
                    assert (current == constString);
                    iterator2.replaceCurrentInstruction(decoupled);
                    iterator2.nextUntil(instruction -> instruction == invoke);
                } else {
                    in2.definition.replace(decoupled, code);
                }
            } else {
                BasicBlock blockWithInvoke;
                decoupled.setPosition(invoke.getPosition());
                assert (iterator2.peekPrevious() == invoke);
                iterator2.previous();
                BasicBlock block = invoke.getBlock();
                BasicBlock basicBlock = blockWithInvoke = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                if (blockWithInvoke != block) {
                    iterator2 = block.listIterator(code, block.getInstructions().size());
                    iterator2.previous();
                    iterator2.add(decoupled);
                    iterator2 = blockWithInvoke.listIterator(code);
                    assert (iterator2.peekNext() == invoke);
                    iterator2.next();
                } else {
                    iterator2.add(decoupled);
                    assert (iterator2.peekNext() == invoke);
                    iterator2.next();
                }
            }
        } else {
            for (int i = 0; i < ins.size(); ++i) {
                BasicBlock blockWithInvoke;
                Value in3 = ins.get(i);
                if (!in3.isConstString()) {
                    this.warnUndeterminedIdentifierIfNecessary(invokedMethod, method.method.holder, invoke, null);
                    continue;
                }
                DexString original = in3.getConstInstruction().asConstString().getValue();
                DexReference itemBasedString = IdentifierNameStringUtils.inferMemberOrTypeFromNameString(this.appView, original);
                if (itemBasedString == null) {
                    this.warnUndeterminedIdentifierIfNecessary(invokedMethod, method.method.holder, invoke, original);
                    continue;
                }
                assert (iterator2.peekPrevious() == invoke);
                iterator2.previous();
                Value newIn = code.createValue(in3.getTypeLattice(), in3.getLocalInfo());
                DexItemBasedConstString decoupled = new DexItemBasedConstString(newIn, itemBasedString, ClassNameComputationInfo.none(), this.throwingInfo);
                decoupled.setPosition(invoke.getPosition());
                changes[i] = newIn;
                BasicBlock block = invoke.getBlock();
                BasicBlock basicBlock = blockWithInvoke = block.hasCatchHandlers() ? iterator2.split(code, blocks) : block;
                if (blockWithInvoke != block) {
                    iterator2 = block.listIterator(code, block.getInstructions().size());
                    iterator2.previous();
                    iterator2.add(decoupled);
                    iterator2 = blockWithInvoke.listIterator(code);
                    assert (iterator2.peekNext() == invoke);
                    iterator2.next();
                    continue;
                }
                iterator2.add(decoupled);
                assert (iterator2.peekNext() == invoke);
                iterator2.next();
            }
        }
        if (!Arrays.stream(changes).allMatch(Objects::isNull)) {
            List<Value> newIns = Streams.mapWithIndex(ins.stream(), (in, index) -> changes[(int)index] != null ? changes[(int)index] : in).collect(Collectors.toList());
            iterator2.replaceCurrentInstruction(Invoke.create(invoke.getType(), invokedMethod, invokedMethod.proto, invoke.outValue(), newIns));
        }
        return iterator2;
    }

    private int getIdentifierPositionInArguments(InvokeMethod invoke) {
        boolean isReferenceFieldUpdater;
        boolean isClassForName;
        DexType returnType = invoke.getReturnType();
        if (IdentifierNameStringUtils.isClassNameComparison(invoke, this.appView.dexItemFactory())) {
            return IdentifierNameStringUtils.getPositionOfFirstConstString(invoke);
        }
        boolean bl = isClassForName = returnType == this.appView.dexItemFactory().classType;
        if (isClassForName) {
            assert (this.appView.dexItemFactory().classMethods.isReflectiveClassLookup(invoke.getInvokedMethod()));
            return 0;
        }
        boolean bl2 = isReferenceFieldUpdater = returnType == this.appView.dexItemFactory().referenceFieldUpdaterType;
        if (isReferenceFieldUpdater) {
            assert (invoke.getInvokedMethod() == this.appView.dexItemFactory().atomicFieldUpdaterMethods.referenceUpdater);
            return 2;
        }
        return 1;
    }

    private void warnUndeterminedIdentifierIfNecessary(DexReference member, DexType originHolder, Instruction instruction, DexString original) {
        assert (member.isDexField() || member.isDexMethod());
        boolean matchedByExplicitRule = this.identifierNameStrings.getBoolean(member);
        if (!matchedByExplicitRule) {
            return;
        }
        DexClass originClass = this.appView.definitionFor(originHolder);
        if (originClass != null && originClass.isNotProgramClass()) {
            return;
        }
        if (!this.appView.options().isMinifying()) {
            return;
        }
        Origin origin = this.appView.appInfo().originFor(originHolder);
        String kind = member.isDexField() ? "field" : "method";
        String originalMessage = original == null ? "what identifier string flows to " : "what '" + original.toString() + "' refers to, which flows to ";
        String message = "Cannot determine " + originalMessage + member.toSourceString() + " that is specified in -identifiernamestring rules. Thus, not all identifier strings flowing to that " + kind + " are renamed, which can cause resolution failures at runtime.";
        StringDiagnostic diagnostic = instruction.getPosition().line >= 1 ? new StringDiagnostic(message, origin, new TextPosition(0L, instruction.getPosition().line, 1)) : new StringDiagnostic(message, origin);
        this.appView.options().reporter.warning(diagnostic);
    }
}

