/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayPut;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.CheckCast;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstantValueUtils;
import shadow.bundletool.com.android.tools.r8.ir.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.NewArrayEmpty;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public final class IdentifierNameStringUtils {
    public static boolean isReflectionMethod(DexItemFactory dexItemFactory, DexMethod method) {
        int arity = method.getArity();
        if (method.holder == dexItemFactory.classType) {
            if (arity == 0 || arity > 3) {
                return false;
            }
            if (arity == 1 ? method.proto.returnType != dexItemFactory.classType && method.proto.returnType != dexItemFactory.fieldType : (arity == 2 ? method.proto.returnType != dexItemFactory.methodType : method.proto.returnType != dexItemFactory.classType)) {
                return false;
            }
            if (method.proto.parameters.values[0] != dexItemFactory.stringType) {
                return false;
            }
            if (arity == 2 && method.proto.parameters.values[1] != dexItemFactory.classArrayType) {
                return false;
            }
            if (arity == 3 && method.proto.parameters.values[1] != dexItemFactory.booleanType && method.proto.parameters.values[2] != dexItemFactory.classLoaderType) {
                return false;
            }
        } else if (method.holder.descriptor == dexItemFactory.intFieldUpdaterDescriptor || method.holder.descriptor == dexItemFactory.longFieldUpdaterDescriptor) {
            if (arity != 2) {
                return false;
            }
            if (method.proto.returnType != method.holder) {
                return false;
            }
            if (method.proto.parameters.values[0] != dexItemFactory.classType) {
                return false;
            }
            if (method.proto.parameters.values[1] != dexItemFactory.stringType) {
                return false;
            }
        } else if (method.holder.descriptor == dexItemFactory.referenceFieldUpdaterDescriptor) {
            if (arity != 3) {
                return false;
            }
            if (method.proto.returnType != method.holder) {
                return false;
            }
            if (method.proto.parameters.values[0] != dexItemFactory.classType) {
                return false;
            }
            if (method.proto.parameters.values[1] != dexItemFactory.classType) {
                return false;
            }
            if (method.proto.parameters.values[2] != dexItemFactory.stringType) {
                return false;
            }
        } else {
            if (arity != 2 && arity != 3) {
                return false;
            }
            if (arity == 2 ? method.proto.returnType != dexItemFactory.fieldType : method.proto.returnType != dexItemFactory.methodType) {
                return false;
            }
            if (method.proto.parameters.values[0] != dexItemFactory.classType) {
                return false;
            }
            if (method.proto.parameters.values[1] != dexItemFactory.stringType) {
                return false;
            }
            if (arity == 3 && method.proto.parameters.values[2] != dexItemFactory.classArrayType) {
                return false;
            }
        }
        return true;
    }

    static boolean isClassNameComparison(InvokeMethod invoke, DexItemFactory dexItemFactory) {
        return invoke.isInvokeVirtual() && IdentifierNameStringUtils.isClassNameComparison(invoke.asInvokeVirtual(), dexItemFactory);
    }

    static boolean isClassNameComparison(InvokeVirtual invoke, DexItemFactory dexItemFactory) {
        return invoke.getInvokedMethod() == dexItemFactory.stringMethods.equals && (IdentifierNameStringUtils.isClassNameValue(invoke.getReceiver(), dexItemFactory) || IdentifierNameStringUtils.isClassNameValue(invoke.inValues().get(1), dexItemFactory));
    }

    private static boolean isClassNameValue(Value value, DexItemFactory dexItemFactory) {
        Value root = value.getAliasedValue();
        return !root.isPhi() && root.definition.isInvokeVirtual() && root.definition.asInvokeVirtual().getInvokedMethod() == dexItemFactory.classMethods.getName;
    }

    public static DexReference identifyIdentifier(InvokeMethod invoke, DexDefinitionSupplier definitions) {
        int argumentIndex;
        InvokeVirtual invokeVirtual;
        InvokeStatic invokeStatic;
        List<Value> ins = invoke.arguments();
        if (invoke.isInvokeStatic() && definitions.dexItemFactory().classMethods.isReflectiveClassLookup((invokeStatic = invoke.asInvokeStatic()).getInvokedMethod())) {
            return ConstantValueUtils.getDexTypeFromClassForName(invokeStatic, definitions);
        }
        if (invoke.isInvokeVirtual() && IdentifierNameStringUtils.isClassNameComparison(invokeVirtual = invoke.asInvokeVirtual(), definitions.dexItemFactory()) && (argumentIndex = IdentifierNameStringUtils.getPositionOfFirstConstString(invokeVirtual)) >= 0) {
            return IdentifierNameStringUtils.inferTypeFromConstStringValue(definitions, invokeVirtual.inValues().get(argumentIndex));
        }
        if (ins.size() == 1) {
            return null;
        }
        boolean isReferenceFieldUpdater = invoke.getReturnType().descriptor == definitions.dexItemFactory().referenceFieldUpdaterDescriptor;
        int positionOfIdentifier = isReferenceFieldUpdater ? 2 : 1;
        Value in = ins.get(positionOfIdentifier);
        if (in.isConstString()) {
            Value classValue = ins.get(0);
            if (!classValue.isConstClass()) {
                return null;
            }
            DexType holderType = classValue.getConstInstruction().asConstClass().getValue();
            if (holderType.isArrayType()) {
                return null;
            }
            DexClass holder = definitions.definitionFor(holderType);
            if (holder == null) {
                return null;
            }
            DexString dexString = in.getConstInstruction().asConstString().getValue();
            int numOfParams = ins.size();
            if (isReferenceFieldUpdater) {
                Value fieldTypeValue = ins.get(1);
                if (!fieldTypeValue.isConstClass()) {
                    return null;
                }
                DexType fieldType = fieldTypeValue.getConstInstruction().asConstClass().getValue();
                return IdentifierNameStringUtils.inferFieldInHolder(holder, dexString.toString(), fieldType);
            }
            if (numOfParams == 2) {
                return IdentifierNameStringUtils.inferFieldInHolder(holder, dexString.toString(), null);
            }
            assert (numOfParams == 3);
            DexTypeList arguments = IdentifierNameStringUtils.retrieveDexTypeListFromClassList(invoke, ins.get(2), definitions.dexItemFactory());
            if (arguments == null) {
                return null;
            }
            return IdentifierNameStringUtils.inferMethodInHolder(holder, dexString.toString(), arguments);
        }
        if (in.isDexItemBasedConstString()) {
            DexItemBasedConstString constString = in.getConstInstruction().asDexItemBasedConstString();
            return constString.getItem();
        }
        return null;
    }

    static int getPositionOfFirstConstString(Instruction instruction) {
        List<Value> inValues = instruction.inValues();
        for (int i = 0; i < inValues.size(); ++i) {
            Value value = inValues.get(i).getAliasedValue();
            if (!value.isConstString() && !value.isDexItemBasedConstString()) continue;
            return i;
        }
        return -1;
    }

    static DexReference inferMemberOrTypeFromNameString(DexDefinitionSupplier definitions, DexString dexString) {
        DexReference itemBasedString = IdentifierNameStringUtils.inferMemberFromNameString(definitions, dexString);
        if (itemBasedString == null) {
            return IdentifierNameStringUtils.inferTypeFromNameString(definitions, dexString);
        }
        return itemBasedString;
    }

    public static DexType inferTypeFromNameString(DexDefinitionSupplier definitions, DexString dexString) {
        String maybeDescriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(dexString.toString());
        if (maybeDescriptor != null) {
            return definitions.dexItemFactory().createType(maybeDescriptor);
        }
        return null;
    }

    public static DexType inferTypeFromConstStringValue(DexDefinitionSupplier definitions, Value value) {
        DexReference reference;
        Value root = value.getAliasedValue();
        assert (!root.isPhi());
        assert (root.isConstString() || root.isDexItemBasedConstString());
        if (root.isConstString()) {
            return IdentifierNameStringUtils.inferTypeFromNameString(definitions, root.definition.asConstString().getValue());
        }
        if (root.isDexItemBasedConstString() && (reference = root.definition.asDexItemBasedConstString().getItem()).isDexType()) {
            return reference.asDexType();
        }
        return null;
    }

    private static DexReference inferMemberFromNameString(DexDefinitionSupplier definitions, DexString dexString) {
        String identifier = dexString.toString();
        String typeIdentifier = null;
        String memberIdentifier = null;
        String[] items = identifier.split("#");
        if (items.length > 2) {
            return null;
        }
        if (items.length == 2) {
            typeIdentifier = items[0];
            memberIdentifier = items[1];
        } else {
            int lastDot = identifier.lastIndexOf(".");
            if (0 < lastDot && lastDot < identifier.length() - 1) {
                typeIdentifier = identifier.substring(0, lastDot);
                memberIdentifier = identifier.substring(lastDot + 1);
            }
        }
        if (typeIdentifier == null) {
            return null;
        }
        String maybeDescriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(typeIdentifier);
        if (maybeDescriptor == null) {
            return null;
        }
        DexType type = definitions.dexItemFactory().createType(maybeDescriptor);
        DexClass holder = definitions.definitionFor(type);
        if (holder == null) {
            return null;
        }
        DexReference itemBasedString = IdentifierNameStringUtils.inferFieldInHolder(holder, memberIdentifier, null);
        if (itemBasedString == null) {
            itemBasedString = IdentifierNameStringUtils.inferMethodNameInHolder(holder, memberIdentifier);
        }
        return itemBasedString;
    }

    private static DexReference inferFieldInHolder(DexClass holder, String name, DexType fieldType) {
        for (DexEncodedField encodedField : holder.fields()) {
            if (!encodedField.field.name.toString().equals(name) || fieldType != null && encodedField.field.type != fieldType) continue;
            return encodedField.field;
        }
        return null;
    }

    private static DexReference inferMethodNameInHolder(DexClass holder, String name) {
        for (DexEncodedMethod encodedMethod : holder.methods()) {
            if (!encodedMethod.method.name.toString().equals(name)) continue;
            return encodedMethod.method;
        }
        return null;
    }

    private static DexReference inferMethodInHolder(DexClass holder, String name, DexTypeList arguments) {
        assert (arguments != null);
        for (DexEncodedMethod encodedMethod : holder.methods()) {
            if (!encodedMethod.method.name.toString().equals(name) || !encodedMethod.method.proto.parameters.equals(arguments)) continue;
            return encodedMethod.method;
        }
        return null;
    }

    private static DexType getTypeFromConstClassOrBoxedPrimitive(Value value, DexItemFactory factory) {
        if (value.isPhi()) {
            return null;
        }
        if (value.isConstant() && value.getConstInstruction().isConstClass()) {
            return value.getConstInstruction().asConstClass().getValue();
        }
        if (value.definition.isStaticGet()) {
            return factory.primitiveTypesBoxedTypeFields.boxedFieldTypeToPrimitiveType(value.definition.asStaticGet().getField());
        }
        return null;
    }

    private static DexType[] evaluateTypeArrayContentFromConstructionToUse(NewArrayEmpty newArray, List<CheckCast> aliases, int size, Instruction user, DexItemFactory factory) {
        DexType[] values2 = new DexType[size];
        int remaining = size;
        Set<Instruction> users = Sets.newIdentityHashSet();
        users.addAll(newArray.outValue().uniqueUsers());
        for (CheckCast alias : aliases) {
            users.addAll(alias.outValue().uniqueUsers());
        }
        BasicBlock block = newArray.getBlock();
        InstructionIterator iterator2 = block.iterator();
        iterator2.nextUntil(i -> i == newArray);
        while (true) {
            if (iterator2.hasNext()) {
                Instruction instruction = (Instruction)iterator2.next();
                if (!users.contains(instruction)) continue;
                if (instruction == user) {
                    return remaining == 0 ? values2 : null;
                }
                if (!instruction.isArrayPut()) {
                    if (instruction.isCheckCast() && aliases.contains(instruction.asCheckCast())) continue;
                    values2 = new DexType[size];
                    remaining = size;
                    continue;
                }
                ArrayPut arrayPut = instruction.asArrayPut();
                if (!arrayPut.index().isConstNumber()) {
                    return null;
                }
                int index = arrayPut.index().getConstInstruction().asConstNumber().getIntValue();
                if (index < 0 || index >= values2.length) {
                    return null;
                }
                DexType type = IdentifierNameStringUtils.getTypeFromConstClassOrBoxedPrimitive(arrayPut.value(), factory);
                if (type == null) {
                    return null;
                }
                if (values2[index] == null) {
                    --remaining;
                }
                values2[index] = type;
                continue;
            }
            if (!block.exit().isGoto()) {
                return null;
            }
            if ((block = block.exit().asGoto().getTarget()).getPredecessors().size() != 1) {
                return null;
            }
            iterator2 = block.iterator();
            if (iterator2 == null) break;
        }
        return null;
    }

    private static DexTypeList retrieveDexTypeListFromClassList(InvokeMethod invoke, Value classListValue, DexItemFactory factory) {
        ArrayList<CheckCast> aliases = new ArrayList<CheckCast>();
        if (!classListValue.isPhi() && classListValue.definition.isCheckCast() && classListValue.definition.asCheckCast().getType() == factory.classArrayType) {
            while (!classListValue.isPhi() && classListValue.definition.isCheckCast()) {
                aliases.add(classListValue.definition.asCheckCast());
                classListValue = classListValue.definition.asCheckCast().object();
            }
        }
        if (classListValue.isPhi()) {
            return null;
        }
        if (classListValue.isZero()) {
            return DexTypeList.empty();
        }
        if (!classListValue.definition.isNewArrayEmpty() || !classListValue.definition.asNewArrayEmpty().size().isConstant()) {
            return null;
        }
        int size = classListValue.definition.asNewArrayEmpty().size().getConstInstruction().asConstNumber().getIntValue();
        if (size == 0) {
            return DexTypeList.empty();
        }
        DexType[] arrayContent = IdentifierNameStringUtils.evaluateTypeArrayContentFromConstructionToUse(classListValue.definition.asNewArrayEmpty(), aliases, size, invoke, factory);
        if (arrayContent == null) {
            return null;
        }
        return new DexTypeList(arrayContent);
    }
}

