/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceBase;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceBaseImpl;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceCommand;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceCommandLineResult;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceRegularExpression;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceStackTrace;
import shadow.bundletool.com.android.tools.r8.utils.OptionsParsing;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

@Keep
public class Retrace {
    public static final String USAGE_MESSAGE = StringUtils.lines("Usage: retrace <proguard-map> <stacktrace-file> [--regex <regexp>, --verbose, --info]", "  where <proguard-map> is an r8 generated mapping file.");

    private static RetraceCommand.Builder parseArguments(String[] args, DiagnosticsHandler diagnosticsHandler) {
        OptionsParsing.ParseContext context = new OptionsParsing.ParseContext(args);
        RetraceCommand.Builder builder = RetraceCommand.builder(diagnosticsHandler);
        boolean hasSetProguardMap = false;
        boolean hasSetStackTrace = false;
        while (context.head() != null) {
            Boolean help = OptionsParsing.tryParseBoolean(context, "--help");
            if (help != null) {
                return null;
            }
            Boolean info = OptionsParsing.tryParseBoolean(context, "--info");
            if (info != null) continue;
            Boolean verbose = OptionsParsing.tryParseBoolean(context, "--verbose");
            if (verbose != null) {
                builder.setVerbose(true);
                continue;
            }
            String regex = OptionsParsing.tryParseSingle(context, "--regex", "r");
            if (regex != null && !regex.isEmpty()) {
                builder.setRegularExpression(regex);
                continue;
            }
            if (!hasSetProguardMap) {
                builder.setProguardMapProducer(Retrace.getMappingSupplier(context.head(), diagnosticsHandler));
                context.next();
                hasSetProguardMap = true;
                continue;
            }
            if (!hasSetStackTrace) {
                builder.setStackTrace(Retrace.getStackTraceFromFile(context.head(), diagnosticsHandler));
                context.next();
                hasSetStackTrace = true;
                continue;
            }
            diagnosticsHandler.error(new StringDiagnostic(String.format("Too many arguments specified for builder at '%s'", context.head())));
            diagnosticsHandler.error(new StringDiagnostic(USAGE_MESSAGE));
            throw new RetraceAbortException();
        }
        if (!hasSetProguardMap) {
            diagnosticsHandler.error(new StringDiagnostic("Mapping file not specified"));
            throw new RetraceAbortException();
        }
        if (!hasSetStackTrace) {
            builder.setStackTrace(Retrace.getStackTraceFromStandardInput());
        }
        return builder;
    }

    private static RetraceCommand.ProguardMapProducer getMappingSupplier(String mappingPath, DiagnosticsHandler diagnosticsHandler) {
        Path path = Paths.get(mappingPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            diagnosticsHandler.error(new StringDiagnostic(String.format("Could not find mapping file '%s'.", mappingPath)));
            throw new RetraceAbortException();
        }
        return () -> new String(Files.readAllBytes(path));
    }

    private static List<String> getStackTraceFromFile(String stackTracePath, DiagnosticsHandler diagnostics) {
        try {
            return Files.readAllLines(Paths.get(stackTracePath, new String[0]));
        }
        catch (IOException e) {
            diagnostics.error(new StringDiagnostic("Could not find stack trace file: " + stackTracePath));
            throw new RetraceAbortException();
        }
    }

    public static void run(RetraceCommand command) {
        try {
            ClassNameMapper classNameMapper = ClassNameMapper.mapperFromString(command.proguardMapProducer.get());
            RetraceBase retraceBase = RetraceBaseImpl.create(classNameMapper);
            RetraceCommandLineResult result = command.regularExpression != null ? new RetraceRegularExpression(retraceBase, command.stackTrace, command.diagnosticsHandler, command.regularExpression).retrace() : new RetraceStackTrace(retraceBase, command.stackTrace, command.diagnosticsHandler, command.isVerbose).retrace();
            command.retracedStackTraceConsumer.accept(result.getNodes());
        }
        catch (IOException ex) {
            command.diagnosticsHandler.error(new StringDiagnostic("Could not open mapping input stream: " + ex.getMessage()));
            throw new RetraceAbortException();
        }
    }

    public static void run(String[] args) {
        RetraceDiagnosticsHandler retraceDiagnosticsHandler = new RetraceDiagnosticsHandler(new DiagnosticsHandler(){}, Arrays.asList(args).contains("--info"));
        RetraceCommand.Builder builder = Retrace.parseArguments(args, retraceDiagnosticsHandler);
        if (builder == null) {
            assert (Arrays.asList(args).contains("--help"));
            System.out.print(USAGE_MESSAGE);
            return;
        }
        builder.setRetracedStackTraceConsumer(retraced -> System.out.print(StringUtils.lines(retraced)));
        Retrace.run(builder.build());
    }

    public static void main(String ... args) {
        Retrace.withMainProgramHandler(() -> Retrace.run(args));
    }

    private static List<String> getStackTraceFromStandardInput() {
        Scanner sc = new Scanner(System.in);
        ArrayList<String> readLines2 = new ArrayList<String>();
        while (sc.hasNext()) {
            readLines2.add(sc.nextLine());
        }
        return readLines2;
    }

    private static void withMainProgramHandler(MainAction action) {
        try {
            action.run();
        }
        catch (RetraceAbortException e) {
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Retrace failed with an internal error.");
            Throwable cause = e.getCause() == null ? e : e.getCause();
            cause.printStackTrace();
            System.exit(1);
        }
    }

    private static class RetraceDiagnosticsHandler
    implements DiagnosticsHandler {
        private final DiagnosticsHandler diagnosticsHandler;
        private final boolean printInfo;

        public RetraceDiagnosticsHandler(DiagnosticsHandler diagnosticsHandler, boolean printInfo) {
            this.diagnosticsHandler = diagnosticsHandler;
            this.printInfo = printInfo;
            assert (diagnosticsHandler != null);
        }

        @Override
        public void error(Diagnostic error) {
            this.diagnosticsHandler.error(error);
        }

        @Override
        public void warning(Diagnostic warning) {
            this.diagnosticsHandler.warning(warning);
        }

        @Override
        public void info(Diagnostic info) {
            if (this.printInfo) {
                this.diagnosticsHandler.info(info);
            }
        }
    }

    private static interface MainAction {
        public void run() throws RetraceAbortException;
    }

    static class RetraceAbortException
    extends RuntimeException {
        RetraceAbortException() {
        }
    }
}

