/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.ScopedDexMethodSet;

public class AbstractMethodRemover {
    private final AppInfoWithLiveness appInfo;
    private ScopedDexMethodSet scope = new ScopedDexMethodSet();

    public AbstractMethodRemover(AppInfoWithLiveness appInfo) {
        this.appInfo = appInfo;
    }

    public void run() {
        assert (this.scope.getParent() == null);
        this.processClass(this.appInfo.dexItemFactory().objectType);
    }

    private void processClass(DexType type) {
        DexEncodedMethod[] newVirtualMethods;
        DexClass holder = this.appInfo.definitionFor(type);
        this.scope = this.scope.newNestedScope();
        if (holder != null && holder.isProgramClass() && (newVirtualMethods = this.processMethods(holder.virtualMethods())) != null) {
            holder.setVirtualMethods(newVirtualMethods);
        }
        this.appInfo.forAllImmediateExtendsSubtypes(type, this::processClass);
        this.scope = this.scope.getParent();
    }

    private DexEncodedMethod[] processMethods(List<DexEncodedMethod> virtualMethods) {
        if (virtualMethods == null) {
            return null;
        }
        ArrayList<DexEncodedMethod> methods = null;
        for (int i = 0; i < virtualMethods.size(); ++i) {
            DexEncodedMethod method = virtualMethods.get(i);
            if (this.scope.addMethodIfMoreVisible(method) != ScopedDexMethodSet.AddMethodIfMoreVisibleResult.NOT_ADDED || !method.accessFlags.isAbstract() || this.appInfo.isPinned(method.method)) {
                if (methods == null) continue;
                methods.add(method);
                continue;
            }
            if (methods == null) {
                methods = new ArrayList<DexEncodedMethod>(virtualMethods.size() - 1);
                for (int j = 0; j < i; ++j) {
                    methods.add(virtualMethods.get(j));
                }
            }
            if (!Log.ENABLED) continue;
            Log.debug(this.getClass(), "Removing abstract method %s.", method.method);
        }
        if (methods != null) {
            return methods.toArray(DexEncodedMethod.EMPTY_ARRAY);
        }
        return null;
    }
}

