/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationElement;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.InnerClassAttribute;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepAttributes;

public class AnnotationRemover {
    private final AppView<AppInfoWithLiveness> appView;
    private final ProguardKeepAttributes keep;
    private final Set<DexType> classesToRetainInnerClassAttributeFor;

    public AnnotationRemover(AppView<AppInfoWithLiveness> appView, Set<DexType> classesToRetainInnerClassAttributeFor) {
        this.appView = appView;
        this.keep = appView.options().getProguardConfiguration().getKeepAttributes();
        this.classesToRetainInnerClassAttributeFor = classesToRetainInnerClassAttributeFor;
    }

    private boolean filterAnnotations(DexDefinition holder, DexAnnotation annotation) {
        return AnnotationRemover.shouldKeepAnnotation(holder, annotation, this.isAnnotationTypeLive(annotation), this.appView);
    }

    static boolean shouldKeepAnnotation(DexDefinition holder, DexAnnotation annotation, boolean isAnnotationTypeLive, AppView<?> appView) {
        ProguardKeepAttributes config = appView.options().getProguardConfiguration() != null ? appView.options().getProguardConfiguration().getKeepAttributes() : ProguardKeepAttributes.fromPatterns(ImmutableList.of());
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        switch (annotation.visibility) {
            case 2: {
                assert (!DexAnnotation.isInnerClassAnnotation(annotation, dexItemFactory));
                assert (!DexAnnotation.isMemberClassesAnnotation(annotation, dexItemFactory));
                assert (!DexAnnotation.isEnclosingMethodAnnotation(annotation, dexItemFactory));
                assert (!DexAnnotation.isEnclosingClassAnnotation(annotation, dexItemFactory));
                if (config.exceptions && DexAnnotation.isThrowingAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                if (config.signature && DexAnnotation.isSignatureAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                if (DexAnnotation.isSourceDebugExtension(annotation, dexItemFactory)) {
                    assert (holder.isDexClass());
                    appView.setSourceDebugExtensionForType(holder.asDexClass(), annotation.annotation.elements[0].value.asDexValueString());
                    return config.sourceDebugExtension;
                }
                if (config.methodParameters && DexAnnotation.isParameterNameAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                return DexAnnotation.isAnnotationDefaultAnnotation(annotation, dexItemFactory);
            }
            case 1: {
                if (!config.runtimeVisibleAnnotations) {
                    return false;
                }
                return isAnnotationTypeLive;
            }
            case 0: {
                if (DexAnnotation.isSynthesizedClassMapAnnotation(annotation, dexItemFactory)) {
                    return true;
                }
                if (!config.runtimeInvisibleAnnotations) {
                    return false;
                }
                return isAnnotationTypeLive;
            }
        }
        throw new Unreachable("Unexpected annotation visibility.");
    }

    private boolean isAnnotationTypeLive(DexAnnotation annotation) {
        DexType annotationType = annotation.annotation.type.toBaseType(this.appView.dexItemFactory());
        return this.appView.appInfo().isNonProgramTypeOrLiveProgramType(annotationType);
    }

    private boolean filterParameterAnnotations(DexAnnotation annotation) {
        switch (annotation.visibility) {
            case 2: {
                return false;
            }
            case 1: {
                if (this.keep.runtimeVisibleParameterAnnotations) break;
                return false;
            }
            case 0: {
                if (this.keep.runtimeInvisibleParameterAnnotations) break;
                return false;
            }
            default: {
                throw new Unreachable("Unexpected annotation visibility.");
            }
        }
        return this.isAnnotationTypeLive(annotation);
    }

    public AnnotationRemover ensureValid() {
        this.keep.ensureValid(this.appView.options().forceProguardCompatibility);
        return this;
    }

    private static boolean hasGenericEnclosingClass(DexProgramClass clazz, Map<DexType, DexProgramClass> enclosingClasses, Set<DexProgramClass> genericClasses) {
        DexProgramClass enclosingClass;
        while ((enclosingClass = enclosingClasses.get(clazz.type)) != null) {
            if (genericClasses.contains(enclosingClass)) {
                return true;
            }
            clazz = enclosingClass;
        }
        return false;
    }

    private static boolean hasSignatureAnnotation(DexProgramClass clazz, DexItemFactory itemFactory) {
        for (DexAnnotation annotation : clazz.annotations.annotations) {
            if (!DexAnnotation.isSignatureAnnotation(annotation, itemFactory)) continue;
            return true;
        }
        return false;
    }

    public static Set<DexType> computeClassesToRetainInnerClassAttributeFor(AppView<? extends AppInfoWithLiveness> appView) {
        if (appView.options().forceProguardCompatibility || !appView.options().getProguardConfiguration().getKeepAttributes().innerClasses) {
            return Collections.emptySet();
        }
        IdentityHashMap<DexType, DexProgramClass> enclosingClasses = new IdentityHashMap<DexType, DexProgramClass>();
        Set<DexProgramClass> genericClasses = Sets.newIdentityHashSet();
        Iterable<DexProgramClass> programClasses = appView.appInfo().classes();
        for (DexProgramClass clazz : programClasses) {
            if (AnnotationRemover.hasSignatureAnnotation(clazz, appView.dexItemFactory())) {
                genericClasses.add(clazz);
            }
            for (InnerClassAttribute innerClassAttribute : clazz.getInnerClasses()) {
                if ((innerClassAttribute.getAccess() & 8) != 0 || innerClassAttribute.getOuter() != clazz.type) continue;
                enclosingClasses.put(innerClassAttribute.getInner(), clazz);
            }
        }
        Set<DexType> result = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : programClasses) {
            if (appView.appInfo().isPinned(clazz.type)) {
                for (InnerClassAttribute innerClassAttribute : clazz.getInnerClasses()) {
                    DexType context;
                    DexType inner = innerClassAttribute.getInner();
                    if (appView.appInfo().isNonProgramTypeOrLiveProgramType(inner)) {
                        result.add(inner);
                    }
                    if ((context = innerClassAttribute.getLiveContext(appView.appInfo())) == null || !appView.appInfo().isNonProgramTypeOrLiveProgramType(context)) continue;
                    result.add(context);
                }
            }
            if (clazz.getInnerClassAttributeForThisClass() == null || !appView.appInfo().isNonProgramTypeOrLiveProgramType(clazz.type) || !AnnotationRemover.hasGenericEnclosingClass(clazz, enclosingClasses, genericClasses)) continue;
            result.add(clazz.type);
        }
        return result;
    }

    public void run() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            this.stripAttributes(clazz);
            clazz.annotations = clazz.annotations.rewrite(annotation -> this.rewriteAnnotation(clazz, (DexAnnotation)annotation));
            clazz.forEachMethod(this::processMethod);
            clazz.forEachField(this::processField);
        }
    }

    private void processMethod(DexEncodedMethod method) {
        method.annotations = method.annotations.rewrite(annotation -> this.rewriteAnnotation(method, (DexAnnotation)annotation));
        method.parameterAnnotationsList = method.parameterAnnotationsList.keepIf(this::filterParameterAnnotations);
    }

    private void processField(DexEncodedField field) {
        field.annotations = field.annotations.rewrite(annotation -> this.rewriteAnnotation(field, (DexAnnotation)annotation));
    }

    private DexAnnotation rewriteAnnotation(DexDefinition holder, DexAnnotation original) {
        if (!this.filterAnnotations(holder, original)) {
            return null;
        }
        return original.rewrite(this::rewriteEncodedAnnotation);
    }

    private DexEncodedAnnotation rewriteEncodedAnnotation(DexEncodedAnnotation original) {
        GraphLense graphLense = this.appView.graphLense();
        DexType annotationType = original.type.toBaseType(this.appView.dexItemFactory());
        DexType rewrittenType = graphLense.lookupType(annotationType);
        DexEncodedAnnotation rewrite = original.rewrite(graphLense::lookupType, element -> this.rewriteAnnotationElement(rewrittenType, (DexAnnotationElement)element));
        assert (rewrite != null);
        DexClass annotationClass = this.appView.definitionFor(rewrittenType);
        assert (annotationClass == null || this.appView.appInfo().isNonProgramTypeOrLiveProgramType(rewrittenType));
        return rewrite;
    }

    private DexAnnotationElement rewriteAnnotationElement(DexType annotationType, DexAnnotationElement original) {
        DexClass definition = this.appView.definitionFor(annotationType);
        if (definition == null) {
            return original;
        }
        assert (definition.isInterface());
        boolean liveGetter = definition.virtualMethods().stream().anyMatch(method -> method.method.name == original.name);
        return liveGetter ? original : null;
    }

    private boolean enclosingMethodPinned(DexClass clazz) {
        return clazz.getEnclosingMethod() != null && clazz.getEnclosingMethod().getEnclosingClass() != null && this.appView.appInfo().isPinned(clazz.getEnclosingMethod().getEnclosingClass());
    }

    private static boolean hasInnerClassesFromSet(DexProgramClass clazz, Set<DexType> innerClasses) {
        for (InnerClassAttribute attr : clazz.getInnerClasses()) {
            if (attr.getOuter() != clazz.type || !innerClasses.contains(attr.getInner())) continue;
            return true;
        }
        return false;
    }

    private void stripAttributes(DexProgramClass clazz) {
        boolean keptAnyway = this.appView.appInfo().isPinned(clazz.type) || this.enclosingMethodPinned(clazz) || this.appView.options().forceProguardCompatibility;
        boolean keepForThisInnerClass = false;
        boolean keepForThisEnclosingClass = false;
        if (!keptAnyway) {
            keepForThisInnerClass = this.classesToRetainInnerClassAttributeFor.contains(clazz.type);
            keepForThisEnclosingClass = AnnotationRemover.hasInnerClassesFromSet(clazz, this.classesToRetainInnerClassAttributeFor);
        }
        if (keptAnyway || keepForThisInnerClass || keepForThisEnclosingClass) {
            if (!this.keep.enclosingMethod) {
                clazz.clearEnclosingMethod();
            }
            if (!this.keep.innerClasses) {
                clazz.clearInnerClasses();
            } else if (!keptAnyway) {
                boolean finalKeepForThisInnerClass = keepForThisInnerClass;
                boolean finalKeepForThisEnclosingClass = keepForThisEnclosingClass;
                clazz.removeInnerClasses(ica -> {
                    if (this.appView.appInfo().isPinned(ica.getInner())) {
                        return false;
                    }
                    if (this.appView.appInfo().isPinned(ica.getOuter())) {
                        return false;
                    }
                    if (finalKeepForThisInnerClass && ica.getInner() == clazz.type) {
                        return false;
                    }
                    return !finalKeepForThisEnclosingClass || ica.getOuter() != clazz.type || !this.classesToRetainInnerClassAttributeFor.contains(ica.getInner());
                });
            }
        } else {
            clazz.clearEnclosingMethod();
            clazz.clearInnerClasses();
        }
    }

    public static void clearAnnotations(AppView<?> appView) {
        for (DexProgramClass clazz : ((AppInfo)appView.appInfo()).classes()) {
            clazz.annotations = DexAnnotationSet.empty();
            for (DexEncodedMethod method : clazz.methods()) {
                method.annotations = DexAnnotationSet.empty();
            }
            for (DexEncodedField field : clazz.fields()) {
                field.annotations = DexAnnotationSet.empty();
            }
        }
    }
}

