/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Objects;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardIfRule;

public class IfRuleClassPartEquivalence
extends Equivalence<ProguardIfRule> {
    @Override
    protected boolean doEquivalent(ProguardIfRule p1, ProguardIfRule p2) {
        if (!Objects.equals(p1.getClassAnnotation(), p2.getClassAnnotation())) {
            return false;
        }
        if (!p1.getClassAccessFlags().equals(p2.getClassAccessFlags()) || !p1.getNegatedClassAccessFlags().equals(p2.getNegatedClassAccessFlags())) {
            return false;
        }
        if (p1.getClassType() != p2.getClassType() || p1.getClassTypeNegated() != p2.getClassTypeNegated()) {
            return false;
        }
        if (p1.getInheritanceIsExtends() != p2.getInheritanceIsExtends()) {
            return false;
        }
        if (!Objects.equals(p1.getInheritanceAnnotation(), p2.getInheritanceAnnotation())) {
            return false;
        }
        if (!Objects.equals(p1.getInheritanceClassName(), p2.getInheritanceClassName())) {
            return false;
        }
        return p1.getClassNames().equals(p2.getClassNames());
    }

    @Override
    protected int doHash(ProguardIfRule rule) {
        int result = rule.getClassAnnotation() != null ? rule.getClassAnnotation().hashCode() : 0;
        result = 3 * result + rule.getClassAccessFlags().hashCode();
        result = 3 * result + rule.getNegatedClassAccessFlags().hashCode();
        result = 3 * result + (rule.getClassTypeNegated() ? 1 : 0);
        result = 3 * result + (rule.getClassType() != null ? rule.getClassType().hashCode() : 0);
        result = 3 * result + rule.getClassNames().hashCode();
        result = 3 * result + (rule.getInheritanceAnnotation() != null ? rule.getInheritanceAnnotation().hashCode() : 0);
        result = 3 * result + (rule.getInheritanceClassName() != null ? rule.getInheritanceClassName().hashCode() : 0);
        result = 3 * result + (rule.getInheritanceIsImplements() ? 1 : 0);
        result = 3 * result + Iterables.size(rule.subsequentRule.getWildcards());
        return result;
    }
}

