/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.desugar.PrefixRewritingMapper;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class L8TreePruner {
    private final InternalOptions options;
    private final Set<DexType> emulatedInterfaces = Sets.newIdentityHashSet();
    private final Set<DexType> backports = Sets.newIdentityHashSet();
    private final List<DexType> pruned = new ArrayList<DexType>();

    public L8TreePruner(InternalOptions options) {
        this.options = options;
        this.backports.addAll(options.desugaredLibraryConfiguration.getBackportCoreLibraryMember().keySet());
        this.emulatedInterfaces.addAll(options.desugaredLibraryConfiguration.getEmulateLibraryInterface().keySet());
    }

    public DexApplication prune(DexApplication app, PrefixRewritingMapper rewritePrefix) {
        IdentityHashMap<DexType, DexProgramClass> typeMap = new IdentityHashMap<DexType, DexProgramClass>();
        for (DexProgramClass aClass : app.classes()) {
            typeMap.put(aClass.type, aClass);
        }
        ArrayList<DexProgramClass> toKeep = new ArrayList<DexProgramClass>();
        for (DexProgramClass aClass : app.classes()) {
            if (rewritePrefix.hasRewrittenType(aClass.type) || this.emulatedInterfaces.contains(aClass.type) || this.interfaceImplementsEmulatedInterface(aClass, typeMap)) {
                toKeep.add(aClass);
                continue;
            }
            this.pruned.add(aClass.type);
        }
        typeMap.clear();
        return ((DexApplication.Builder)app.builder().replaceProgramClasses(toKeep)).build();
    }

    private boolean interfaceImplementsEmulatedInterface(DexClass itf, Map<DexType, DexProgramClass> typeMap) {
        if (!itf.isInterface()) {
            return false;
        }
        LinkedList workList = new LinkedList();
        Collections.addAll(workList, itf.interfaces.values);
        while (!workList.isEmpty()) {
            DexType dexType = (DexType)workList.removeFirst();
            if (this.emulatedInterfaces.contains(dexType)) {
                return true;
            }
            if (!typeMap.containsKey(dexType)) continue;
            DexProgramClass dexProgramClass = typeMap.get(dexType);
            Collections.addAll(workList, dexProgramClass.interfaces.values);
        }
        return false;
    }
}

