/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.EnclosingMethodAttribute;
import shadow.bundletool.com.android.tools.r8.graph.InnerClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.KeyedDexItem;
import shadow.bundletool.com.android.tools.r8.graph.NestMemberClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.PresortedComparable;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.DefaultTreePrunerConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.TreePrunerConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.UsagePrinter;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionUtils;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class TreePruner {
    private final AppView<AppInfoWithLiveness> appView;
    private final TreePrunerConfiguration configuration;
    private final UsagePrinter usagePrinter;
    private final Set<DexType> prunedTypes = Sets.newIdentityHashSet();
    private final Set<DexMethod> methodsToKeepForConfigurationDebugging = Sets.newIdentityHashSet();

    public TreePruner(AppView<AppInfoWithLiveness> appView) {
        this(appView, DefaultTreePrunerConfiguration.getInstance());
    }

    public TreePruner(AppView<AppInfoWithLiveness> appView, TreePrunerConfiguration configuration) {
        InternalOptions options = appView.options();
        this.appView = appView;
        this.configuration = configuration;
        this.usagePrinter = options.hasUsageInformationConsumer() ? new UsagePrinter(s -> ExceptionUtils.withConsumeResourceHandler(options.reporter, options.usageInformationConsumer, s)) : UsagePrinter.DONT_PRINT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexApplication run(DexApplication application) {
        DexApplication result;
        Timing timing = application.timing;
        timing.begin("Pruning application...");
        try {
            result = this.removeUnused(application).build();
        }
        finally {
            timing.end();
        }
        return result;
    }

    private DexApplication.Builder<?> removeUnused(DexApplication application) {
        return application.builder().replaceProgramClasses(this.getNewProgramClasses(application.classes()));
    }

    private List<DexProgramClass> getNewProgramClasses(List<DexProgramClass> classes) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        InternalOptions options = this.appView.options();
        ArrayList<DexProgramClass> newClasses = new ArrayList<DexProgramClass>();
        for (DexProgramClass clazz : classes) {
            if (options.configurationDebugging) {
                newClasses.add(clazz);
                this.pruneMembersAndAttributes(clazz);
                continue;
            }
            if (appInfo.isLiveProgramClass(clazz)) {
                newClasses.add(clazz);
                if (!appInfo.instantiatedTypes.contains(clazz.type) && !options.forceProguardCompatibility) {
                    if (clazz.accessFlags.isFinal()) {
                        clazz.accessFlags.demoteFromFinal();
                    }
                    clazz.accessFlags.setAbstract();
                }
                this.pruneUnusedInterfaces(clazz);
                this.pruneMembersAndAttributes(clazz);
                continue;
            }
            if (Log.ENABLED) {
                Log.debug(this.getClass(), "Removing class: " + clazz, new Object[0]);
            }
            this.prunedTypes.add(clazz.type);
            this.usagePrinter.printUnusedClass(clazz);
        }
        return newClasses;
    }

    private void pruneUnusedInterfaces(DexProgramClass clazz) {
        boolean implementsUnusedInterfaces = false;
        for (DexType type : clazz.interfaces.values) {
            if (this.isTypeLive(type)) continue;
            implementsUnusedInterfaces = true;
            break;
        }
        if (!implementsUnusedInterfaces) {
            return;
        }
        LinkedHashSet<DexType> reachableInterfaces = new LinkedHashSet<DexType>();
        for (DexType type : clazz.interfaces.values) {
            this.retainReachableInterfacesFrom(type, reachableInterfaces);
        }
        clazz.interfaces = reachableInterfaces.isEmpty() ? DexTypeList.empty() : new DexTypeList(reachableInterfaces.toArray(DexType.EMPTY_ARRAY));
    }

    private void retainReachableInterfacesFrom(DexType type, Set<DexType> reachableInterfaces) {
        if (this.isTypeLive(type)) {
            reachableInterfaces.add(type);
        } else {
            DexProgramClass unusedInterface = this.appView.definitionForProgramType(type);
            assert (unusedInterface != null);
            assert (unusedInterface.isInterface());
            for (DexType interfaceType : unusedInterface.interfaces.values) {
                this.retainReachableInterfacesFrom(interfaceType, reachableInterfaces);
            }
        }
    }

    private void pruneMembersAndAttributes(DexProgramClass clazz) {
        DexEncodedField[] reachableStaticFields;
        DexEncodedField[] reachableInstanceFields;
        DexEncodedMethod[] reachableVirtualMethods;
        this.usagePrinter.visiting(clazz);
        DexEncodedMethod[] reachableDirectMethods = this.reachableMethods(clazz.directMethods(), clazz);
        if (reachableDirectMethods != null) {
            clazz.setDirectMethods(reachableDirectMethods);
        }
        if ((reachableVirtualMethods = this.reachableMethods(clazz.virtualMethods(), clazz)) != null) {
            clazz.setVirtualMethods(reachableVirtualMethods);
        }
        if ((reachableInstanceFields = this.reachableFields(clazz.instanceFields())) != null) {
            clazz.setInstanceFields(reachableInstanceFields);
        }
        if ((reachableStaticFields = this.reachableFields(clazz.staticFields())) != null) {
            clazz.setStaticFields(reachableStaticFields);
        }
        clazz.removeInnerClasses(this::isAttributeReferencingPrunedType);
        clazz.removeEnclosingMethod(this::isAttributeReferencingPrunedItem);
        this.rewriteNestAttributes(clazz);
        this.usagePrinter.visited();
    }

    private void rewriteNestAttributes(DexProgramClass clazz) {
        if (!clazz.isInANest() || !this.isTypeLive(clazz.type)) {
            return;
        }
        if (clazz.isNestHost()) {
            this.clearDeadNestMembers(clazz);
        } else {
            assert (clazz.isNestMember());
            if (!this.isTypeLive(clazz.getNestHost())) {
                this.claimNestOwnership(clazz);
            }
        }
    }

    private boolean isTypeLive(DexType type) {
        return this.appView.appInfo().isNonProgramTypeOrLiveProgramType(type);
    }

    private void clearDeadNestMembers(DexClass nestHost) {
        nestHost.getNestMembersClassAttributes().removeIf(nestMemberAttr -> this.appView.definitionFor(nestMemberAttr.getNestMember()) != null && !this.isTypeLive(nestMemberAttr.getNestMember()));
    }

    private void claimNestOwnership(DexClass newHost) {
        DexClass previousHost = this.appView.definitionFor(newHost.getNestHost());
        if (previousHost == null) {
            return;
        }
        newHost.clearNestHost();
        for (NestMemberClassAttribute attr : previousHost.getNestMembersClassAttributes()) {
            if (attr.getNestMember() == newHost.type || !this.isTypeLive(attr.getNestMember())) continue;
            DexClass nestMember = this.appView.definitionFor(attr.getNestMember());
            if (nestMember != null) {
                nestMember.setNestHost(newHost.type);
            }
            newHost.getNestMembersClassAttributes().add(new NestMemberClassAttribute(attr.getNestMember()));
        }
    }

    private boolean isAttributeReferencingPrunedItem(EnclosingMethodAttribute attr) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        return attr.getEnclosingClass() != null && !this.isTypeLive(attr.getEnclosingClass()) || attr.getEnclosingMethod() != null && !appInfo.liveMethods.contains(attr.getEnclosingMethod());
    }

    private boolean isAttributeReferencingPrunedType(InnerClassAttribute attr) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        if (!this.isTypeLive(attr.getInner())) {
            return true;
        }
        DexType context = attr.getLiveContext(appInfo);
        return context == null || !this.isTypeLive(context);
    }

    private <S extends PresortedComparable<S>, T extends KeyedDexItem<S>> int firstUnreachableIndex(List<T> items, Predicate<T> live) {
        for (int i = 0; i < items.size(); ++i) {
            if (live.test((KeyedDexItem)items.get(i))) continue;
            return i;
        }
        return -1;
    }

    private DexEncodedMethod[] reachableMethods(List<DexEncodedMethod> methods, DexClass clazz) {
        int i;
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        InternalOptions options = this.appView.options();
        int firstUnreachable = this.firstUnreachableIndex(methods, method -> appInfo.liveMethods.contains(method.method));
        if (firstUnreachable == -1) {
            return null;
        }
        ArrayList<DexEncodedMethod> reachableMethods = new ArrayList<DexEncodedMethod>(methods.size());
        for (i = 0; i < firstUnreachable; ++i) {
            reachableMethods.add(methods.get(i));
        }
        for (i = firstUnreachable; i < methods.size(); ++i) {
            DexEncodedMethod method2 = methods.get(i);
            if (appInfo.liveMethods.contains(method2.getKey())) {
                reachableMethods.add(method2);
                continue;
            }
            if (options.configurationDebugging) {
                reachableMethods.add(method2.shouldNotHaveCode() && !method2.hasCode() ? method2 : method2.toMethodThatLogsError(this.appView));
                this.methodsToKeepForConfigurationDebugging.add(method2.method);
                continue;
            }
            if (appInfo.targetedMethods.contains(method2.getKey())) {
                if (method2.shouldNotHaveCode() && !method2.hasCode()) {
                    reachableMethods.add(method2);
                    continue;
                }
                if (Log.ENABLED) {
                    Log.debug(this.getClass(), "Making method %s abstract.", method2.method);
                }
                boolean allowAbstract = (!options.canHaveDalvikAbstractMethodOnNonAbstractClassVerificationBug() || clazz.accessFlags.isAbstract()) && !method2.accessFlags.isFinal() && !method2.accessFlags.isNative() && !method2.accessFlags.isStrict() && !method2.accessFlags.isSynchronized() && !method2.accessFlags.isPrivate() && !method2.accessFlags.isStatic() && !appInfo.failedResolutionTargets.contains(method2.method);
                reachableMethods.add(allowAbstract ? method2.toAbstractMethod() : method2.toEmptyThrowingMethod(options));
                continue;
            }
            if (Log.ENABLED) {
                Log.debug(this.getClass(), "Removing method %s.", method2.method);
            }
            this.usagePrinter.printUnusedMethod(method2);
        }
        return reachableMethods.isEmpty() ? DexEncodedMethod.EMPTY_ARRAY : reachableMethods.toArray(DexEncodedMethod.EMPTY_ARRAY);
    }

    private DexEncodedField[] reachableFields(List<DexEncodedField> fields) {
        int i;
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        Predicate<DexEncodedField> isReachableOrReferencedField = field -> this.configuration.isReachableOrReferencedField(appInfo, (DexEncodedField)field);
        int firstUnreachable = this.firstUnreachableIndex(fields, isReachableOrReferencedField);
        if (firstUnreachable == -1) {
            return null;
        }
        if (Log.ENABLED) {
            Log.debug(this.getClass(), "Removing field %s.", fields.get(firstUnreachable));
        }
        this.usagePrinter.printUnusedField(fields.get(firstUnreachable));
        ArrayList<DexEncodedField> reachableOrReferencedFields = new ArrayList<DexEncodedField>(fields.size());
        for (i = 0; i < firstUnreachable; ++i) {
            reachableOrReferencedFields.add(fields.get(i));
        }
        for (i = firstUnreachable + 1; i < fields.size(); ++i) {
            DexEncodedField field2 = fields.get(i);
            if (isReachableOrReferencedField.test(field2)) {
                reachableOrReferencedFields.add(field2);
                continue;
            }
            if (Log.ENABLED) {
                Log.debug(this.getClass(), "Removing field %s.", field2.field);
            }
            this.usagePrinter.printUnusedField(field2);
        }
        return reachableOrReferencedFields.isEmpty() ? DexEncodedField.EMPTY_ARRAY : reachableOrReferencedFields.toArray(DexEncodedField.EMPTY_ARRAY);
    }

    public Collection<DexType> getRemovedClasses() {
        return Collections.unmodifiableCollection(this.prunedTypes);
    }

    public Collection<DexReference> getMethodsToKeepForConfigurationDebugging() {
        return Collections.unmodifiableCollection(this.methodsToKeepForConfigurationDebugging);
    }
}

