/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

class UsagePrinter {
    private static final String INDENT = "    ";
    static final UsagePrinter DONT_PRINT = new NoOpUsagePrinter();
    private final Consumer<String> consumer;
    private DexProgramClass enclosingClazz = null;
    private boolean clazzPrefixPrinted = false;

    UsagePrinter(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    void append(String string) {
        this.consumer.accept(string);
    }

    void printUnusedClass(DexProgramClass clazz) {
        this.append(clazz.toSourceString());
        this.append(StringUtils.LINE_SEPARATOR);
    }

    void visiting(DexProgramClass clazz) {
        assert (this.enclosingClazz == null);
        this.enclosingClazz = clazz;
    }

    void visited() {
        this.enclosingClazz = null;
        this.clazzPrefixPrinted = false;
    }

    private void printClazzPrefixIfNecessary() {
        assert (this.enclosingClazz != null);
        if (!this.clazzPrefixPrinted) {
            this.append(this.enclosingClazz.toSourceString());
            this.append(":");
            this.append(StringUtils.LINE_SEPARATOR);
            this.clazzPrefixPrinted = true;
        }
    }

    void printUnusedMethod(DexEncodedMethod method) {
        this.printClazzPrefixIfNecessary();
        this.append(INDENT);
        String accessFlags = method.accessFlags.toString();
        if (!accessFlags.isEmpty()) {
            this.append(accessFlags);
            this.append(" ");
        }
        this.append(method.method.proto.returnType.toSourceString());
        this.append(" ");
        this.append(method.method.name.toSourceString());
        this.append("(");
        for (int i = 0; i < method.method.proto.parameters.values.length; ++i) {
            if (i != 0) {
                this.append(",");
            }
            this.append(method.method.proto.parameters.values[i].toSourceString());
        }
        this.append(")");
        this.append(StringUtils.LINE_SEPARATOR);
    }

    void printUnusedField(DexEncodedField field) {
        this.printClazzPrefixIfNecessary();
        this.append(INDENT);
        String accessFlags = field.accessFlags.toString();
        if (!accessFlags.isEmpty()) {
            this.append(accessFlags);
            this.append(" ");
        }
        this.append(field.field.type.toSourceString());
        this.append(" ");
        this.append(field.field.name.toSourceString());
        this.append(StringUtils.LINE_SEPARATOR);
    }

    private static class NoOpUsagePrinter
    extends UsagePrinter {
        public NoOpUsagePrinter() {
            super(null);
        }

        @Override
        void printUnusedClass(DexProgramClass clazz) {
        }

        @Override
        void visiting(DexProgramClass clazz) {
        }

        @Override
        void visited() {
        }

        @Override
        void printUnusedMethod(DexEncodedMethod method) {
        }

        @Override
        void printUnusedField(DexEncodedField field) {
        }
    }
}

