/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.BiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.HashBiMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;

public class VerticalClassMergerGraphLense
extends GraphLense.NestedGraphLense {
    private final AppView<?> appView;
    private final Map<DexType, Map<DexMethod, GraphLense.GraphLenseLookupResult>> contextualVirtualToDirectMethodMaps;
    private Set<DexMethod> mergedMethods;
    private final Map<DexMethod, DexMethod> originalMethodSignaturesForBridges;

    private VerticalClassMergerGraphLense(AppView<?> appView, Map<DexType, DexType> typeMap, Map<DexField, DexField> fieldMap, Map<DexMethod, DexMethod> methodMap, Set<DexMethod> mergedMethods, Map<DexType, Map<DexMethod, GraphLense.GraphLenseLookupResult>> contextualVirtualToDirectMethodMaps, BiMap<DexField, DexField> originalFieldSignatures, BiMap<DexMethod, DexMethod> originalMethodSignatures, Map<DexMethod, DexMethod> originalMethodSignaturesForBridges, GraphLense previousLense) {
        super(typeMap, methodMap, fieldMap, originalFieldSignatures, originalMethodSignatures, previousLense, appView.dexItemFactory());
        this.appView = appView;
        this.contextualVirtualToDirectMethodMaps = contextualVirtualToDirectMethodMaps;
        this.mergedMethods = mergedMethods;
        this.originalMethodSignaturesForBridges = originalMethodSignaturesForBridges;
    }

    @Override
    public DexType getOriginalType(DexType type) {
        return this.previousLense.getOriginalType(type);
    }

    @Override
    public DexMethod getOriginalMethodSignature(DexMethod method) {
        return super.getOriginalMethodSignature(this.originalMethodSignaturesForBridges.getOrDefault(method, method));
    }

    @Override
    public GraphLense.GraphLenseLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type) {
        GraphLense.GraphLenseLookupResult lookup;
        Map<DexMethod, GraphLense.GraphLenseLookupResult> virtualToDirectMethodMap;
        assert (this.isContextFreeForMethod(method) || context != null && type != null);
        DexMethod previousContext = this.originalMethodSignaturesForBridges.containsKey(context) ? this.originalMethodSignaturesForBridges.get(context) : this.originalMethodSignatures.getOrDefault(context, context);
        GraphLense.GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, previousContext, type);
        if (previous.getType() == Invoke.Type.SUPER && !this.mergedMethods.contains(context) && (virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.get(context.holder)) != null && (lookup = virtualToDirectMethodMap.get(previous.getMethod())) != null) {
            return lookup;
        }
        return super.lookupMethod(previous.getMethod(), context, previous.getType());
    }

    @Override
    protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, Invoke.Type type) {
        return super.mapVirtualInterfaceInvocationTypes(this.appView, newMethod, originalMethod, type);
    }

    @Override
    public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexMethod previous : this.previousLense.lookupMethodInAllContexts(method)) {
            builder.add(this.methodMap.getOrDefault(previous, previous));
            for (Map<DexMethod, GraphLense.GraphLenseLookupResult> virtualToDirectMethodMap : this.contextualVirtualToDirectMethodMaps.values()) {
                GraphLense.GraphLenseLookupResult lookup = virtualToDirectMethodMap.get(previous);
                if (lookup == null) continue;
                builder.add(lookup.getMethod());
            }
        }
        return builder.build();
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.contextualVirtualToDirectMethodMaps.isEmpty() && this.previousLense.isContextFreeForMethods();
    }

    @Override
    public boolean isContextFreeForMethod(DexMethod method) {
        if (!this.previousLense.isContextFreeForMethod(method)) {
            return false;
        }
        DexMethod previous = this.previousLense.lookupMethod(method);
        for (Map<DexMethod, GraphLense.GraphLenseLookupResult> virtualToDirectMethodMap : this.contextualVirtualToDirectMethodMaps.values()) {
            if (!virtualToDirectMethodMap.containsKey(previous)) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private final DexItemFactory dexItemFactory;
        protected final BiMap<DexField, DexField> fieldMap = HashBiMap.create();
        protected final Map<DexMethod, DexMethod> methodMap = new IdentityHashMap<DexMethod, DexMethod>();
        private final ImmutableSet.Builder<DexMethod> mergedMethodsBuilder = ImmutableSet.builder();
        private final Map<DexType, Map<DexMethod, GraphLense.GraphLenseLookupResult>> contextualVirtualToDirectMethodMaps = new IdentityHashMap<DexType, Map<DexMethod, GraphLense.GraphLenseLookupResult>>();
        private final BiMap<DexMethod, DexMethod> originalMethodSignatures = HashBiMap.create();
        private final Map<DexMethod, DexMethod> originalMethodSignaturesForBridges = new IdentityHashMap<DexMethod, DexMethod>();
        private final Map<DexProto, DexProto> cache = new IdentityHashMap<DexProto, DexProto>();

        Builder(DexItemFactory dexItemFactory) {
            this.dexItemFactory = dexItemFactory;
        }

        static Builder createBuilderForFixup(Builder builder, Map<DexType, DexType> mergedClasses) {
            Builder newBuilder = new Builder(builder.dexItemFactory);
            for (Map.Entry entry : builder.fieldMap.entrySet()) {
                newBuilder.map((DexField)entry.getKey(), builder.getFieldSignatureAfterClassMerging((DexField)entry.getValue(), mergedClasses));
            }
            for (Map.Entry<Object, Object> entry : builder.methodMap.entrySet()) {
                newBuilder.map((DexMethod)entry.getKey(), builder.getMethodSignatureAfterClassMerging((DexMethod)entry.getValue(), mergedClasses));
            }
            for (DexMethod dexMethod : builder.mergedMethodsBuilder.build()) {
                newBuilder.markMethodAsMerged(builder.getMethodSignatureAfterClassMerging(dexMethod, mergedClasses));
            }
            for (Map.Entry<Object, Object> entry : builder.contextualVirtualToDirectMethodMaps.entrySet()) {
                DexType context = (DexType)entry.getKey();
                assert (context == builder.getTypeAfterClassMerging(context, mergedClasses));
                for (Map.Entry innerEntry : ((Map)entry.getValue()).entrySet()) {
                    DexMethod from = (DexMethod)innerEntry.getKey();
                    GraphLense.GraphLenseLookupResult rewriting = (GraphLense.GraphLenseLookupResult)innerEntry.getValue();
                    DexMethod to = builder.getMethodSignatureAfterClassMerging(rewriting.getMethod(), mergedClasses);
                    newBuilder.mapVirtualMethodToDirectInType(from, new GraphLense.GraphLenseLookupResult(to, rewriting.getType()), context);
                }
            }
            for (Map.Entry<Object, Object> entry : builder.originalMethodSignatures.entrySet()) {
                newBuilder.recordMove((DexMethod)entry.getValue(), builder.getMethodSignatureAfterClassMerging((DexMethod)entry.getKey(), mergedClasses));
            }
            for (Map.Entry<Object, Object> entry : builder.originalMethodSignaturesForBridges.entrySet()) {
                newBuilder.recordCreationOfBridgeMethod((DexMethod)entry.getValue(), builder.getMethodSignatureAfterClassMerging((DexMethod)entry.getKey(), mergedClasses));
            }
            return newBuilder;
        }

        public GraphLense build(AppView<?> appView, Map<DexType, DexType> mergedClasses) {
            if (mergedClasses.isEmpty()) {
                return appView.graphLense();
            }
            BiMap<DexField, DexField> originalFieldSignatures = this.fieldMap.inverse();
            return new VerticalClassMergerGraphLense(appView, mergedClasses, this.fieldMap, this.methodMap, (Set)((Object)this.mergedMethodsBuilder.build()), this.contextualVirtualToDirectMethodMaps, originalFieldSignatures, this.originalMethodSignatures, this.originalMethodSignaturesForBridges, appView.graphLense());
        }

        private DexField getFieldSignatureAfterClassMerging(DexField field, Map<DexType, DexType> mergedClasses) {
            assert (!field.holder.isArrayType());
            DexType holder = field.holder;
            DexType newHolder = mergedClasses.getOrDefault(holder, holder);
            DexType type = field.type;
            DexType newType = this.getTypeAfterClassMerging(type, mergedClasses);
            if (holder == newHolder && type == newType) {
                return field;
            }
            return this.dexItemFactory.createField(newHolder, newType, field.name);
        }

        private DexMethod getMethodSignatureAfterClassMerging(DexMethod signature, Map<DexType, DexType> mergedClasses) {
            assert (!signature.holder.isArrayType());
            DexType holder = signature.holder;
            DexType newHolder = mergedClasses.getOrDefault(holder, holder);
            DexProto proto = signature.proto;
            DexProto newProto = this.dexItemFactory.applyClassMappingToProto(proto, type -> this.getTypeAfterClassMerging((DexType)type, mergedClasses), this.cache);
            if (holder == newHolder && proto == newProto) {
                return signature;
            }
            return this.dexItemFactory.createMethod(newHolder, newProto, signature.name);
        }

        private DexType getTypeAfterClassMerging(DexType type, Map<DexType, DexType> mergedClasses) {
            if (type.isArrayType()) {
                DexType baseType = type.toBaseType(this.dexItemFactory);
                DexType newBaseType = mergedClasses.getOrDefault(baseType, baseType);
                if (newBaseType != baseType) {
                    return type.replaceBaseType(newBaseType, this.dexItemFactory);
                }
                return type;
            }
            return mergedClasses.getOrDefault(type, type);
        }

        public boolean hasMappingForSignatureInContext(DexType context, DexMethod signature) {
            Map<DexMethod, GraphLense.GraphLenseLookupResult> virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.get(context);
            if (virtualToDirectMethodMap != null) {
                return virtualToDirectMethodMap.containsKey(signature);
            }
            return false;
        }

        public boolean hasOriginalSignatureMappingFor(DexField field) {
            return this.fieldMap.inverse().containsKey(field);
        }

        public boolean hasOriginalSignatureMappingFor(DexMethod method) {
            return this.originalMethodSignatures.containsKey(method) || this.originalMethodSignaturesForBridges.containsKey(method);
        }

        public void markMethodAsMerged(DexMethod method) {
            this.mergedMethodsBuilder.add((Object)method);
        }

        public void map(DexField from, DexField to) {
            this.fieldMap.put(from, to);
        }

        public Builder map(DexMethod from, DexMethod to) {
            this.methodMap.put(from, to);
            return this;
        }

        public void recordMove(DexMethod from, DexMethod to) {
            this.originalMethodSignatures.put(to, from);
        }

        public void recordCreationOfBridgeMethod(DexMethod from, DexMethod to) {
            this.originalMethodSignaturesForBridges.put(to, from);
        }

        public void mapVirtualMethodToDirectInType(DexMethod from, GraphLense.GraphLenseLookupResult to, DexType type) {
            Map virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.computeIfAbsent(type, key -> new IdentityHashMap());
            virtualToDirectMethodMap.put(from, to);
        }

        public void merge(Builder builder) {
            this.fieldMap.putAll(builder.fieldMap);
            this.methodMap.putAll(builder.methodMap);
            this.mergedMethodsBuilder.addAll((Iterable)builder.mergedMethodsBuilder.build());
            this.originalMethodSignatures.putAll(builder.originalMethodSignatures);
            this.originalMethodSignaturesForBridges.putAll(builder.originalMethodSignaturesForBridges);
            for (DexType context : builder.contextualVirtualToDirectMethodMaps.keySet()) {
                Map<DexMethod, GraphLense.GraphLenseLookupResult> current = this.contextualVirtualToDirectMethodMaps.get(context);
                Map<DexMethod, GraphLense.GraphLenseLookupResult> other = builder.contextualVirtualToDirectMethodMaps.get(context);
                if (current != null) {
                    current.putAll(other);
                    continue;
                }
                this.contextualVirtualToDirectMethodMaps.put(context, other);
            }
        }
    }
}

