/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.ClassFileResourceProvider;
import shadow.bundletool.com.android.tools.r8.DataDirectoryResource;
import shadow.bundletool.com.android.tools.r8.DataEntryResource;
import shadow.bundletool.com.android.tools.r8.DataResource;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.DexFilePerClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.DirectoryClassFileProvider;
import shadow.bundletool.com.android.tools.r8.OutputMode;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.Resource;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.Version;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.ByteStreams;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.InternalCompilerError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ClassReader;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ClassVisitor;
import shadow.bundletool.com.android.tools.r8.origin.ArchiveEntryOrigin;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.shaking.FilteredClassPath;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfiguration;
import shadow.bundletool.com.android.tools.r8.utils.AarArchiveResourceProvider;
import shadow.bundletool.com.android.tools.r8.utils.ArchiveResourceProvider;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.FilteredArchiveClassFileProvider;
import shadow.bundletool.com.android.tools.r8.utils.InternalArchiveClassFileProvider;
import shadow.bundletool.com.android.tools.r8.utils.OneShotByteResource;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;
import shadow.bundletool.com.android.tools.r8.utils.ZipUtils;

public class AndroidApp {
    private static final String dumpVersionFileName = "r8-version";
    private static final String dumpProgramFileName = "program.jar";
    private static final String dumpClasspathFileName = "classpath.jar";
    private static final String dumpLibraryFileName = "library.jar";
    private static final String dumpConfigFileName = "proguard.config";
    private final ImmutableList<ProgramResourceProvider> programResourceProviders;
    private final ImmutableMap<Resource, String> programResourcesMainDescriptor;
    private final ImmutableList<ClassFileResourceProvider> classpathResourceProviders;
    private final ImmutableList<ClassFileResourceProvider> libraryResourceProviders;
    private final ImmutableList<InternalArchiveClassFileProvider> archiveProvidersToClose;
    private final StringResource proguardMapOutputData;
    private final List<StringResource> mainDexListResources;
    private final List<String> mainDexClasses;

    public void closeInternalArchiveProviders() throws IOException {
        for (InternalArchiveClassFileProvider provider : this.archiveProvidersToClose) {
            provider.close();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            if (!this.programResourceProviders.isEmpty()) {
                builder.append("  Program resources:").append(System.lineSeparator());
                AndroidApp.printProgramResourceProviders(builder, this.programResourceProviders);
            }
            if (!this.classpathResourceProviders.isEmpty()) {
                builder.append("  Classpath resources:").append(System.lineSeparator());
                AndroidApp.printClassFileProviders(builder, this.classpathResourceProviders);
            }
            if (!this.libraryResourceProviders.isEmpty()) {
                builder.append("  Library resources:").append(System.lineSeparator());
                AndroidApp.printClassFileProviders(builder, this.libraryResourceProviders);
            }
        }
        catch (ResourceException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    private static void printProgramResourceProviders(StringBuilder builder, Collection<ProgramResourceProvider> providers) throws ResourceException {
        for (ProgramResourceProvider provider : providers) {
            for (ProgramResource resource : provider.getProgramResources()) {
                AndroidApp.printProgramResource(builder, resource);
            }
        }
    }

    private static void printClassFileProviders(StringBuilder builder, Collection<ClassFileResourceProvider> providers) {
        for (ClassFileResourceProvider provider : providers) {
            for (String descriptor : provider.getClassDescriptors()) {
                ProgramResource resource = provider.getProgramResource(descriptor);
                AndroidApp.printProgramResource(builder, resource);
            }
        }
    }

    private static void printProgramResource(StringBuilder builder, ProgramResource resource) {
        builder.append("    ").append(resource.getOrigin());
        Set<String> descriptors = resource.getClassDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            builder.append(" contains ");
            StringUtils.append(builder, descriptors);
        }
        builder.append(System.lineSeparator());
    }

    private AndroidApp(ImmutableList<ProgramResourceProvider> programResourceProviders, ImmutableMap<Resource, String> programResourcesMainDescriptor, ImmutableList<ClassFileResourceProvider> classpathResourceProviders, ImmutableList<ClassFileResourceProvider> libraryResourceProviders, ImmutableList<InternalArchiveClassFileProvider> archiveProvidersToClose, StringResource proguardMapOutputData, List<StringResource> mainDexListResources, List<String> mainDexClasses) {
        this.programResourceProviders = programResourceProviders;
        this.programResourcesMainDescriptor = programResourcesMainDescriptor;
        this.classpathResourceProviders = classpathResourceProviders;
        this.libraryResourceProviders = libraryResourceProviders;
        this.archiveProvidersToClose = archiveProvidersToClose;
        this.proguardMapOutputData = proguardMapOutputData;
        this.mainDexListResources = mainDexListResources;
        this.mainDexClasses = mainDexClasses;
        assert (AndroidApp.verifyInternalProvidersInCloseSet(classpathResourceProviders, archiveProvidersToClose));
        assert (AndroidApp.verifyInternalProvidersInCloseSet(libraryResourceProviders, archiveProvidersToClose));
    }

    private static boolean verifyInternalProvidersInCloseSet(ImmutableList<ClassFileResourceProvider> providers, ImmutableList<InternalArchiveClassFileProvider> providersToClose) {
        return providers.stream().allMatch(p -> !(p instanceof InternalArchiveClassFileProvider) || providersToClose.contains(p));
    }

    static Reporter defaultReporter() {
        return new Reporter();
    }

    public static Builder builder() {
        return AndroidApp.builder(AndroidApp.defaultReporter());
    }

    public static Builder builder(Reporter reporter) {
        return new Builder(reporter);
    }

    public static Builder builder(AndroidApp app) {
        return AndroidApp.builder(app, AndroidApp.defaultReporter());
    }

    public static Builder builder(AndroidApp app, Reporter reporter) {
        return new Builder(reporter, app);
    }

    public Collection<ProgramResource> computeAllProgramResources() throws ResourceException {
        ArrayList<ProgramResource> resources = new ArrayList<ProgramResource>();
        for (ProgramResourceProvider provider : this.programResourceProviders) {
            resources.addAll(provider.getProgramResources());
        }
        return resources;
    }

    public List<ProgramResource> getDexProgramResourcesForTesting() throws IOException {
        try {
            return this.filter(this.programResourceProviders, ProgramResource.Kind.DEX);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new InternalCompilerError("Unexpected resource error", e);
        }
    }

    public List<ProgramResource> getClassProgramResourcesForTesting() throws IOException {
        try {
            return this.filter(this.programResourceProviders, ProgramResource.Kind.CF);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new InternalCompilerError("Unexpected resource error", e);
        }
    }

    public Set<DataEntryResource> getDataEntryResourcesForTesting() throws ResourceException {
        final TreeSet<DataEntryResource> out = new TreeSet<DataEntryResource>(Comparator.comparing(DataResource::getName));
        for (ProgramResourceProvider programResourceProvider : this.getProgramResourceProviders()) {
            DataResourceProvider dataResourceProvider = programResourceProvider.getDataResourceProvider();
            if (dataResourceProvider == null) continue;
            dataResourceProvider.accept(new DataResourceProvider.Visitor(){

                @Override
                public void visit(DataDirectoryResource directory) {
                }

                @Override
                public void visit(DataEntryResource file) {
                    try {
                        byte[] bytes = ByteStreams.toByteArray(file.getByteStream());
                        DataEntryResource copy = DataEntryResource.fromBytes(bytes, file.getName(), file.getOrigin());
                        out.add(copy);
                    }
                    catch (IOException | ResourceException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return out;
    }

    public List<ProgramResourceProvider> getProgramResourceProviders() {
        return this.programResourceProviders;
    }

    public List<ClassFileResourceProvider> getClasspathResourceProviders() {
        return this.classpathResourceProviders;
    }

    public List<ClassFileResourceProvider> getLibraryResourceProviders() {
        return this.libraryResourceProviders;
    }

    private List<ProgramResource> filter(List<ProgramResourceProvider> providers, ProgramResource.Kind kind) throws ResourceException {
        ArrayList<ProgramResource> out = new ArrayList<ProgramResource>();
        for (ProgramResourceProvider provider : providers) {
            for (ProgramResource code : provider.getProgramResources()) {
                if (code.getKind() != kind) continue;
                out.add(code);
            }
        }
        return out;
    }

    public StringResource getProguardMapOutputData() {
        return this.proguardMapOutputData;
    }

    public boolean hasMainDexList() {
        return !this.mainDexListResources.isEmpty() || !this.mainDexClasses.isEmpty();
    }

    public boolean hasMainDexListResources() {
        return !this.mainDexListResources.isEmpty();
    }

    public List<StringResource> getMainDexListResources() {
        return this.mainDexListResources;
    }

    public List<String> getMainDexClasses() {
        return this.mainDexClasses;
    }

    public AndroidApp withoutMainDexList() {
        return new AndroidApp(this.programResourceProviders, this.programResourcesMainDescriptor, this.classpathResourceProviders, this.libraryResourceProviders, this.archiveProvidersToClose, this.proguardMapOutputData, ImmutableList.of(), ImmutableList.of());
    }

    public void write(Path output, OutputMode outputMode) throws IOException {
        if (FileUtils.isArchive(output)) {
            this.writeToZip(output, outputMode);
        } else {
            this.writeToDirectory(output, outputMode);
        }
    }

    public void writeToDirectory(Path directory, OutputMode outputMode) throws IOException {
        List<ProgramResource> dexProgramSources = this.getDexProgramResourcesForTesting();
        try {
            if (outputMode == OutputMode.DexIndexed) {
                DexIndexedConsumer.DirectoryConsumer.writeResources(directory, dexProgramSources);
            } else {
                DexFilePerClassFileConsumer.DirectoryConsumer.writeResources(directory, dexProgramSources, this.programResourcesMainDescriptor);
            }
        }
        catch (ResourceException e) {
            throw new IOException("Resource Error", e);
        }
    }

    public void writeToZip(Path archive, OutputMode outputMode) throws IOException {
        block5: {
            try {
                if (outputMode == OutputMode.DexIndexed) {
                    DexIndexedConsumer.ArchiveConsumer.writeResources(archive, this.getDexProgramResourcesForTesting(), this.getDataEntryResourcesForTesting());
                    break block5;
                }
                if (outputMode == OutputMode.DexFilePerClassFile) {
                    List<ProgramResource> resources = this.getDexProgramResourcesForTesting();
                    DexFilePerClassFileConsumer.ArchiveConsumer.writeResources(archive, resources, this.programResourcesMainDescriptor);
                    break block5;
                }
                if (outputMode == OutputMode.ClassFile) {
                    ClassFileConsumer.ArchiveConsumer.writeResources(archive, this.getClassProgramResourcesForTesting(), this.getDataEntryResourcesForTesting());
                    break block5;
                }
                throw new Unreachable("Unsupported output-mode for writing: " + (Object)((Object)outputMode));
            }
            catch (ResourceException e) {
                throw new IOException("Resource Error", e);
            }
        }
    }

    public String getPrimaryClassDescriptor(Resource resource) {
        assert (resource instanceof ProgramResource);
        return this.programResourcesMainDescriptor.get(resource);
    }

    public void dump(Path output, ProguardConfiguration configuration, Reporter reporter) {
        int nextDexIndex = 0;
        OpenOption[] openOptions = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(output, openOptions));){
            ZipUtils.writeToZipStream(out, dumpVersionFileName, Version.getVersionString().getBytes(), 8);
            if (configuration != null) {
                String proguardConfig = configuration.getParsedConfiguration();
                ZipUtils.writeToZipStream(out, dumpConfigFileName, proguardConfig.getBytes(), 8);
            }
            nextDexIndex = this.dumpProgramResources(dumpProgramFileName, nextDexIndex, out);
            nextDexIndex = this.dumpClasspathResources(nextDexIndex, out);
            nextDexIndex = this.dumpLibraryResources(nextDexIndex, out);
        }
        catch (IOException | ResourceException e) {
            reporter.fatalError(new StringDiagnostic("Failed to dump inputs"), e);
        }
    }

    private int dumpLibraryResources(int nextDexIndex, ZipOutputStream out) throws IOException, ResourceException {
        nextDexIndex = AndroidApp.dumpClassFileResources(dumpLibraryFileName, nextDexIndex, out, this.libraryResourceProviders);
        return nextDexIndex;
    }

    private int dumpClasspathResources(int nextDexIndex, ZipOutputStream out) throws IOException, ResourceException {
        nextDexIndex = AndroidApp.dumpClassFileResources(dumpClasspathFileName, nextDexIndex, out, this.classpathResourceProviders);
        return nextDexIndex;
    }

    private static ClassFileResourceProvider createClassFileResourceProvider(final Map<String, ProgramResource> classPathResources) {
        return new ClassFileResourceProvider(){

            @Override
            public Set<String> getClassDescriptors() {
                return classPathResources.keySet();
            }

            @Override
            public ProgramResource getProgramResource(String descriptor) {
                return (ProgramResource)classPathResources.get(descriptor);
            }
        };
    }

    private Consumer<ProgramResource> createClassFileResourceConsumer(Map<String, ProgramResource> classPathResources) {
        return programResource -> {
            assert (programResource.getClassDescriptors().size() == 1);
            String descriptor = programResource.getClassDescriptors().iterator().next();
            classPathResources.put(descriptor, (ProgramResource)programResource);
        };
    }

    private int dumpProgramResources(String archiveName, int nextDexIndex, ZipOutputStream out) throws IOException, ResourceException {
        try (ByteArrayOutputStream archiveByteStream = new ByteArrayOutputStream();){
            try (ZipOutputStream archiveOutputStream = new ZipOutputStream(archiveByteStream);){
                Object2IntOpenHashMap<String> seen = new Object2IntOpenHashMap<String>();
                Set<DataEntryResource> dataEntries = this.getDataEntryResourcesForTesting();
                for (DataEntryResource dataResource : dataEntries) {
                    String entryName = dataResource.getName();
                    InputStream dataStream = dataResource.getByteStream();
                    Throwable throwable = null;
                    try {
                        byte[] bytes = ByteStreams.toByteArray(dataStream);
                        ZipUtils.writeToZipStream(archiveOutputStream, entryName, bytes, 8);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dataStream == null) continue;
                        AndroidApp.$closeResource(throwable, dataStream);
                    }
                }
                for (ProgramResourceProvider provider : this.programResourceProviders) {
                    for (ProgramResource programResource : provider.getProgramResources()) {
                        nextDexIndex = AndroidApp.dumpProgramResource(seen, nextDexIndex, archiveOutputStream, programResource);
                    }
                }
            }
            ZipUtils.writeToZipStream(out, archiveName, archiveByteStream.toByteArray(), 8);
        }
        return nextDexIndex;
    }

    private static int dumpClassFileResources(String archiveName, int nextDexIndex, ZipOutputStream out, ImmutableList<ClassFileResourceProvider> classpathResourceProviders) throws IOException, ResourceException {
        try (ByteArrayOutputStream archiveByteStream = new ByteArrayOutputStream();){
            try (ZipOutputStream archiveOutputStream = new ZipOutputStream(archiveByteStream);){
                Object2IntOpenHashMap<String> seen = new Object2IntOpenHashMap<String>();
                for (ClassFileResourceProvider provider : classpathResourceProviders) {
                    for (String descriptor : provider.getClassDescriptors()) {
                        ProgramResource programResource = provider.getProgramResource(descriptor);
                        int oldDexIndex = nextDexIndex;
                        nextDexIndex = AndroidApp.dumpProgramResource(seen, nextDexIndex, archiveOutputStream, programResource);
                        assert (nextDexIndex == oldDexIndex);
                    }
                }
            }
            ZipUtils.writeToZipStream(out, archiveName, archiveByteStream.toByteArray(), 8);
        }
        return nextDexIndex;
    }

    private static int dumpProgramResource(Object2IntMap<String> seen, int nextDexIndex, ZipOutputStream archiveOutputStream, ProgramResource programResource) throws ResourceException, IOException {
        String entryName;
        byte[] bytes = ByteStreams.toByteArray(programResource.getByteStream());
        if (programResource.getKind() == ProgramResource.Kind.CF) {
            Set<String> classDescriptors = programResource.getClassDescriptors();
            String classDescriptor = classDescriptors == null || classDescriptors.size() != 1 ? AndroidApp.extractClassDescriptor(bytes) : classDescriptors.iterator().next();
            String classFileName = DescriptorUtils.getClassFileName(classDescriptor);
            int dupCount = seen.getOrDefault(classDescriptor, 0);
            seen.put(classDescriptor, dupCount + 1);
            entryName = dupCount == 0 ? classFileName : classFileName + "." + dupCount + ".dup";
        } else {
            assert (programResource.getKind() == ProgramResource.Kind.DEX);
            entryName = "classes" + nextDexIndex++ + ".dex";
        }
        ZipUtils.writeToZipStream(archiveOutputStream, entryName, bytes, 8);
        return nextDexIndex;
    }

    private static String extractClassDescriptor(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        class ClassNameExtractor
        extends ClassVisitor {
            private String className;

            ClassNameExtractor() {
                super(458752);
            }

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
            }

            String getDescriptor() {
                return "L" + this.className + ";";
            }
        }
        ClassNameExtractor extractor = new ClassNameExtractor();
        reader.accept(extractor, 7);
        return extractor.getDescriptor();
    }

    public static class Builder {
        private final List<ProgramResourceProvider> programResourceProviders = new ArrayList<ProgramResourceProvider>();
        private final List<ProgramResource> programResources = new ArrayList<ProgramResource>();
        private final List<DataResource> dataResources = new ArrayList<DataResource>();
        private final Map<ProgramResource, String> programResourcesMainDescriptor = new HashMap<ProgramResource, String>();
        private final List<ClassFileResourceProvider> classpathResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private final List<ClassFileResourceProvider> libraryResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private final List<InternalArchiveClassFileProvider> archiveProvidersToClose = new ArrayList<InternalArchiveClassFileProvider>();
        private List<StringResource> mainDexListResources = new ArrayList<StringResource>();
        private List<String> mainDexListClasses = new ArrayList<String>();
        private boolean ignoreDexInArchive = false;
        private StringResource proguardMapOutputData;
        private final Reporter reporter;

        private Builder(Reporter reporter) {
            this.reporter = reporter;
        }

        private Builder(Reporter reporter, AndroidApp app) {
            this(reporter);
            this.programResourceProviders.addAll(app.programResourceProviders);
            this.classpathResourceProviders.addAll(app.classpathResourceProviders);
            this.libraryResourceProviders.addAll(app.libraryResourceProviders);
            this.archiveProvidersToClose.addAll(app.archiveProvidersToClose);
            this.mainDexListResources = app.mainDexListResources;
            this.mainDexListClasses = app.mainDexClasses;
        }

        public Reporter getReporter() {
            return this.reporter;
        }

        public Builder addDump(Path dumpFile) throws IOException {
            System.out.println("Reading dump from file: " + dumpFile);
            PathOrigin origin = new PathOrigin(dumpFile);
            ZipUtils.iter(dumpFile.toString(), (entry, input) -> {
                String name = entry.getName();
                if (name.equals(AndroidApp.dumpVersionFileName)) {
                    String content = new String(ByteStreams.toByteArray(input), StandardCharsets.UTF_8);
                    System.out.println("Dump produced by R8 version: " + content);
                } else if (name.equals(AndroidApp.dumpProgramFileName)) {
                    this.readProgramDump(origin, input);
                } else if (name.equals(AndroidApp.dumpClasspathFileName)) {
                    this.readClassFileDump(origin, input, this::addClasspathResourceProvider, "classpath");
                } else if (name.equals(AndroidApp.dumpLibraryFileName)) {
                    this.readClassFileDump(origin, input, this::addLibraryResourceProvider, "library");
                } else {
                    System.out.println("WARNING: Unexpected dump file entry: " + entry.getName());
                }
            });
            return this;
        }

        private void readClassFileDump(Origin origin, InputStream input, Consumer<ClassFileResourceProvider> addProvider, String inputType) throws IOException {
            HashMap<String, OneShotByteResource> resources = new HashMap<String, OneShotByteResource>();
            try (ZipInputStream stream = new ZipInputStream(input);){
                ZipEntry entry;
                while (null != (entry = stream.getNextEntry())) {
                    String name = entry.getName();
                    if (ZipUtils.isClassFile(name)) {
                        ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, origin);
                        String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                        OneShotByteResource resource = OneShotByteResource.create(ProgramResource.Kind.CF, entryOrigin, ByteStreams.toByteArray(stream), Collections.singleton(descriptor));
                        resources.put(descriptor, resource);
                        continue;
                    }
                    if (name.endsWith(".dup")) {
                        System.out.println("WARNING: Duplicate " + inputType + " resource: " + name);
                        continue;
                    }
                    System.out.println("WARNING: Unexpected " + inputType + " resource: " + name);
                }
            }
            if (!resources.isEmpty()) {
                addProvider.accept(AndroidApp.createClassFileResourceProvider(resources));
            }
        }

        private void readProgramDump(Origin origin, InputStream input) throws IOException {
            final ArrayList<OneShotByteResource> programResources = new ArrayList<OneShotByteResource>();
            final ArrayList<DataEntryResource> dataResources = new ArrayList<DataEntryResource>();
            try (ZipInputStream stream = new ZipInputStream(input);){
                ZipEntry entry;
                while (null != (entry = stream.getNextEntry())) {
                    ArchiveEntryOrigin entryOrigin;
                    String name = entry.getName();
                    if (ZipUtils.isClassFile(name)) {
                        entryOrigin = new ArchiveEntryOrigin(name, origin);
                        String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                        OneShotByteResource resource = OneShotByteResource.create(ProgramResource.Kind.CF, entryOrigin, ByteStreams.toByteArray(stream), Collections.singleton(descriptor));
                        programResources.add(resource);
                        continue;
                    }
                    if (ZipUtils.isDexFile(name)) {
                        entryOrigin = new ArchiveEntryOrigin(name, origin);
                        OneShotByteResource resource = OneShotByteResource.create(ProgramResource.Kind.DEX, entryOrigin, ByteStreams.toByteArray(stream), null);
                        programResources.add(resource);
                        continue;
                    }
                    if (name.endsWith(".dup")) {
                        System.out.println("WARNING: Duplicate program resource: " + name);
                        continue;
                    }
                    dataResources.add(DataEntryResource.fromBytes(ByteStreams.toByteArray(stream), name, origin));
                }
            }
            if (!programResources.isEmpty() || !dataResources.isEmpty()) {
                this.addProgramResourceProvider(new ProgramResourceProvider(){

                    @Override
                    public Collection<ProgramResource> getProgramResources() throws ResourceException {
                        return programResources;
                    }

                    @Override
                    public DataResourceProvider getDataResourceProvider() {
                        return dataResources.isEmpty() ? null : new DataResourceProvider(){

                            @Override
                            public void accept(DataResourceProvider.Visitor visitor) throws ResourceException {
                                for (DataEntryResource dataResource : dataResources) {
                                    visitor.visit(dataResource);
                                }
                            }
                        };
                    }
                });
            }
        }

        public Builder addProgramFiles(Path ... files) {
            return this.addProgramFiles(Arrays.asList(files));
        }

        public Builder addProgramFiles(Collection<Path> files) {
            for (Path file : files) {
                this.addProgramFile(file);
            }
            return this;
        }

        public Builder addFilteredProgramArchives(Collection<FilteredClassPath> filteredArchives) {
            for (FilteredClassPath archive : filteredArchives) {
                if (FileUtils.isArchive(archive.getPath())) {
                    ArchiveResourceProvider archiveResourceProvider = new ArchiveResourceProvider(archive, this.ignoreDexInArchive);
                    this.addProgramResourceProvider(archiveResourceProvider);
                    continue;
                }
                this.reporter.error(new StringDiagnostic("Unexpected input type. Only archive types are supported, e.g., .jar, .zip, etc.", archive.getOrigin(), archive.getPosition()));
            }
            return this;
        }

        public Builder addProgramResourceProvider(ProgramResourceProvider provider) {
            assert (provider != null);
            this.programResourceProviders.add(provider);
            return this;
        }

        public Builder addClasspathFiles(Path ... files) {
            return this.addClasspathFiles(Arrays.asList(files));
        }

        public Builder addClasspathFiles(Collection<Path> files) {
            for (Path file : files) {
                this.addClasspathFile(file);
            }
            return this;
        }

        public Builder addClasspathFile(Path file) {
            this.addClasspathOrLibraryProvider(file, this.classpathResourceProviders);
            return this;
        }

        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider) {
            this.classpathResourceProviders.add(provider);
            return this;
        }

        public Builder addLibraryFiles(Path ... files) {
            return this.addLibraryFiles(Arrays.asList(files));
        }

        public Builder addLibraryFiles(Collection<Path> files) {
            for (Path file : files) {
                this.addClasspathOrLibraryProvider(file, this.libraryResourceProviders);
            }
            return this;
        }

        public Builder addLibraryFile(Path file) {
            this.addClasspathOrLibraryProvider(file, this.libraryResourceProviders);
            return this;
        }

        public Builder addFilteredLibraryArchives(Collection<FilteredClassPath> filteredArchives) {
            for (FilteredClassPath archive : filteredArchives) {
                if (FileUtils.isArchive(archive.getPath())) {
                    try {
                        FilteredArchiveClassFileProvider provider = new FilteredArchiveClassFileProvider(archive);
                        this.archiveProvidersToClose.add(provider);
                        this.libraryResourceProviders.add(provider);
                    }
                    catch (IOException e) {
                        this.reporter.error(new ExceptionDiagnostic(e, new PathOrigin(archive.getPath())));
                    }
                    continue;
                }
                this.reporter.error(new StringDiagnostic("Unexpected input type. Only archive types are supported, e.g., .jar, .zip, etc.", archive.getOrigin(), archive.getPosition()));
            }
            return this;
        }

        public Builder addLibraryResourceProvider(ClassFileResourceProvider provider) {
            if (provider instanceof InternalArchiveClassFileProvider) {
                this.archiveProvidersToClose.add((InternalArchiveClassFileProvider)provider);
            }
            this.libraryResourceProviders.add(provider);
            return this;
        }

        public Builder addDexProgramData(byte[] data2, Set<String> classDescriptors) {
            this.addProgramResources(ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, data2, classDescriptors));
            return this;
        }

        public Builder addDexProgramData(byte[] data2, Set<String> classDescriptors, String primaryClassDescriptor) {
            ProgramResource resource = ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, data2, classDescriptors);
            this.programResources.add(resource);
            this.programResourcesMainDescriptor.put(resource, primaryClassDescriptor);
            return this;
        }

        public Builder addDexProgramData(byte[] data2, Origin origin) {
            this.addProgramResources(ProgramResource.fromBytes(origin, ProgramResource.Kind.DEX, data2, null));
            return this;
        }

        public Builder addDexProgramData(Collection<byte[]> data2) {
            for (byte[] datum : data2) {
                this.addProgramResources(ProgramResource.fromBytes(Origin.unknown(), ProgramResource.Kind.DEX, datum, null));
            }
            return this;
        }

        public Builder addClassProgramData(Collection<byte[]> data2) {
            for (byte[] datum : data2) {
                this.addClassProgramData(datum, Origin.unknown());
            }
            return this;
        }

        public Builder addClassProgramData(byte[] data2, Origin origin) {
            return this.addClassProgramData(data2, origin, null);
        }

        public Builder addClassProgramData(byte[] data2, Origin origin, Set<String> classDescriptors) {
            this.addProgramResources(ProgramResource.fromBytes(origin, ProgramResource.Kind.CF, data2, classDescriptors));
            return this;
        }

        public Builder addDataResource(DataResource dataResource) {
            this.addDataResources(dataResource);
            return this;
        }

        public Builder setProguardMapOutputData(String content) {
            this.proguardMapOutputData = content == null ? null : StringResource.fromString(content, Origin.unknown());
            return this;
        }

        public Builder addMainDexListFiles(Path ... files) throws NoSuchFileException {
            return this.addMainDexListFiles(Arrays.asList(files));
        }

        public Builder addMainDexListFiles(Collection<Path> files) throws NoSuchFileException {
            for (Path file : files) {
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new NoSuchFileException(file.toString());
                }
                this.mainDexListResources.add(StringResource.fromFile(file));
            }
            return this;
        }

        public Builder addMainDexClasses(String ... classes) {
            return this.addMainDexClasses(Arrays.asList(classes));
        }

        public Builder addMainDexClasses(Collection<String> classes) {
            this.mainDexListClasses.addAll(classes);
            return this;
        }

        public boolean hasMainDexList() {
            return !this.mainDexListResources.isEmpty() || !this.mainDexListClasses.isEmpty();
        }

        public Builder setIgnoreDexInArchive(boolean value) {
            this.ignoreDexInArchive = value;
            return this;
        }

        public AndroidApp build() {
            if (!this.programResources.isEmpty() || !this.dataResources.isEmpty()) {
                final ImmutableList<ProgramResource> finalProgramResources = ImmutableList.copyOf(this.programResources);
                final ImmutableList<DataResource> finalDataResources = ImmutableList.copyOf(this.dataResources);
                this.programResourceProviders.add(new ProgramResourceProvider(){

                    @Override
                    public Collection<ProgramResource> getProgramResources() {
                        return finalProgramResources;
                    }

                    @Override
                    public DataResourceProvider getDataResourceProvider() {
                        if (!finalDataResources.isEmpty()) {
                            return new DataResourceProvider(){

                                @Override
                                public void accept(DataResourceProvider.Visitor visitor) {
                                    for (DataResource dataResource : finalDataResources) {
                                        if (dataResource instanceof DataEntryResource) {
                                            visitor.visit((DataEntryResource)dataResource);
                                            continue;
                                        }
                                        assert (dataResource instanceof DataDirectoryResource);
                                        visitor.visit((DataDirectoryResource)dataResource);
                                    }
                                }
                            };
                        }
                        return null;
                    }
                });
                this.programResources.clear();
                this.dataResources.clear();
            }
            return new AndroidApp(ImmutableList.copyOf(this.programResourceProviders), ImmutableMap.copyOf(this.programResourcesMainDescriptor), ImmutableList.copyOf(this.classpathResourceProviders), ImmutableList.copyOf(this.libraryResourceProviders), ImmutableList.copyOf(this.archiveProvidersToClose), this.proguardMapOutputData, this.mainDexListResources, this.mainDexListClasses);
        }

        public Builder addProgramFile(Path file) {
            if (!Files.exists(file, new LinkOption[0])) {
                PathOrigin pathOrigin = new PathOrigin(file);
                NoSuchFileException noSuchFileException = new NoSuchFileException(file.toString());
                this.reporter.error(new ExceptionDiagnostic(noSuchFileException, pathOrigin));
            }
            if (FileUtils.isDexFile(file)) {
                this.addProgramResources(ProgramResource.fromFile(ProgramResource.Kind.DEX, file));
            } else if (FileUtils.isClassFile(file)) {
                this.addProgramResources(ProgramResource.fromFile(ProgramResource.Kind.CF, file));
            } else if (FileUtils.isAarFile(file)) {
                this.addProgramResourceProvider(AarArchiveResourceProvider.fromArchive(file));
            } else if (FileUtils.isArchive(file)) {
                this.addProgramResourceProvider(ArchiveResourceProvider.fromArchive(file, this.ignoreDexInArchive));
            } else {
                throw new CompilationError("Unsupported source file type", new PathOrigin(file));
            }
            return this;
        }

        private void addProgramResources(ProgramResource ... resources) {
            this.addProgramResources(Arrays.asList(resources));
        }

        private void addProgramResources(Collection<ProgramResource> resources) {
            this.programResources.addAll(resources);
        }

        private void addDataResources(DataResource ... resources) {
            this.addDataResources(Arrays.asList(resources));
        }

        private void addDataResources(Collection<DataResource> resources) {
            this.dataResources.addAll(resources);
        }

        private void addClasspathOrLibraryProvider(Path file, List<ClassFileResourceProvider> providerList) {
            if (!Files.exists(file, new LinkOption[0])) {
                this.reporter.error(new ExceptionDiagnostic(new NoSuchFileException(file.toString()), new PathOrigin(file)));
            }
            if (FileUtils.isArchive(file)) {
                try {
                    InternalArchiveClassFileProvider provider = new InternalArchiveClassFileProvider(file);
                    this.archiveProvidersToClose.add(provider);
                    providerList.add(provider);
                }
                catch (IOException e) {
                    this.reporter.error(new ExceptionDiagnostic(e, new PathOrigin(file)));
                }
            } else if (Files.isDirectory(file, new LinkOption[0])) {
                providerList.add(DirectoryClassFileProvider.fromDirectory(file));
            } else {
                throw new CompilationError("Unsupported source file type", new PathOrigin(file));
            }
        }

        public List<ProgramResourceProvider> getProgramResourceProviders() {
            return this.programResourceProviders;
        }
    }
}

