/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.ClassFileResourceProvider;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableListMultimap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Multimap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.Closer;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.ClassKind;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.JarApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.JarClassFileReader;

public abstract class ClassProvider<T extends DexClass> {
    private final ClassKind classKind;

    ClassProvider(ClassKind classKind) {
        this.classKind = classKind;
    }

    final ClassKind getClassKind() {
        return this.classKind;
    }

    public abstract void collectClass(DexType var1, Consumer<T> var2);

    public abstract Collection<DexType> collectTypes();

    public static <T extends DexClass> ClassProvider<T> forClassFileResources(ClassKind classKind, ClassFileResourceProvider provider, JarApplicationReader reader) {
        return new ClassFileResourceReader(classKind, provider, reader);
    }

    public static <T extends DexClass> ClassProvider<T> forPreloadedClasses(ClassKind classKind, Collection<T> classes) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (DexClass clazz : classes) {
            builder.put(clazz.type, clazz);
        }
        return new PreloadedClassProvider(classKind, builder.build());
    }

    public static <T extends DexClass> ClassProvider<T> combine(ClassKind classKind, List<ClassProvider<T>> providers) {
        return new CombinedClassProvider(classKind, providers);
    }

    private static class CombinedClassProvider<T extends DexClass>
    extends ClassProvider<T> {
        private final List<ClassProvider<T>> providers;

        private CombinedClassProvider(ClassKind classKind, List<ClassProvider<T>> providers) {
            super(classKind);
            this.providers = providers;
        }

        @Override
        public void collectClass(DexType type, Consumer<T> classConsumer) {
            for (ClassProvider<T> provider : this.providers) {
                provider.collectClass(type, classConsumer);
            }
        }

        @Override
        public Collection<DexType> collectTypes() {
            Set<DexType> types = Sets.newIdentityHashSet();
            for (ClassProvider<T> provider : this.providers) {
                types.addAll(provider.collectTypes());
            }
            return types;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            String prefix = "combined(";
            for (ClassProvider<T> provider : this.providers) {
                builder.append(prefix);
                prefix = ", ";
                builder.append(provider);
            }
            return builder.append(")").toString();
        }
    }

    private static class PreloadedClassProvider<T extends DexClass>
    extends ClassProvider<T> {
        private final Multimap<DexType, T> classes;

        private PreloadedClassProvider(ClassKind classKind, Multimap<DexType, T> classes) {
            super(classKind);
            this.classes = classes;
        }

        @Override
        public void collectClass(DexType type, Consumer<T> classConsumer) {
            for (DexClass clazz : this.classes.get(type)) {
                classConsumer.accept(clazz);
            }
        }

        @Override
        public Collection<DexType> collectTypes() {
            return this.classes.keys();
        }

        public String toString() {
            return "preloaded(" + this.classes.size() + ")";
        }
    }

    private static class ClassFileResourceReader<T extends DexClass>
    extends ClassProvider<T> {
        private final ClassKind classKind;
        private final ClassFileResourceProvider provider;
        private final JarApplicationReader reader;

        private ClassFileResourceReader(ClassKind classKind, ClassFileResourceProvider provider, JarApplicationReader reader) {
            super(classKind);
            this.classKind = classKind;
            this.provider = provider;
            this.reader = reader;
        }

        @Override
        public void collectClass(DexType type, Consumer<T> classConsumer) {
            String descriptor = type.descriptor.toString();
            ProgramResource resource = this.provider.getProgramResource(descriptor);
            if (resource != null) {
                try (Closer closer = Closer.create();){
                    JarClassFileReader classReader = new JarClassFileReader(this.reader, this.classKind.bridgeConsumer(classConsumer));
                    classReader.read(resource.getOrigin(), this.classKind, closer.register(resource.getByteStream()));
                }
                catch (IOException | ResourceException e) {
                    throw new CompilationError("Failed to load class: " + descriptor, e);
                }
            }
        }

        @Override
        public Collection<DexType> collectTypes() {
            ArrayList<DexType> types = new ArrayList<DexType>();
            for (String descriptor : this.provider.getClassDescriptors()) {
                types.add(this.reader.options.itemFactory.createType(descriptor));
            }
            return types;
        }

        public String toString() {
            return "class-resource-provider(" + this.provider.toString() + ")";
        }
    }
}

