/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;

public class IteratorUtils {
    public static <T, S extends T> Iterator<S> filter(final Iterator<? extends T> iterator2, final Predicate<T> predicate) {
        return new Iterator<S>(){
            private S next = this.advance();

            private S advance() {
                while (iterator2.hasNext()) {
                    Object element = iterator2.next();
                    if (!predicate.test(element)) continue;
                    return element;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public S next() {
                Object current = this.next;
                if (current == null) {
                    throw new NoSuchElementException();
                }
                this.next = this.advance();
                return current;
            }
        };
    }

    public static <T> T peekPrevious(ListIterator<T> iterator2) {
        T previous = iterator2.previous();
        T next = iterator2.next();
        assert (previous == next);
        return previous;
    }

    public static <T> T peekNext(ListIterator<T> iterator2) {
        if (iterator2.hasNext()) {
            T next = iterator2.next();
            T previous = iterator2.previous();
            assert (previous == next);
            return next;
        }
        return null;
    }

    public static <T> T previousUntil(ListIterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasPrevious()) {
            T previous = iterator2.previous();
            if (!predicate.test(previous)) continue;
            return previous;
        }
        throw new Unreachable();
    }

    public static <T> void removeIf(Iterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!predicate.test(item)) continue;
            iterator2.remove();
        }
    }

    @Deprecated
    public static void removeIf(InstructionIterator iterator2, Predicate<Instruction> predicate) {
        throw new Unimplemented();
    }

    public static void removeIf(InstructionListIterator iterator2, Predicate<Instruction> predicate) {
        IteratorUtils.removeIf(iterator2, predicate);
    }

    public static <T> boolean allRemainingMatch(ListIterator<T> iterator2, Predicate<T> predicate) {
        return !IteratorUtils.anyRemainingMatch(iterator2, remaining -> !predicate.test(remaining));
    }

    public static <T> boolean anyRemainingMatch(ListIterator<T> iterator2, Predicate<T> predicate) {
        T state = IteratorUtils.peekNext(iterator2);
        boolean result = false;
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!predicate.test(item)) continue;
            result = true;
            break;
        }
        while (iterator2.hasPrevious() && iterator2.previous() != state) {
        }
        assert (IteratorUtils.peekNext(iterator2) == state);
        return result;
    }
}

