/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingConsumer;

public class ThreadUtils {
    public static final int NOT_SPECIFIED = -1;

    public static <T, E extends Exception> void processItems(Iterable<T> items, ThrowingConsumer<T, E> consumer, ExecutorService executorService) throws ExecutionException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (Object item : items) {
            futures.add(executorService.submit(() -> {
                consumer.accept(item);
                return null;
            }));
        }
        ThreadUtils.awaitFutures(futures);
    }

    public static void awaitFutures(Iterable<? extends Future<?>> futures) throws ExecutionException {
        Iterator<Future<?>> futureIterator = futures.iterator();
        try {
            while (futureIterator.hasNext()) {
                futureIterator.next().get();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for future.", e);
        }
        finally {
            while (futureIterator.hasNext()) {
                try {
                    futureIterator.next().get();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    static ExecutorService getExecutorServiceForProcessors(int processors) {
        int threads = processors <= 2 ? processors : (int)Math.ceil((double)Integer.min(processors, 16) / 2.0);
        return Executors.newWorkStealingPool(threads);
    }

    public static ExecutorService getExecutorService(int threads) {
        return threads == -1 ? ThreadUtils.getExecutorServiceForProcessors(Runtime.getRuntime().availableProcessors()) : Executors.newWorkStealingPool(threads);
    }

    public static ExecutorService getExecutorService(InternalOptions options) {
        return ThreadUtils.getExecutorService(options.numberOfThreads);
    }
}

