/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import shadow.bundletool.com.android.tools.r8.ByteDataView;
import shadow.bundletool.com.android.tools.r8.DataEntryResource;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.ByteStreams;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.Closer;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class ZipUtils {
    public static void writeResourcesToZip(List<ProgramResource> resources, Set<DataEntryResource> dataResources, Closer closer, ZipOutputStream out) throws IOException, ResourceException {
        for (ProgramResource resource : resources) {
            assert (resource.getClassDescriptors().size() == 1);
            Iterator<String> iterator2 = resource.getClassDescriptors().iterator();
            String className = iterator2.next();
            String entryName = DescriptorUtils.getClassFileName(className);
            byte[] bytes = ByteStreams.toByteArray(closer.register(resource.getByteStream()));
            ZipUtils.writeToZipStream(out, entryName, bytes, 8);
        }
        for (DataEntryResource dataResource : dataResources) {
            String entryName = dataResource.getName();
            byte[] bytes = ByteStreams.toByteArray(closer.register(dataResource.getByteStream()));
            ZipUtils.writeToZipStream(out, entryName, bytes, 8);
        }
    }

    public static void iter(String zipFileStr, OnEntryHandler handler) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipFileStr, StandardCharsets.UTF_8);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream entryStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    handler.onEntry(entry, entryStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entryStream == null) continue;
                    ZipUtils.$closeResource(throwable, entryStream);
                }
            }
        }
    }

    public static void zip(Path zipFile, Path inputDirectory) throws IOException {
        try (ZipOutputStream stream = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
            List files = Files.walk(inputDirectory, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toList());
            for (Path path2 : files) {
                ZipEntry zipEntry = new ZipEntry(inputDirectory.relativize(path2).toString());
                stream.putNextEntry(zipEntry);
                Files.copy(path2, stream);
                stream.closeEntry();
            }
        }
    }

    public static List<File> unzip(String zipFile, File outDirectory) throws IOException {
        return ZipUtils.unzip(zipFile, outDirectory, entry -> true);
    }

    public static List<File> unzip(String zipFile, File outDirectory, Predicate<ZipEntry> filter) throws IOException {
        Path outDirectoryPath = outDirectory.toPath();
        ArrayList<File> outFiles = new ArrayList<File>();
        ZipUtils.iter(zipFile, (entry, input) -> {
            String name = entry.getName();
            if (!entry.isDirectory() && filter.test(entry)) {
                if (name.contains("..")) {
                    throw new CompilationError("Invalid entry name \"" + name + "\"");
                }
                Path outPath = outDirectoryPath.resolve(name);
                File outFile = outPath.toFile();
                outFile.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(outFile);
                Throwable throwable = null;
                try {
                    ByteStreams.copy(input, output);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    ZipUtils.$closeResource(throwable, output);
                }
                outFiles.add(outFile);
            }
        });
        return outFiles;
    }

    public static void writeToZipStream(ZipOutputStream stream, String entry, byte[] content, int compressionMethod) throws IOException {
        ZipUtils.writeToZipStream(stream, entry, ByteDataView.of(content), compressionMethod);
    }

    public static void writeToZipStream(ZipOutputStream stream, String entry, ByteDataView content, int compressionMethod) throws IOException {
        byte[] buffer = content.getBuffer();
        int offset = content.getOffset();
        int length = content.getLength();
        CRC32 crc = new CRC32();
        crc.update(buffer, offset, length);
        ZipEntry zipEntry = new ZipEntry(entry);
        zipEntry.setMethod(compressionMethod);
        zipEntry.setSize(length);
        zipEntry.setCrc(crc.getValue());
        zipEntry.setTime(0L);
        stream.putNextEntry(zipEntry);
        stream.write(buffer, offset, length);
        stream.closeEntry();
    }

    public static boolean isDexFile(String entry) {
        String name = entry.toLowerCase();
        return name.endsWith(".dex");
    }

    public static boolean isClassFile(String entry) {
        String name = entry.toLowerCase();
        if (name.endsWith("module-info.class")) {
            return false;
        }
        if (name.startsWith("meta-inf") || name.startsWith("/meta-inf")) {
            return false;
        }
        return name.endsWith(".class");
    }

    public static interface OnEntryHandler {
        public void onEntry(ZipEntry var1, InputStream var2) throws IOException;
    }
}

