/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.google.common.base.Optional;
import com.google.common.io.ByteSource;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

@Immutable
public final class InputStreamSupplier {
    private final SupplierWithIO<InputStream> inputSupplier;
    private final SupplierWithIO<Long> sizeSupplier;

    public InputStreamSupplier(SupplierWithIO<InputStream> inputSupplier, SupplierWithIO<Long> sizeSupplier) {
        this.inputSupplier = inputSupplier;
        this.sizeSupplier = sizeSupplier;
    }

    public InputStreamSupplier(SupplierWithIO<InputStream> inputSupplier, long size) {
        this(inputSupplier, () -> size);
    }

    @MustBeClosed
    public InputStream get() throws IOException {
        return this.inputSupplier.get();
    }

    public long sizeBytes() throws IOException {
        return this.sizeSupplier.get();
    }

    public ByteSource asByteSource() {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return (InputStream)InputStreamSupplier.this.inputSupplier.get();
            }

            public Optional<Long> sizeIfKnown() {
                try {
                    return Optional.of(InputStreamSupplier.this.sizeSupplier.get());
                }
                catch (IOException e4) {
                    throw new UncheckedIOException(e4);
                }
            }
        };
    }

    @Immutable
    public static interface SupplierWithIO<T> {
        public T get() throws IOException;
    }
}

