/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.converter;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.utils.xml.XmlValidator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BundleConfigXmlToProtoConverter {
    private static final String SCHEMA_PATH = "xsd/config.xsd";

    public Config.BundleConfig convert(String xml) {
        return this.convert(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    public Config.BundleConfig convert(InputStream xml) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Document doc = new XmlValidator(classLoader.getResource(SCHEMA_PATH)).validate(xml);
        return this.convertFromElement(doc.getDocumentElement());
    }

    private Config.BundleConfig convertFromElement(Element configElement) {
        Config.BundleConfig.Builder bundleConfig = Config.BundleConfig.newBuilder();
        int numChildren = configElement.getChildNodes().getLength();
        block6: for (int i = 0; i < numChildren; ++i) {
            Element childNode = (Element)configElement.getChildNodes().item(i);
            switch (childNode.getLocalName()) {
                case "optimizations": {
                    bundleConfig.setOptimizations(this.readOptimizationsElement(childNode));
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("XML passed schema validation but unsupported XML element found: " + childNode.getLocalName());
                }
            }
        }
        return this.validate(bundleConfig.build());
    }

    private Config.BundleConfig validate(Config.BundleConfig config) {
        List<Config.SplitDimension> splitDimensions = config.getOptimizations().getSplitsConfig().getSplitDimensionList();
        HashSet<Config.SplitDimension.Value> dimensionsSeen = new HashSet<Config.SplitDimension.Value>();
        for (Config.SplitDimension dimension : splitDimensions) {
            if (dimensionsSeen.add(dimension.getValue())) continue;
            throw ValidationException.builder().withMessage("Element <split-by> defined twice for dimension %s.", new Object[]{dimension.getValue()}).build();
        }
        return config;
    }

    private Config.Optimizations readOptimizationsElement(Element optimizationsElement) {
        Config.Optimizations.Builder optimizations = Config.Optimizations.newBuilder();
        int numChildren = optimizationsElement.getChildNodes().getLength();
        block6: for (int i = 0; i < numChildren; ++i) {
            Element childNode = (Element)optimizationsElement.getChildNodes().item(i);
            switch (childNode.getLocalName()) {
                case "splits": {
                    optimizations.setSplitsConfig(this.readSplitsConfigElement(childNode));
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("XML passed schema validation but unsupported XML element found: " + childNode.getLocalName());
                }
            }
        }
        return optimizations.build();
    }

    private Config.SplitsConfig readSplitsConfigElement(Element splitsConfigElement) {
        Config.SplitsConfig.Builder splitsConfig = Config.SplitsConfig.newBuilder();
        int numChildren = splitsConfigElement.getChildNodes().getLength();
        block6: for (int i = 0; i < numChildren; ++i) {
            Element childNode = (Element)splitsConfigElement.getChildNodes().item(i);
            switch (childNode.getLocalName()) {
                case "split-by": {
                    splitsConfig.addSplitDimension(this.readSplitDimension(childNode));
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("XML passed schema validation but unsupported XML element found: " + childNode.getLocalName());
                }
            }
        }
        return splitsConfig.build();
    }

    private Config.SplitDimension readSplitDimension(Element splitDimensionElement) {
        Config.SplitDimension.Builder splitDimension = Config.SplitDimension.newBuilder();
        splitDimension.setValue(Config.SplitDimension.Value.valueOf(splitDimensionElement.getAttribute("value")));
        if (splitDimensionElement.getAttribute("enabled").equalsIgnoreCase("false")) {
            splitDimension.setNegate(true);
        }
        return splitDimension.build();
    }
}

